#!/opt/local/bin/perl
use XML::Simple;
use Getopt::Std;
use File::Glob;
use Data::Dumper;
use strict;

our %LANGS = (
        'fr' => 'French',
        'ja' => 'Japanese',
        'de' => 'German',
        'es' => 'Spanish',
        'ko' => 'Korean',
        'tr' => 'Turkish',
        'zh-cn' => 'Simplified Chinese'
        );

my @engfiles = glob '*.xml mod/*.xml ssl/*.xml vhosts/*.xml programs/*.xml rewrite/*.xml';

print qq~<?xml version="1.0"?>
<document>
  <properties>
    <title>Available Translations - Documentation Project</title>
  </properties>
<body>
<section>
<title>Available Translations of the Documentation</title>

<!--
This document is generated by a script located in the build/ directory
of the httpd-trunk docs. Please don't attempt to edit this by hand, as
it will be overwritten.
-->

<p>The following modules have already been translated. If you are able
to provide translations into any of these languages (or any others)
please let us know. 
(<a href="translations.html">Back to translations page</a>)</p>

<table border="1">
<tr><th>Document</th>
~;

foreach my $l ( sort keys %LANGS ) {
    print '<th>'.$LANGS{$l}.'</th>';
}
print qq~
</tr>
~;

foreach my $doc ( sort @engfiles ) {
    print '<tr><td>'.$doc.'</td>';
    my %trans;
    foreach my $t ( glob $doc.'.*' ) {
        next if $t =~ m/meta$/;
        my $lang = $t;
        $lang =~ s/.+\.([^.]+)$/$1/;
        $trans{ $lang } = 1;
    }
    foreach my $l ( sort keys %LANGS ) {
        if ( $trans{$l} ) {
            print '<td>&#10004;</td>';
        } else {
            print '<td>-</td>';
        }
    }
    print "</tr>\n";
}

print qq~ 
</table>
</section>
</body>
</document>
~;


