/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.testing.reactive;

import io.reactivex.Flowable;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import org.apache.hc.core5.function.Callback;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.MethodNotSupportedException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.impl.BasicEntityDetails;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.nio.ResponseChannel;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.reactive.ReactiveRequestProcessor;
import org.apache.hc.core5.testing.reactive.ReactiveTestUtils;
import org.reactivestreams.Publisher;

public class ReactiveRandomProcessor
implements ReactiveRequestProcessor {
    public void processRequest(HttpRequest request, EntityDetails entityDetails, ResponseChannel responseChannel, HttpContext context, Publisher<ByteBuffer> requestBody, Callback<Publisher<ByteBuffer>> responseBodyCallback) throws HttpException, IOException {
        long n;
        URI uri;
        String method = request.getMethod();
        if (!("GET".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method) || "POST".equalsIgnoreCase(method) || "PUT".equalsIgnoreCase(method))) {
            throw new MethodNotSupportedException(method + " not supported by " + this.getClass().getName());
        }
        try {
            uri = request.getUri();
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException(ex.getMessage(), (Throwable)ex);
        }
        String path = uri.getPath();
        int slash = path.lastIndexOf(47);
        if (slash != -1) {
            String payload = path.substring(slash + 1);
            if (!payload.isEmpty()) {
                try {
                    n = Long.parseLong(payload);
                }
                catch (NumberFormatException ex) {
                    throw new ProtocolException("Invalid request path: " + path);
                }
            } else {
                n = 1 + (int)(Math.random() * 79.0);
            }
            if (new BasicHeader("Expect", (Object)"100-continue").equals(request.getHeader("Expect"))) {
                responseChannel.sendInformation((HttpResponse)new BasicHttpResponse(100), context);
            }
        } else {
            throw new ProtocolException("Invalid request path: " + path);
        }
        BasicHttpResponse response = new BasicHttpResponse(200);
        Flowable<ByteBuffer> stream = ReactiveTestUtils.produceStream(n);
        String hash = ReactiveTestUtils.getStreamHash(n);
        response.addHeader("response-hash-code", (Object)hash);
        BasicEntityDetails basicEntityDetails = new BasicEntityDetails(n, ContentType.APPLICATION_OCTET_STREAM);
        responseChannel.sendResponse((HttpResponse)response, (EntityDetails)basicEntityDetails, context);
        responseBodyCallback.execute(stream);
    }
}

