/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fileexists;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.fileexists.FileExistsMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.pipeline.transform.ComponentSelectionListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class FileExistsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = FileExistsMeta.class;
    private boolean gotPreviousFields = false;
    private CCombo wFileName;
    private Label wlFileType;
    private TextVar wResult;
    private TextVar wFileType;
    private Button wInclFileType;
    private Button wAddResult;
    private final FileExistsMeta input;

    public FileExistsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (FileExistsMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        FileExistsDialog fileExistsDialog = this;
        int margin = fileExistsDialog.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label wlFileName = new Label((Composite)this.shell, 131072);
        wlFileName.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.FileName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileName);
        FormData fdlFileName = new FormData();
        fdlFileName.left = new FormAttachment(0, 0);
        fdlFileName.right = new FormAttachment(middle, -margin);
        fdlFileName.top = new FormAttachment((Control)this.wTransformName, margin);
        wlFileName.setLayoutData((Object)fdlFileName);
        this.wFileName = new CCombo((Composite)this.shell, 2056);
        PropsUi.setLook((Widget)this.wFileName);
        this.wFileName.addModifyListener(lsMod);
        FormData fdFileName = new FormData();
        fdFileName.left = new FormAttachment(middle, 0);
        fdFileName.top = new FormAttachment((Control)this.wTransformName, margin);
        fdFileName.right = new FormAttachment(100, -margin);
        this.wFileName.setLayoutData((Object)fdFileName);
        this.wFileName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FileExistsDialog.this.shell.getDisplay(), 1);
                FileExistsDialog.this.shell.setCursor(busy);
                FileExistsDialog.this.get();
                FileExistsDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        Label wlResult = new Label((Composite)this.shell, 131072);
        wlResult.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.ResultField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlResult);
        FormData fdlResult = new FormData();
        fdlResult.left = new FormAttachment(0, 0);
        fdlResult.right = new FormAttachment(middle, -margin);
        fdlResult.top = new FormAttachment((Control)this.wFileName, margin * 2);
        wlResult.setLayoutData((Object)fdlResult);
        this.wResult = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"FileExistsDialog.ResultField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wResult);
        this.wResult.addModifyListener(lsMod);
        FormData fdResult = new FormData();
        fdResult.left = new FormAttachment(middle, 0);
        fdResult.top = new FormAttachment((Control)this.wFileName, margin * 2);
        fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)fdResult);
        Label wlAddResult = new Label((Composite)this.shell, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wResult, margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)this.shell, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"FileExistsDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        Group wAdditionalFields = new Group((Composite)this.shell, 32);
        PropsUi.setLook((Widget)wAdditionalFields);
        wAdditionalFields.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.wAdditionalFields.Label", (String[])new String[0]));
        FormLayout additionalFieldsgroupLayout = new FormLayout();
        additionalFieldsgroupLayout.marginWidth = 10;
        additionalFieldsgroupLayout.marginHeight = 10;
        wAdditionalFields.setLayout((Layout)additionalFieldsgroupLayout);
        Label wlInclFileType = new Label((Composite)wAdditionalFields, 131072);
        wlInclFileType.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.InclFileType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclFileType);
        FormData fdlInclFileType = new FormData();
        fdlInclFileType.left = new FormAttachment(0, 0);
        fdlInclFileType.top = new FormAttachment((Control)this.wResult, margin);
        fdlInclFileType.right = new FormAttachment(middle, -margin);
        wlInclFileType.setLayoutData((Object)fdlInclFileType);
        this.wInclFileType = new Button((Composite)wAdditionalFields, 32);
        PropsUi.setLook((Widget)this.wInclFileType);
        this.wInclFileType.setToolTipText(BaseMessages.getString(PKG, (String)"FileExistsDialog.InclFileType.Tooltip", (String[])new String[0]));
        FormData fdInclFileType = new FormData();
        fdInclFileType.left = new FormAttachment(middle, 0);
        fdInclFileType.top = new FormAttachment((Control)wlInclFileType, 0, 0x1000000);
        this.wInclFileType.setLayoutData((Object)fdInclFileType);
        this.wInclFileType.addSelectionListener((SelectionListener)new ComponentSelectionListener((BaseTransformMeta)this.input));
        this.wInclFileType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileExistsDialog.this.activeFileType();
            }
        });
        this.wlFileType = new Label((Composite)wAdditionalFields, 131072);
        this.wlFileType.setText(BaseMessages.getString(PKG, (String)"FileExistsDialog.FileTypeField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFileType);
        FormData fdlFileType = new FormData();
        fdlFileType.left = new FormAttachment((Control)this.wInclFileType, 2 * margin);
        fdlFileType.top = new FormAttachment((Control)this.wResult, margin);
        this.wlFileType.setLayoutData((Object)fdlFileType);
        this.wFileType = new TextVar(this.variables, (Composite)wAdditionalFields, 18436);
        this.wFileType.setToolTipText(BaseMessages.getString(PKG, (String)"FileExistsDialog.FileTypeField.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFileType);
        this.wFileType.addModifyListener(lsMod);
        FormData fdFileType = new FormData();
        fdFileType.left = new FormAttachment((Control)this.wlFileType, margin);
        fdFileType.top = new FormAttachment((Control)this.wResult, margin);
        fdFileType.right = new FormAttachment(100, 0);
        this.wFileType.setLayoutData((Object)fdFileType);
        FormData fdAdditionalFields = new FormData();
        fdAdditionalFields.left = new FormAttachment(0, margin);
        fdAdditionalFields.top = new FormAttachment((Control)this.wAddResult, margin);
        fdAdditionalFields.right = new FormAttachment(100, -margin);
        fdAdditionalFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wAdditionalFields.setLayoutData((Object)fdAdditionalFields);
        this.getData();
        this.activeFileType();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void activeFileType() {
        this.wlFileType.setEnabled(this.wInclFileType.getSelection());
        this.wFileType.setEnabled(this.wInclFileType.getSelection());
    }

    public void getData() {
        if (this.input.getFilenamefield() != null) {
            this.wFileName.setText(this.input.getFilenamefield());
        }
        if (this.input.getResultfieldname() != null) {
            this.wResult.setText(this.input.getResultfieldname());
        }
        this.wInclFileType.setSelection(this.input.isIncludefiletype());
        if (this.input.getFiletypefieldname() != null) {
            this.wFileType.setText(this.input.getFiletypefieldname());
        }
        this.wAddResult.setSelection(this.input.isAddresultfilenames());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setFilenamefield(this.wFileName.getText());
        this.input.setResultfieldname(this.wResult.getText());
        this.input.setIncludefiletype(this.wInclFileType.getSelection());
        this.input.setFiletypefieldname(this.wFileType.getText());
        this.input.setAddresultfilenames(this.wAddResult.getSelection());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String fieldvalue = this.wFileName.getText();
                this.wFileName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wFileName.setItems(r.getFieldNames());
                }
                if (fieldvalue != null) {
                    this.wFileName.setText(fieldvalue);
                }
                this.gotPreviousFields = true;
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FileExistsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FileExistsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

