/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www.async.xp;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.AreaOwner;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.file.workflow.HopGuiWorkflowGraph;
import org.apache.hop.ui.hopgui.file.workflow.extension.HopGuiWorkflowGraphExtension;
import org.apache.hop.www.async.AsyncWebService;

@ExtensionPoint(id="ActionLogIconClickedExtensionPoint", extensionPointId="WorkflowGraphMouseUp", description="Edit the async web service associated with the logging on click & mouse up")
public class ActionLogIconClickedExtensionPoint
implements IExtensionPoint<HopGuiWorkflowGraphExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, HopGuiWorkflowGraphExtension extension) throws HopException {
        HopGuiWorkflowGraph workflowGraph = extension.getWorkflowGraph();
        AreaOwner areaOwner = extension.getAreaOwner();
        if (areaOwner == null) {
            return;
        }
        if (areaOwner.getAreaType() == AreaOwner.AreaType.CUSTOM) {
            MultiMetadataProvider metadataProvider;
            IHopMetadataSerializer serializer;
            String serviceName;
            String message;
            if (areaOwner.getOwner() == null) {
                return;
            }
            if (areaOwner.getOwner() instanceof String && (message = (String)areaOwner.getOwner()).startsWith("Report pipeline async stats to service ") && StringUtils.isNotEmpty((String)(serviceName = message.substring("Report pipeline async stats to service ".length()))) && (serializer = (metadataProvider = workflowGraph.getHopGui().getMetadataProvider()).getSerializer(AsyncWebService.class)).exists(serviceName)) {
                MetadataManager manager = new MetadataManager(workflowGraph.getVariables(), (IHopMetadataProvider)metadataProvider, AsyncWebService.class, extension.getWorkflowGraph().getShell());
                manager.editMetadata(serviceName);
                extension.setPreventingDefault(true);
            }
        }
    }
}

