/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.settings.ClickHouseQueryParam;

public class ClickhouseJdbcUrlParser {
    private static final Logger log = LoggerFactory.getLogger(ClickhouseJdbcUrlParser.class);
    protected static final String DEFAULT_DATABASE = "default";
    public static final String JDBC_PREFIX = "jdbc:";
    public static final String JDBC_CLICKHOUSE_PREFIX = "jdbc:clickhouse:";
    public static final Pattern DB_PATH_PATTERN = Pattern.compile("/([a-zA-Z0-9_*\\-]+)");

    private ClickhouseJdbcUrlParser() {
    }

    private static String decode(String str) {
        try {
            return URLDecoder.decode(str, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            log.warn((Object)"Failed to decode given string, fallback to the original string", new Object[0]);
            return str;
        }
    }

    private static ClickHouseProperties parseClickhouseUrl(String uriString, Properties defaults) throws URISyntaxException {
        URI uri = new URI(uriString);
        Properties urlProperties = ClickhouseJdbcUrlParser.parseUriQueryPart(uri.getQuery(), defaults);
        ClickHouseProperties props = new ClickHouseProperties(urlProperties);
        String host = uri.getHost();
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host is missed or wrong");
        }
        props.setHost(uri.getHost());
        int port = uri.getPort();
        if (port == -1) {
            port = props.getProtocol().getDefaultPort();
        }
        props.setPort(port);
        String credentials = uri.getRawUserInfo();
        if (credentials != null && !credentials.isEmpty()) {
            String password;
            String userName;
            int index = credentials.indexOf(58);
            String string = index == 0 ? "" : (userName = ClickhouseJdbcUrlParser.decode(index > 0 ? credentials.substring(0, index) : credentials));
            if (!userName.isEmpty()) {
                props.setUser(userName);
            }
            String string2 = password = index < 0 ? "" : ClickhouseJdbcUrlParser.decode(credentials.substring(index + 1));
            if (!password.isEmpty()) {
                props.setPassword(password);
            }
        }
        String path = uri.getPath();
        if (props.isUsePathAsDb()) {
            String database;
            if (path == null || path.isEmpty() || path.equals("/")) {
                String defaultsDb = defaults.getProperty(ClickHouseQueryParam.DATABASE.getKey());
                database = defaultsDb == null ? DEFAULT_DATABASE : defaultsDb;
            } else {
                Matcher m = DB_PATH_PATTERN.matcher(path);
                if (m.matches()) {
                    database = m.group(1);
                } else {
                    throw new URISyntaxException("wrong database name path: '" + path + "'", uriString);
                }
            }
            props.setDatabase(database);
        } else {
            if (props.getDatabase() == null || props.getDatabase().isEmpty()) {
                props.setDatabase(DEFAULT_DATABASE);
            }
            if (path == null || path.isEmpty()) {
                props.setPath("/");
            } else {
                props.setPath(path);
            }
        }
        return props;
    }

    static Properties parseUriQueryPart(String query, Properties defaults) {
        String[] queryKeyValues;
        if (query == null) {
            return defaults;
        }
        Properties urlProps = new Properties(defaults);
        for (String keyValue : queryKeyValues = query.split("&")) {
            String[] keyValueTokens = keyValue.split("=");
            if (keyValueTokens.length == 2) {
                urlProps.put(keyValueTokens[0], keyValueTokens[1]);
                continue;
            }
            log.warn((Object)"don't know how to handle parameter pair: %s", keyValue);
        }
        return urlProps;
    }

    public static ClickHouseProperties parse(String jdbcUrl, Properties defaults) throws URISyntaxException {
        if (!jdbcUrl.startsWith(JDBC_CLICKHOUSE_PREFIX)) {
            throw new URISyntaxException(jdbcUrl, "'jdbc:clickhouse:' prefix is mandatory");
        }
        return ClickhouseJdbcUrlParser.parseClickhouseUrl(jdbcUrl.substring(JDBC_PREFIX.length()), defaults);
    }
}

