/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.internal.grpc.stub;

import com.clickhouse.client.internal.google.common.base.Preconditions;
import com.clickhouse.client.internal.grpc.ExperimentalApi;
import com.clickhouse.client.internal.grpc.stub.CallStreamObserver;
import java.util.Iterator;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4694")
public final class StreamObservers {
    public static <V> void copyWithFlowControl(final Iterator<V> source, final CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        Preconditions.checkNotNull(target, "target");
        final class FlowControllingOnReadyHandler
        implements Runnable {
            private boolean completed;

            FlowControllingOnReadyHandler() {
            }

            @Override
            public void run() {
                if (this.completed) {
                    return;
                }
                while (target.isReady() && source.hasNext()) {
                    target.onNext(source.next());
                }
                if (!source.hasNext()) {
                    this.completed = true;
                    target.onCompleted();
                }
            }
        }
        target.setOnReadyHandler(new FlowControllingOnReadyHandler());
    }

    public static <V> void copyWithFlowControl(Iterable<V> source, CallStreamObserver<V> target) {
        Preconditions.checkNotNull(source, "source");
        StreamObservers.copyWithFlowControl(source.iterator(), target);
    }
}

