/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.TeamFolderIdArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

class TeamFolderArchiveArg
extends TeamFolderIdArg {
    protected final boolean forceAsyncOff;

    public TeamFolderArchiveArg(String teamFolderId, boolean forceAsyncOff) {
        super(teamFolderId);
        this.forceAsyncOff = forceAsyncOff;
    }

    public TeamFolderArchiveArg(String teamFolderId) {
        this(teamFolderId, false);
    }

    @Override
    public String getTeamFolderId() {
        return this.teamFolderId;
    }

    public boolean getForceAsyncOff() {
        return this.forceAsyncOff;
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.forceAsyncOff});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamFolderArchiveArg other = (TeamFolderArchiveArg)obj;
            return (this.teamFolderId == other.teamFolderId || this.teamFolderId.equals(other.teamFolderId)) && this.forceAsyncOff == other.forceAsyncOff;
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamFolderArchiveArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderArchiveArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_folder_id");
            StoneSerializers.string().serialize(value.teamFolderId, g);
            g.writeFieldName("force_async_off");
            StoneSerializers.boolean_().serialize((Boolean)value.forceAsyncOff, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamFolderArchiveArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_forceAsyncOff;
            String f_teamFolderId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamFolderId = null;
                f_forceAsyncOff = false;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_folder_id".equals(field)) {
                        f_teamFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("force_async_off".equals(field)) {
                        f_forceAsyncOff = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamFolderId == null) {
                    throw new JsonParseException(p, "Required field \"team_folder_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamFolderArchiveArg value = new TeamFolderArchiveArg(f_teamFolderId, f_forceAsyncOff);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

