/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.fileproperties.PropertyFieldTemplate;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class UpdateTemplateArg {
    protected final String templateId;
    protected final String name;
    protected final String description;
    protected final List<PropertyFieldTemplate> addFields;

    public UpdateTemplateArg(String templateId, String name, String description, List<PropertyFieldTemplate> addFields) {
        if (templateId == null) {
            throw new IllegalArgumentException("Required value for 'templateId' is null");
        }
        if (templateId.length() < 1) {
            throw new IllegalArgumentException("String 'templateId' is shorter than 1");
        }
        if (!Pattern.matches("(/|ptid:).*", templateId)) {
            throw new IllegalArgumentException("String 'templateId' does not match pattern");
        }
        this.templateId = templateId;
        this.name = name;
        this.description = description;
        if (addFields != null) {
            for (PropertyFieldTemplate x : addFields) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'addFields' is null");
            }
        }
        this.addFields = addFields;
    }

    public UpdateTemplateArg(String templateId) {
        this(templateId, null, null, null);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PropertyFieldTemplate> getAddFields() {
        return this.addFields;
    }

    public static Builder newBuilder(String templateId) {
        return new Builder(templateId);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.templateId, this.name, this.description, this.addFields});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UpdateTemplateArg other = (UpdateTemplateArg)obj;
            return (this.templateId == other.templateId || this.templateId.equals(other.templateId)) && (this.name == other.name || this.name != null && this.name.equals(other.name)) && (this.description == other.description || this.description != null && this.description.equals(other.description)) && (this.addFields == other.addFields || this.addFields != null && this.addFields.equals(other.addFields));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends StructSerializer<UpdateTemplateArg> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(UpdateTemplateArg value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("template_id");
            StoneSerializers.string().serialize(value.templateId, g);
            if (value.name != null) {
                g.writeFieldName("name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.name, g);
            }
            if (value.description != null) {
                g.writeFieldName("description");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.description, g);
            }
            if (value.addFields != null) {
                g.writeFieldName("add_fields");
                StoneSerializers.nullable(StoneSerializers.list(PropertyFieldTemplate.Serializer.INSTANCE)).serialize(value.addFields, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public UpdateTemplateArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<PropertyFieldTemplate> f_addFields;
            String f_description;
            String f_name;
            String f_templateId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_templateId = null;
                f_name = null;
                f_description = null;
                f_addFields = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("template_id".equals(field)) {
                        f_templateId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("description".equals(field)) {
                        f_description = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("add_fields".equals(field)) {
                        f_addFields = StoneSerializers.nullable(StoneSerializers.list(PropertyFieldTemplate.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_templateId == null) {
                    throw new JsonParseException(p, "Required field \"template_id\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UpdateTemplateArg value = new UpdateTemplateArg(f_templateId, f_name, f_description, f_addFields);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String templateId;
        protected String name;
        protected String description;
        protected List<PropertyFieldTemplate> addFields;

        protected Builder(String templateId) {
            if (templateId == null) {
                throw new IllegalArgumentException("Required value for 'templateId' is null");
            }
            if (templateId.length() < 1) {
                throw new IllegalArgumentException("String 'templateId' is shorter than 1");
            }
            if (!Pattern.matches("(/|ptid:).*", templateId)) {
                throw new IllegalArgumentException("String 'templateId' does not match pattern");
            }
            this.templateId = templateId;
            this.name = null;
            this.description = null;
            this.addFields = null;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder withAddFields(List<PropertyFieldTemplate> addFields) {
            if (addFields != null) {
                for (PropertyFieldTemplate x : addFields) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'addFields' is null");
                }
            }
            this.addFields = addFields;
            return this;
        }

        public UpdateTemplateArg build() {
            return new UpdateTemplateArg(this.templateId, this.name, this.description, this.addFields);
        }
    }
}

