/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.execinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.Execution;
import org.apache.hop.execution.ExecutionData;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.ExecutionState;
import org.apache.hop.execution.ExecutionType;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.execinfo.ExecInfoData;
import org.apache.hop.pipeline.transforms.execinfo.ExecInfoMeta;
import org.json.simple.JSONObject;

public class ExecInfo
extends BaseTransform<ExecInfoMeta, ExecInfoData> {
    private static final Class<?> PKG = ExecInfoMeta.class;
    private boolean killing;
    private CountDownLatch waitForLatch;

    public ExecInfo(TransformMeta transformMeta, ExecInfoMeta meta, ExecInfoData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] inputRow = this.getRow();
        if (inputRow == null) {
            this.setOutputDone();
            return false;
        }
        ExecInfoMeta.OperationType type = ((ExecInfoMeta)this.meta).getOperationType();
        if (this.first) {
            this.first = false;
            ((ExecInfoData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((ExecInfoMeta)this.meta).getFields(((ExecInfoData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            this.verifyField(this.resolve(((ExecInfoMeta)this.meta).getIdFieldName()), type.isAcceptingExecutionId());
            this.verifyField(this.resolve(((ExecInfoMeta)this.meta).getParentIdFieldName()), type.isAcceptingParentExecutionId());
            this.verifyField(this.resolve(((ExecInfoMeta)this.meta).getTypeFieldName()), type.isAcceptingExecutionType());
            this.verifyField(this.resolve(((ExecInfoMeta)this.meta).getNameFieldName()), type.isAcceptingName());
            this.verifyField(this.resolve(((ExecInfoMeta)this.meta).getIncludeChildrenFieldName()), type.isAcceptingIncludeChildren());
            this.verifyField(this.resolve(((ExecInfoMeta)this.meta).getLimitFieldName()), type.isAcceptingLimit());
        }
        switch (type) {
            case GetExecutionIds: {
                this.getExecutionIds(this.getInputRowMeta(), inputRow);
                break;
            }
            case GetExecutionAndState: {
                this.getExecutionAndState(this.getInputRowMeta(), inputRow);
                break;
            }
            case FindExecutions: {
                this.findExecutions(this.getInputRowMeta(), inputRow);
                break;
            }
            case DeleteExecution: {
                this.deleteExecution(this.getInputRowMeta(), inputRow);
                break;
            }
            case FindPreviousSuccessfulExecution: {
                this.findPreviousSuccessfulExecution(this.getInputRowMeta(), inputRow);
                break;
            }
            case FindChildIds: {
                this.findChildIds(this.getInputRowMeta(), inputRow);
                break;
            }
            case FindLastExecution: {
                this.findLastExecution(this.getInputRowMeta(), inputRow);
                break;
            }
            case FindParentId: {
                this.findParentId(this.getInputRowMeta(), inputRow);
                break;
            }
            case GetExecutionData: {
                this.getExecutionData(this.getInputRowMeta(), inputRow);
            }
        }
        return true;
    }

    private void getExecutionIds(IRowMeta rowMeta, Object[] row) throws HopException {
        boolean includeChildren = this.getValueIncludeChildren(rowMeta, row);
        int limit = this.getValueLimit(rowMeta, row);
        List executionIds = ((ExecInfoData)this.data).location.getExecutionInfoLocation().getExecutionIds(includeChildren, limit);
        for (String executionId : executionIds) {
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((ExecInfoData)this.data).outputRowMeta.size());
            int index = rowMeta.size();
            outputRow[index] = executionId;
            this.putRow(((ExecInfoData)this.data).outputRowMeta, outputRow);
        }
    }

    private void getExecutionAndState(IRowMeta rowMeta, Object[] row) throws HopException {
        this.outputExecutionAndState(rowMeta, row, this.getValueExecutionId(rowMeta, row));
    }

    private void findExecutions(IRowMeta rowMeta, Object[] row) throws HopException {
        String parentId = this.getValueParentId(rowMeta, row);
        List executions = ((ExecInfoData)this.data).location.getExecutionInfoLocation().findExecutions(parentId);
        for (Execution execution : executions) {
            this.outputExecutionAndState(rowMeta, row, execution.getId());
        }
    }

    private void deleteExecution(IRowMeta rowMeta, Object[] row) throws HopException {
        String executionId = this.getValueExecutionId(rowMeta, row);
        boolean deleted = ((ExecInfoData)this.data).location.getExecutionInfoLocation().deleteExecution(executionId);
        Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((ExecInfoData)this.data).outputRowMeta.size());
        int index = rowMeta.size();
        outputRow[index] = deleted;
        this.putRow(((ExecInfoData)this.data).outputRowMeta, outputRow);
    }

    private void findPreviousSuccessfulExecution(IRowMeta rowMeta, Object[] row) throws HopException {
        ExecutionType executionType = this.getValueExecutionType(rowMeta, row);
        String name = this.getValueName(rowMeta, row);
        Execution execution = ((ExecInfoData)this.data).location.getExecutionInfoLocation().findPreviousSuccessfulExecution(executionType, name);
        this.outputExecutionAndState(rowMeta, row, execution);
    }

    private void findChildIds(IRowMeta rowMeta, Object[] row) throws HopException {
        String parentExecutionId = this.getValueParentId(rowMeta, row);
        ExecutionType parentExecutionType = this.getValueExecutionType(rowMeta, row);
        List executionIds = ((ExecInfoData)this.data).location.getExecutionInfoLocation().findChildIds(parentExecutionType, parentExecutionId);
        for (String executionId : executionIds) {
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((ExecInfoData)this.data).outputRowMeta.size());
            int index = rowMeta.size();
            outputRow[index] = executionId;
            this.putRow(((ExecInfoData)this.data).outputRowMeta, outputRow);
        }
    }

    private void findLastExecution(IRowMeta rowMeta, Object[] row) throws HopException {
        ExecutionType executionType = this.getValueExecutionType(rowMeta, row);
        String name = this.getValueName(rowMeta, row);
        Execution execution = ((ExecInfoData)this.data).location.getExecutionInfoLocation().findLastExecution(executionType, name);
        this.outputExecutionAndState(rowMeta, row, execution);
    }

    private void findParentId(IRowMeta rowMeta, Object[] row) throws HopException {
        String executionId = this.getValueExecutionId(rowMeta, row);
        String parentId = ((ExecInfoData)this.data).location.getExecutionInfoLocation().findParentId(executionId);
        if (parentId != null) {
            Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((ExecInfoData)this.data).outputRowMeta.size());
            int index = rowMeta.size();
            outputRow[index] = parentId;
            this.putRow(((ExecInfoData)this.data).outputRowMeta, outputRow);
        }
    }

    private void getExecutionData(IRowMeta rowMeta, Object[] row) throws HopException {
        String parentId = this.getValueParentId(rowMeta, row);
        String executionId = this.getValueExecutionId(rowMeta, row);
        ExecutionData executionData = ((ExecInfoData)this.data).location.getExecutionInfoLocation().getExecutionData(parentId, executionId);
        if (executionData != null) {
            for (String setKey : executionData.getDataSets().keySet()) {
                ExecutionDataSetMeta setMeta = (ExecutionDataSetMeta)executionData.getSetMetaData().get(setKey);
                RowBuffer rowBuffer = (RowBuffer)executionData.getDataSets().get(setKey);
                if (setMeta == null || rowBuffer == null) continue;
                Object[] outputBaseRow = RowDataUtil.createResizedCopy((Object[])row, (int)((ExecInfoData)this.data).outputRowMeta.size());
                int baseIndex = rowMeta.size();
                outputBaseRow[baseIndex++] = parentId;
                outputBaseRow[baseIndex++] = executionId;
                outputBaseRow[baseIndex++] = executionData.getCollectionDate();
                outputBaseRow[baseIndex++] = executionData.isFinished();
                outputBaseRow[baseIndex++] = setKey;
                outputBaseRow[baseIndex++] = setMeta.getName();
                outputBaseRow[baseIndex++] = setMeta.getCopyNr();
                outputBaseRow[baseIndex++] = setMeta.getDescription();
                outputBaseRow[baseIndex++] = setMeta.getLogChannelId();
                outputBaseRow[baseIndex++] = JsonRowMeta.toJson((IRowMeta)rowBuffer.getRowMeta());
                long rowNr = 0L;
                for (Object[] bufferRow : rowBuffer.getBuffer()) {
                    Object[] outputRow = RowDataUtil.createResizedCopy((Object[])outputBaseRow, (int)((ExecInfoData)this.data).outputRowMeta.size());
                    int index = baseIndex;
                    outputRow[index++] = ++rowNr;
                    JSONObject jsonRow = new JSONObject();
                    for (int v = 0; v < rowMeta.size(); ++v) {
                        IValueMeta valueMeta = rowMeta.getValueMeta(v);
                        jsonRow.put((Object)valueMeta.getName(), outputRow[v]);
                    }
                    outputRow[index] = jsonRow.toJSONString();
                    this.putRow(((ExecInfoData)this.data).outputRowMeta, outputRow);
                }
            }
        }
    }

    private void outputExecutionAndState(IRowMeta rowMeta, Object[] row, String executionId) throws HopException {
        Execution execution = ((ExecInfoData)this.data).location.getExecutionInfoLocation().getExecution(executionId);
        if (execution != null) {
            this.outputExecutionAndState(rowMeta, row, execution);
        }
    }

    private void outputExecutionAndState(IRowMeta rowMeta, Object[] row, Execution execution) throws HopException {
        if (execution == null) {
            return;
        }
        ExecutionState executionState = ((ExecInfoData)this.data).location.getExecutionInfoLocation().getExecutionState(execution.getId());
        Object[] outputRow = RowDataUtil.createResizedCopy((Object[])row, (int)((ExecInfoData)this.data).outputRowMeta.size());
        int index = rowMeta.size();
        outputRow[index++] = execution.getId();
        outputRow[index++] = execution.getParentId();
        outputRow[index++] = execution.getName();
        outputRow[index++] = execution.getExecutionType().name();
        outputRow[index++] = execution.getFilename();
        outputRow[index++] = execution.getExecutorXml();
        outputRow[index++] = execution.getMetadataJson();
        outputRow[index++] = execution.getRegistrationDate();
        outputRow[index++] = execution.getExecutionStartDate();
        outputRow[index++] = execution.getRunConfigurationName();
        outputRow[index++] = execution.getLogLevel();
        if (executionState != null) {
            outputRow[index++] = executionState.getUpdateTime();
            outputRow[index++] = executionState.getLoggingText();
            outputRow[index++] = executionState.isFailed();
            outputRow[index] = executionState.getStatusDescription();
        }
        this.putRow(((ExecInfoData)this.data).outputRowMeta, outputRow);
    }

    private String getValueExecutionId(IRowMeta rowMeta, Object[] row) throws HopException {
        String idField = this.resolve(((ExecInfoMeta)this.meta).getIdFieldName());
        String executionId = rowMeta.getString(row, idField, "");
        if (StringUtils.isEmpty((String)executionId)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ExecInfo.Error.PleaseProvideExecutionId", (String[])new String[]{idField}));
        }
        return executionId;
    }

    private String getValueParentId(IRowMeta rowMeta, Object[] row) throws HopException {
        String parentIdField = this.resolve(((ExecInfoMeta)this.meta).getParentIdFieldName());
        String parentId = rowMeta.getString(row, parentIdField, "");
        if (StringUtils.isEmpty((String)parentId)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ExecInfo.Error.PleaseProvideParentExecutionId", (String[])new String[]{parentIdField}));
        }
        return parentId;
    }

    private int getValueLimit(IRowMeta rowMeta, Object[] row) throws HopException {
        long limit = rowMeta.getInteger(row, this.resolve(((ExecInfoMeta)this.meta).getLimitFieldName()), Long.valueOf(0L));
        return (int)limit;
    }

    private String getValueName(IRowMeta rowMeta, Object[] row) throws HopException {
        String nameField = this.resolve(((ExecInfoMeta)this.meta).getIdFieldName());
        String name = rowMeta.getString(row, nameField, "");
        if (StringUtils.isEmpty((String)name)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ExecInfo.Error.PleaseProvideName", (String[])new String[]{nameField}));
        }
        return name;
    }

    private ExecutionType getValueExecutionType(IRowMeta rowMeta, Object[] row) throws HopException {
        String executionTypeField = this.resolve(((ExecInfoMeta)this.meta).getTypeFieldName());
        String executionType = rowMeta.getString(row, executionTypeField, "");
        if (StringUtils.isEmpty((String)executionType)) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ExecInfo.Error.PleaseProvideExecutionType", (String[])new String[]{executionTypeField}));
        }
        return ExecutionType.valueOf((String)executionType);
    }

    private boolean getValueIncludeChildren(IRowMeta rowMeta, Object[] row) throws HopException {
        boolean includeChildren = rowMeta.getBoolean(row, this.resolve(((ExecInfoMeta)this.meta).getIncludeChildrenFieldName()), Boolean.FALSE);
        return includeChildren;
    }

    private void verifyField(String fieldName, boolean required) throws HopException {
        if (required && this.getInputRowMeta().indexOfValue(fieldName) < 0) {
            throw new HopException(BaseMessages.getString((String)"ExecInfoMeta.Error.FieldDoesNotExist", (String)fieldName));
        }
    }

    public boolean init() {
        ArrayList<ICheckResult> remarks = new ArrayList<ICheckResult>();
        ((ExecInfoMeta)this.meta).check(remarks, this.getPipelineMeta(), this.getTransformMeta(), null, null, null, null, (IVariables)this, this.metadataProvider);
        boolean noRemarks = true;
        for (ICheckResult remark : remarks) {
            if (remark.getType() != 4) continue;
            this.log.logError(remark.getText());
            noRemarks = false;
        }
        if (!noRemarks) {
            return false;
        }
        try {
            ((ExecInfoData)this.data).location = (ExecutionInfoLocation)this.metadataProvider.getSerializer(ExecutionInfoLocation.class).load(this.resolve(((ExecInfoMeta)this.meta).getLocation()));
            ((ExecInfoData)this.data).location.getExecutionInfoLocation().initialize((IVariables)this, this.metadataProvider);
        }
        catch (HopException e) {
            this.log.logError("Error initializing execution information location " + ((ExecInfoMeta)this.meta).getLocation(), (Throwable)e);
            return false;
        }
        return super.init();
    }

    public void dispose() {
        if (((ExecInfoData)this.data).location != null) {
            try {
                ((ExecInfoData)this.data).location.getExecutionInfoLocation().close();
            }
            catch (Exception e) {
                this.log.logError("Error closing location " + ((ExecInfoData)this.data).location.getName(), (Throwable)e);
            }
        }
        super.dispose();
    }
}

