/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.file;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.pipeline.transform.errorhandling.IFileErrorHandler;

public class BaseFileInputTransformUtils {
    public static void handleMissingFiles(FileInputList files, ILogChannel log, boolean isErrorIgnored, IFileErrorHandler errorHandler) throws HopException {
        List nonAccessibleFiles;
        List nonExistantFiles = files.getNonExistentFiles();
        if (!nonExistantFiles.isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonExistantFiles);
            if (log.isBasic()) {
                log.logBasic("Required files", new Object[]{"WARNING: Missing " + message});
            }
            if (isErrorIgnored) {
                for (FileObject fileObject : nonExistantFiles) {
                    errorHandler.handleNonExistantFile(fileObject);
                }
            } else {
                throw new HopException("Following required files are missing: " + message);
            }
        }
        if (!(nonAccessibleFiles = files.getNonAccessibleFiles()).isEmpty()) {
            String message = FileInputList.getRequiredFilesDescription((List)nonAccessibleFiles);
            if (log.isBasic()) {
                log.logBasic("Required files", new Object[]{"WARNING: Not accessible " + message});
            }
            if (isErrorIgnored) {
                for (FileObject fileObject : nonAccessibleFiles) {
                    errorHandler.handleNonAccessibleFile(fileObject);
                }
            } else {
                throw new HopException("Following required files are not accessible: " + message);
            }
        }
    }

    public static int addValueMeta(String transformName, IRowMeta rowMeta, String fieldName) {
        ValueMetaString valueMeta = new ValueMetaString(fieldName);
        valueMeta.setOrigin(transformName);
        int index = -1;
        if (!rowMeta.exists((IValueMeta)valueMeta)) {
            index = rowMeta.size();
            rowMeta.addValueMeta((IValueMeta)valueMeta);
        } else {
            index = rowMeta.indexOfValue(fieldName);
        }
        return index;
    }
}

