/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Template;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.UnionPattern;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.XPathException;

public class RuleManager
implements Serializable {
    private Mode defaultMode;
    private HashMap modes;
    private Mode omniMode = null;

    public RuleManager() {
        this.resetHandlers();
    }

    public void resetHandlers() {
        this.defaultMode = new Mode(-1);
        this.modes = new HashMap(5);
    }

    public Mode getMode(int n) {
        if (n == -1) {
            return this.defaultMode;
        }
        if (n == -2) {
            if (this.omniMode == null) {
                this.omniMode = new Mode(-3);
            }
            return this.omniMode;
        }
        Integer n2 = new Integer(n & 0xFFFFF);
        Mode mode = (Mode)this.modes.get(n2);
        if (mode == null) {
            mode = new Mode(this.omniMode);
            this.modes.put(n2, mode);
        }
        return mode;
    }

    public void setHandler(Pattern pattern, Template template, Mode mode, int n) {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, template, mode, n);
            this.setHandler(pattern3, template, mode, n);
            return;
        }
        double d = pattern.getDefaultPriority();
        this.setHandler(pattern, template, mode, n, d);
    }

    public void setHandler(Pattern pattern, Template template, Mode mode, int n, double d) {
        if (pattern instanceof UnionPattern) {
            UnionPattern unionPattern = (UnionPattern)pattern;
            Pattern pattern2 = unionPattern.getLHS();
            Pattern pattern3 = unionPattern.getRHS();
            this.setHandler(pattern2, template, mode, n, d);
            this.setHandler(pattern3, template, mode, n, d);
            return;
        }
        mode.addRule(pattern, template, n, d);
        if (mode == this.omniMode) {
            this.defaultMode.addRule(pattern, template, n, d);
            Iterator iterator = this.modes.values().iterator();
            while (iterator.hasNext()) {
                Mode mode2 = (Mode)iterator.next();
                mode2.addRule(pattern, template, n, d);
            }
        }
    }

    public Template getTemplateRule(NodeInfo nodeInfo, Mode mode, XPathContext xPathContext) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return (Template)mode.getRule(nodeInfo, xPathContext);
    }

    public Template getTemplateRule(NodeInfo nodeInfo, Mode mode, int n, int n2, XPathContext xPathContext) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return (Template)mode.getRule(nodeInfo, n, n2, xPathContext);
    }

    public Template getNextMatchHandler(NodeInfo nodeInfo, Mode mode, Template template, XPathContext xPathContext) throws XPathException {
        if (mode == null) {
            mode = this.defaultMode;
        }
        return (Template)mode.getNextMatchRule(nodeInfo, template, xPathContext);
    }
}

