/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.helpers.EncoderHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import scala.Tuple2;
import scala.reflect.ClassTag;

public abstract class TransformTranslator<InT extends PInput, OutT extends POutput, TransformT extends PTransform<? extends InT, OutT>> {
    protected abstract void translate(TransformT var1, Context var2) throws IOException;

    public final void translate(TransformT transform, AppliedPTransform<InT, OutT, PTransform<InT, OutT>> appliedTransform, TranslationContext cxt) throws IOException {
        this.translate(transform, new Context(appliedTransform, cxt));
    }

    protected <T> Coder<BoundedWindow> windowCoder(PCollection<T> pc) {
        return pc.getWindowingStrategy().getWindowFn().windowCoder();
    }

    protected class Context {
        private final AppliedPTransform<InT, OutT, PTransform<InT, OutT>> transform;
        private final TranslationContext cxt;
        private @MonotonicNonNull InT pIn = null;
        private @MonotonicNonNull OutT pOut = null;

        protected Context(AppliedPTransform<InT, OutT, PTransform<InT, OutT>> transform, TranslationContext cxt) {
            this.transform = transform;
            this.cxt = cxt;
        }

        public InT getInput() {
            if (this.pIn == null) {
                this.pIn = (PInput)Iterables.getOnlyElement((Iterable)TransformInputs.nonAdditionalInputs(this.transform));
            }
            return this.pIn;
        }

        public Map<TupleTag<?>, PCollection<?>> getInputs() {
            return this.transform.getInputs();
        }

        public OutT getOutput() {
            if (this.pOut == null) {
                this.pOut = (POutput)Iterables.getOnlyElement(this.transform.getOutputs().values());
            }
            return this.pOut;
        }

        public <T> PCollection<T> getOutput(TupleTag<T> tag) {
            PCollection pc = (PCollection)this.transform.getOutputs().get(tag);
            if (pc == null) {
                throw new IllegalStateException("No output for tag " + tag);
            }
            return pc;
        }

        public Map<TupleTag<?>, PCollection<?>> getOutputs() {
            return this.transform.getOutputs();
        }

        public AppliedPTransform<InT, OutT, PTransform<InT, OutT>> getCurrentTransform() {
            return this.transform;
        }

        public <T> Dataset<WindowedValue<T>> getDataset(PCollection<T> pCollection) {
            return this.cxt.getDataset(pCollection);
        }

        public <T> void putDataset(PCollection<T> pCollection, Dataset<WindowedValue<T>> dataset) {
            this.cxt.putDataset(pCollection, dataset);
        }

        public SerializablePipelineOptions getSerializableOptions() {
            return this.cxt.getSerializableOptions();
        }

        public PipelineOptions getOptions() {
            return this.cxt.getSerializableOptions().get();
        }

        public <ViewT, ElemT> void setSideInputDataset(PCollectionView<ViewT> value, Dataset<WindowedValue<ElemT>> set) {
            this.cxt.setSideInputDataset(value, set);
        }

        public <T> Dataset<T> getSideInputDataset(PCollectionView<?> sideInput) {
            return this.cxt.getSideInputDataSet(sideInput);
        }

        public <T> Dataset<WindowedValue<T>> createDataset(List<WindowedValue<T>> data, Encoder<WindowedValue<T>> enc) {
            return data.isEmpty() ? this.cxt.getSparkSession().emptyDataset(enc) : this.cxt.getSparkSession().createDataset(data, enc);
        }

        public <T> Broadcast<T> broadcast(T value) {
            return this.cxt.getSparkSession().sparkContext().broadcast(value, ClassTag.AnyRef());
        }

        public SparkSession getSparkSession() {
            return this.cxt.getSparkSession();
        }

        public <T> Encoder<T> encoderOf(Coder<T> coder) {
            return coder instanceof KvCoder ? this.kvEncoderOf((KvCoder)coder) : this.getOrCreateEncoder(coder);
        }

        public <K, V> Encoder<KV<K, V>> kvEncoderOf(KvCoder<K, V> coder) {
            return this.cxt.encoderOf(coder, c -> EncoderHelpers.kvEncoder(this.keyEncoderOf(coder), this.valueEncoderOf(coder)));
        }

        public <K, V> Encoder<K> keyEncoderOf(KvCoder<K, V> coder) {
            return this.getOrCreateEncoder(coder.getKeyCoder());
        }

        public <K, V> Encoder<V> valueEncoderOf(KvCoder<K, V> coder) {
            return this.getOrCreateEncoder(coder.getValueCoder());
        }

        public <T> Encoder<WindowedValue<T>> windowedEncoder(Coder<T> coder) {
            return EncoderHelpers.windowedValueEncoder(this.encoderOf(coder), this.windowEncoder());
        }

        public <T> Encoder<WindowedValue<T>> windowedEncoder(Encoder<T> enc) {
            return EncoderHelpers.windowedValueEncoder(enc, this.windowEncoder());
        }

        public <T1, T2> Encoder<Tuple2<T1, T2>> tupleEncoder(Encoder<T1> e1, Encoder<T2> e2) {
            return Encoders.tuple(e1, e2);
        }

        public <T, W extends BoundedWindow> Encoder<WindowedValue<T>> windowedEncoder(Coder<T> coder, Coder<W> windowCoder) {
            return EncoderHelpers.windowedValueEncoder(this.encoderOf(coder), this.getOrCreateWindowCoder(windowCoder));
        }

        public Encoder<BoundedWindow> windowEncoder() {
            Preconditions.checkState((!this.transform.getInputs().isEmpty() ? 1 : 0) != 0, (Object)"Transform has no inputs, cannot get windowCoder!");
            Coder coder = ((PCollection)this.getInput()).getWindowingStrategy().getWindowFn().windowCoder();
            return this.cxt.encoderOf(coder, c -> EncoderHelpers.encoderFor(c));
        }

        private <W extends BoundedWindow> Encoder<BoundedWindow> getOrCreateWindowCoder(Coder<W> coder) {
            return this.cxt.encoderOf(coder, c -> EncoderHelpers.encoderFor(c));
        }

        private <T> Encoder<T> getOrCreateEncoder(Coder<T> coder) {
            return this.cxt.encoderOf(coder, c -> EncoderHelpers.encoderFor(c));
        }
    }
}

