/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class SpecMonitoringInfoValidator {
    private static final Map<String, Map<String, Set<String>>> REQUIRED_LABELS = new HashMap<String, Map<String, Set<String>>>();

    public Optional<String> validate(MetricsApi.MonitoringInfo monitoringInfo) {
        if (monitoringInfo.getUrn().isEmpty() || monitoringInfo.getType().isEmpty()) {
            return Optional.of(String.format("MonitoringInfo requires both urn %s and type %s to be specified.", monitoringInfo.getUrn(), monitoringInfo.getType()));
        }
        Map<String, Set<String>> typeToRequiredLabels = REQUIRED_LABELS.get(monitoringInfo.getUrn());
        if (typeToRequiredLabels == null) {
            return Optional.empty();
        }
        Set<String> requiredLabels = typeToRequiredLabels.get(monitoringInfo.getType());
        if (requiredLabels == null) {
            return Optional.empty();
        }
        if (!monitoringInfo.getLabelsMap().keySet().containsAll(requiredLabels)) {
            return Optional.of(String.format("MonitoringInfo with urn: %s should have labels: %s, actual: %s", monitoringInfo.getUrn(), requiredLabels, monitoringInfo.getLabelsMap()));
        }
        return Optional.empty();
    }

    static {
        for (MetricsApi.MonitoringInfoSpecs.Enum enumSpec : MetricsApi.MonitoringInfoSpecs.Enum.values()) {
            if (enumSpec.name().equals("UNRECOGNIZED")) continue;
            MetricsApi.MonitoringInfoSpec spec = (MetricsApi.MonitoringInfoSpec)enumSpec.getValueDescriptor().getOptions().getExtension(MetricsApi.monitoringInfoSpec);
            Map typeToSpec = REQUIRED_LABELS.computeIfAbsent(spec.getUrn(), key -> new HashMap());
            Preconditions.checkState((typeToSpec.put(spec.getType(), new HashSet(spec.getRequiredLabelsList())) == null ? 1 : 0) != 0, (Object)String.format("Found duplicate specs for urn %s and type %s.", spec.getUrn(), spec.getType()));
        }
    }
}

