/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.construction.graph;

import java.util.AbstractMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.ProjectionProducer;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class PCollectionOutputTagVisitor
extends Pipeline.PipelineVisitor.Defaults {
    private final Map<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> pCollFieldAccess;
    private final ImmutableMap.Builder<ProjectionProducer<PTransform<?, ?>>, ImmutableMap.Builder<TupleTag<?>, FieldAccessDescriptor>> tagFieldAccess = ImmutableMap.builder();

    PCollectionOutputTagVisitor(Map<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> pCollFieldAccess) {
        this.pCollFieldAccess = pCollFieldAccess;
    }

    Map<ProjectionProducer<PTransform<?, ?>>, Map<TupleTag<?>, FieldAccessDescriptor>> getTaggedFieldAccess() {
        return this.tagFieldAccess.build().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<ProjectionProducer, ImmutableMap>((ProjectionProducer)e.getKey(), ((ImmutableMap.Builder)e.getValue()).build())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public void visitValue(PValue value, TransformHierarchy.Node producer) {
        for (Map.Entry<ProjectionProducer<PTransform<?, ?>>, Map<PCollection<?>, FieldAccessDescriptor>> entry : this.pCollFieldAccess.entrySet()) {
            FieldAccessDescriptor fieldAccess = entry.getValue().get(value);
            if (fieldAccess == null) continue;
            ImmutableBiMap outputs = ImmutableBiMap.copyOf((Map)producer.getOutputs()).inverse();
            TupleTag tag = (TupleTag)outputs.get((Object)value);
            Preconditions.checkArgumentNotNull((Object)tag, (String)"PCollection %s not found in outputs of producer %s", (Object)value, (Object)producer);
            ImmutableMap.Builder tagEntryBuilder = (ImmutableMap.Builder)this.tagFieldAccess.build().get(entry.getKey());
            if (tagEntryBuilder == null) {
                tagEntryBuilder = ImmutableMap.builder();
                this.tagFieldAccess.put(entry.getKey(), (Object)tagEntryBuilder);
            }
            tagEntryBuilder.put((Object)tag, (Object)fieldAccess);
        }
    }
}

