/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.debug.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JPanel;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.hop.core.exception.HopException;

public class SvgLoader {
    public static BufferedImage transcodeSVGDocument(ClassLoader classLoader, String filename, int width, int height) throws HopException {
        PNGTranscoder t = new PNGTranscoder();
        t.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width));
        t.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height));
        InputStream inputStream = classLoader.getResourceAsStream(filename);
        TranscoderInput input = new TranscoderInput(inputStream);
        ByteArrayOutputStream ostream = null;
        try {
            ostream = new ByteArrayOutputStream();
            TranscoderOutput output = new TranscoderOutput((OutputStream)ostream);
            t.transcode(input, output);
            ostream.flush();
            ostream.close();
        }
        catch (Exception ex) {
            throw new HopException("Error loading svg file " + filename, (Throwable)ex);
        }
        byte[] imgData = ostream.toByteArray();
        Image img = Toolkit.getDefaultToolkit().createImage(imgData);
        MediaTracker tracker = new MediaTracker(new JPanel());
        tracker.addImage(img, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException ex) {
            throw new HopException("Interrupted", (Throwable)ex);
        }
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bufferedImage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bufferedGc = bufferedImage.createGraphics();
        bufferedGc.drawImage(img, 0, 0, null);
        bufferedGc.dispose();
        return bufferedImage;
    }
}

