/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;

@DefaultCoder(value=AvroCoder.class)
public class ChangeStreamRecordMetadata
implements Serializable {
    private static final long serialVersionUID = -7294067549709034080L;
    private String partitionToken;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp recordTimestamp;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp partitionStartTimestamp;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp partitionEndTimestamp;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp partitionCreatedAt;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp partitionScheduledAt;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp partitionRunningAt;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp queryStartedAt;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp recordStreamStartedAt;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp recordStreamEndedAt;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp recordReadAt;
    private long totalStreamTimeMillis;
    private long numberOfRecordsRead;

    private ChangeStreamRecordMetadata() {
    }

    @VisibleForTesting
    ChangeStreamRecordMetadata(String partitionToken, Timestamp recordTimestamp, Timestamp partitionStartTimestamp, Timestamp partitionEndTimestamp, Timestamp partitionCreatedAt, @Nullable Timestamp partitionScheduledAt, @Nullable Timestamp partitionRunningAt, Timestamp queryStartedAt, Timestamp recordStreamStartedAt, Timestamp recordStreamEndedAt, Timestamp recordReadAt, long totalStreamTimeMillis, long numberOfRecordsRead) {
        this.partitionToken = partitionToken;
        this.recordTimestamp = recordTimestamp;
        this.partitionStartTimestamp = partitionStartTimestamp;
        this.partitionEndTimestamp = partitionEndTimestamp;
        this.partitionCreatedAt = partitionCreatedAt;
        this.partitionScheduledAt = partitionScheduledAt;
        this.partitionRunningAt = partitionRunningAt;
        this.queryStartedAt = queryStartedAt;
        this.recordStreamStartedAt = recordStreamStartedAt;
        this.recordStreamEndedAt = recordStreamEndedAt;
        this.recordReadAt = recordReadAt;
        this.totalStreamTimeMillis = totalStreamTimeMillis;
        this.numberOfRecordsRead = numberOfRecordsRead;
    }

    public String getPartitionToken() {
        return this.partitionToken;
    }

    public Timestamp getRecordTimestamp() {
        return this.recordTimestamp;
    }

    public Timestamp getPartitionStartTimestamp() {
        return this.partitionStartTimestamp;
    }

    public Timestamp getPartitionEndTimestamp() {
        return this.partitionEndTimestamp;
    }

    public Timestamp getPartitionCreatedAt() {
        return this.partitionCreatedAt;
    }

    @Nullable
    public Timestamp getPartitionScheduledAt() {
        return this.partitionScheduledAt;
    }

    @Nullable
    public Timestamp getPartitionRunningAt() {
        return this.partitionRunningAt;
    }

    public Timestamp getQueryStartedAt() {
        return this.queryStartedAt;
    }

    public Timestamp getRecordStreamStartedAt() {
        return this.recordStreamStartedAt;
    }

    public Timestamp getRecordStreamEndedAt() {
        return this.recordStreamEndedAt;
    }

    public Timestamp getRecordReadAt() {
        return this.recordReadAt;
    }

    public long getTotalStreamTimeMillis() {
        return this.totalStreamTimeMillis;
    }

    public long getNumberOfRecordsRead() {
        return this.numberOfRecordsRead;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ChangeStreamRecordMetadata)) {
            return false;
        }
        ChangeStreamRecordMetadata metadata = (ChangeStreamRecordMetadata)o;
        return this.totalStreamTimeMillis == metadata.totalStreamTimeMillis && this.numberOfRecordsRead == metadata.numberOfRecordsRead && Objects.equals(this.partitionToken, metadata.partitionToken) && Objects.equals(this.recordTimestamp, metadata.recordTimestamp) && Objects.equals(this.partitionStartTimestamp, metadata.partitionStartTimestamp) && Objects.equals(this.partitionEndTimestamp, metadata.partitionEndTimestamp) && Objects.equals(this.partitionCreatedAt, metadata.partitionCreatedAt) && Objects.equals(this.partitionScheduledAt, metadata.partitionScheduledAt) && Objects.equals(this.partitionRunningAt, metadata.partitionRunningAt) && Objects.equals(this.queryStartedAt, metadata.queryStartedAt) && Objects.equals(this.recordStreamStartedAt, metadata.recordStreamStartedAt) && Objects.equals(this.recordStreamEndedAt, metadata.recordStreamEndedAt) && Objects.equals(this.recordReadAt, metadata.recordReadAt);
    }

    public int hashCode() {
        return Objects.hash(this.partitionToken, this.recordTimestamp, this.partitionStartTimestamp, this.partitionEndTimestamp, this.partitionCreatedAt, this.partitionScheduledAt, this.partitionRunningAt, this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamTimeMillis, this.numberOfRecordsRead);
    }

    public String toString() {
        return "ChangeStreamRecordMetadata{partitionToken='" + this.partitionToken + '\'' + ", recordTimestamp=" + this.recordTimestamp + ", partitionStartTimestamp=" + this.partitionStartTimestamp + ", partitionEndTimestamp=" + this.partitionEndTimestamp + ", partitionCreatedAt=" + this.partitionCreatedAt + ", partitionScheduledAt=" + this.partitionScheduledAt + ", partitionRunningAt=" + this.partitionRunningAt + ", queryStartedAt=" + this.queryStartedAt + ", recordStreamStartedAt=" + this.recordStreamStartedAt + ", recordStreamEndedAt=" + this.recordStreamEndedAt + ", recordReadAt=" + this.recordReadAt + ", totalStreamTimeMillis=" + this.totalStreamTimeMillis + ", numberOfRecordsRead=" + this.numberOfRecordsRead + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String partitionToken;
        private Timestamp recordTimestamp;
        private Timestamp partitionStartTimestamp;
        private Timestamp partitionEndTimestamp;
        private Timestamp partitionCreatedAt;
        @Nullable
        private Timestamp partitionScheduledAt;
        @Nullable
        private Timestamp partitionRunningAt;
        private Timestamp queryStartedAt;
        private Timestamp recordStreamStartedAt;
        private Timestamp recordStreamEndedAt;
        private Timestamp recordReadAt;
        private long totalStreamTimeMillis;
        private long numberOfRecordsRead;

        public Builder withPartitionToken(String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public Builder withRecordTimestamp(Timestamp recordTimestamp) {
            this.recordTimestamp = recordTimestamp;
            return this;
        }

        public Builder withPartitionStartTimestamp(Timestamp partitionStartTimestamp) {
            this.partitionStartTimestamp = partitionStartTimestamp;
            return this;
        }

        public Builder withPartitionEndTimestamp(Timestamp partitionEndTimestamp) {
            this.partitionEndTimestamp = partitionEndTimestamp;
            return this;
        }

        public Builder withPartitionCreatedAt(Timestamp partitionCreatedAt) {
            this.partitionCreatedAt = partitionCreatedAt;
            return this;
        }

        public Builder withPartitionScheduledAt(@Nullable Timestamp partitionScheduledAt) {
            this.partitionScheduledAt = partitionScheduledAt;
            return this;
        }

        public Builder withPartitionRunningAt(@Nullable Timestamp partitionRunningAt) {
            this.partitionRunningAt = partitionRunningAt;
            return this;
        }

        public Builder withQueryStartedAt(Timestamp queryStartedAt) {
            this.queryStartedAt = queryStartedAt;
            return this;
        }

        public Builder withRecordStreamStartedAt(Timestamp recordStreamStartedAt) {
            this.recordStreamStartedAt = recordStreamStartedAt;
            return this;
        }

        public Builder withRecordStreamEndedAt(Timestamp recordStreamEndedAt) {
            this.recordStreamEndedAt = recordStreamEndedAt;
            return this;
        }

        public Builder withRecordReadAt(Timestamp recordReadAt) {
            this.recordReadAt = recordReadAt;
            return this;
        }

        public Builder withTotalStreamTimeMillis(long totalStreamTimeMillis) {
            this.totalStreamTimeMillis = totalStreamTimeMillis;
            return this;
        }

        public Builder withNumberOfRecordsRead(long numberOfRecordsRead) {
            this.numberOfRecordsRead = numberOfRecordsRead;
            return this;
        }

        public ChangeStreamRecordMetadata build() {
            return new ChangeStreamRecordMetadata(this.partitionToken, this.recordTimestamp, this.partitionStartTimestamp, this.partitionEndTimestamp, this.partitionCreatedAt, this.partitionScheduledAt, this.partitionRunningAt, this.queryStartedAt, this.recordStreamStartedAt, this.recordStreamEndedAt, this.recordReadAt, this.totalStreamTimeMillis, this.numberOfRecordsRead);
        }
    }
}

