/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.sdk.util.Preconditions;

class OffsetByteRangeTracker
extends TrackerWithProgress {
    private final TopicBacklogReader unownedBacklogReader;
    private final OffsetRangeTracker rangeTracker;
    private long bytes;
    @Nullable
    private Long lastClaimed;

    public OffsetByteRangeTracker(OffsetByteRange range, TopicBacklogReader unownedBacklogReader) {
        org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((range.getRange().getTo() == Long.MAX_VALUE ? 1 : 0) != 0, (Object)"May only construct OffsetByteRangeTracker with an unbounded range with no progress.");
        org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((range.getByteCount() == 0L ? 1 : 0) != 0, (Object)"May only construct OffsetByteRangeTracker with an unbounded range with no progress.");
        this.unownedBacklogReader = unownedBacklogReader;
        this.rangeTracker = new OffsetRangeTracker(range.getRange());
        this.bytes = range.getByteCount();
    }

    public RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.UNBOUNDED;
    }

    public boolean tryClaim(OffsetByteProgress position) {
        if (!this.rangeTracker.tryClaim(Long.valueOf(position.lastOffset().value()))) {
            return false;
        }
        this.lastClaimed = position.lastOffset().value();
        this.bytes += position.batchBytes();
        return true;
    }

    public OffsetByteRange currentRestriction() {
        return OffsetByteRange.of(this.rangeTracker.currentRestriction(), this.bytes);
    }

    private long nextOffset() {
        org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkState((this.lastClaimed == null || this.lastClaimed < Long.MAX_VALUE ? 1 : 0) != 0);
        return this.lastClaimed == null ? this.currentRestriction().getRange().getFrom() : this.lastClaimed + 1L;
    }

    @Nullable
    public SplitResult<OffsetByteRange> trySplit(double fractionOfRemainder) {
        if (this.rangeTracker.currentRestriction().getTo() != Long.MAX_VALUE) {
            return null;
        }
        SplitResult ranges = this.rangeTracker.trySplit(fractionOfRemainder);
        if (ranges == null) {
            return null;
        }
        org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((boolean)this.rangeTracker.currentRestriction().equals(ranges.getPrimary()));
        return SplitResult.of((Object)this.currentRestriction(), (Object)OffsetByteRange.of((OffsetRange)Preconditions.checkArgumentNotNull((Object)((OffsetRange)ranges.getResidual()))));
    }

    public void checkDone() throws IllegalStateException {
        this.rangeTracker.checkDone();
    }

    public RestrictionTracker.Progress getProgress() {
        ComputeMessageStatsResponse stats = this.unownedBacklogReader.computeMessageStats(Offset.of((long)this.nextOffset()));
        return RestrictionTracker.Progress.from((double)this.bytes, (double)stats.getMessageBytes());
    }
}

