/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertErrorCoder;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTableDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiConvertMessages;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteRecordsInconsistent;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritesShardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.joda.time.Duration;

public class StorageApiLoads<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    static final int MAX_BATCH_SIZE_BYTES = 0x200000;
    final TupleTag<KV<DestinationT, StorageApiWritePayload>> successfulRowsTag = new TupleTag("successfulRows");
    final TupleTag<BigQueryStorageApiInsertError> failedRowsTag = new TupleTag("failedRows");
    private final Coder<DestinationT> destinationCoder;
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final BigQueryIO.Write.CreateDisposition createDisposition;
    private final String kmsKey;
    private final Duration triggeringFrequency;
    private final BigQueryServices bqServices;
    private final int numShards;
    private final boolean allowInconsistentWrites;
    private final boolean allowAutosharding;

    public StorageApiLoads(Coder<DestinationT> destinationCoder, StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, BigQueryIO.Write.CreateDisposition createDisposition, String kmsKey, Duration triggeringFrequency, BigQueryServices bqServices, int numShards, boolean allowInconsistentWrites, boolean allowAutosharding) {
        this.destinationCoder = destinationCoder;
        this.dynamicDestinations = dynamicDestinations;
        this.createDisposition = createDisposition;
        this.kmsKey = kmsKey;
        this.triggeringFrequency = triggeringFrequency;
        this.bqServices = bqServices;
        this.numShards = numShards;
        this.allowInconsistentWrites = allowInconsistentWrites;
        this.allowAutosharding = allowAutosharding;
    }

    public WriteResult expand(PCollection<KV<DestinationT, ElementT>> input) {
        SchemaCoder payloadCoder;
        try {
            payloadCoder = input.getPipeline().getSchemaRegistry().getSchemaCoder(StorageApiWritePayload.class);
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException(e);
        }
        KvCoder successCoder = KvCoder.of(this.destinationCoder, (Coder)payloadCoder);
        if (this.allowInconsistentWrites) {
            return this.expandInconsistent(input, (Coder<KV<DestinationT, StorageApiWritePayload>>)successCoder);
        }
        return this.triggeringFrequency != null ? this.expandTriggered(input, (Coder<KV<DestinationT, StorageApiWritePayload>>)successCoder, (Coder<StorageApiWritePayload>)payloadCoder) : this.expandUntriggered(input, (Coder<KV<DestinationT, StorageApiWritePayload>>)successCoder);
    }

    public WriteResult expandInconsistent(PCollection<KV<DestinationT, ElementT>> input, Coder<KV<DestinationT, StorageApiWritePayload>> successCoder) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        PCollectionTuple convertedRecords = (PCollectionTuple)((PCollection)inputInGlobalWindow.apply("CreateTables", new CreateTableDestinations(this.createDisposition, this.bqServices, this.dynamicDestinations, this.kmsKey))).apply("Convert", new StorageApiConvertMessages<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, this.successfulRowsTag, BigQueryStorageApiInsertErrorCoder.of(), successCoder));
        convertedRecords.get(this.successfulRowsTag).apply("StorageApiWriteInconsistent", new StorageApiWriteRecordsInconsistent<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices));
        return WriteResult.in(input.getPipeline(), null, null, null, null, null, this.failedRowsTag, (PCollection<BigQueryStorageApiInsertError>)convertedRecords.get(this.failedRowsTag));
    }

    public WriteResult expandTriggered(PCollection<KV<DestinationT, ElementT>> input, Coder<KV<DestinationT, StorageApiWritePayload>> successCoder, Coder<StorageApiWritePayload> payloadCoder) {
        PCollection groupedRecords;
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        PCollectionTuple result = (PCollectionTuple)((PCollection)inputInGlobalWindow.apply("CreateTables", new CreateTableDestinations(this.createDisposition, this.bqServices, this.dynamicDestinations, this.kmsKey))).apply("Convert", new StorageApiConvertMessages<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, this.successfulRowsTag, BigQueryStorageApiInsertErrorCoder.of(), successCoder));
        if (this.allowAutosharding) {
            groupedRecords = (PCollection)result.get(this.successfulRowsTag).apply("GroupIntoBatches", (PTransform)GroupIntoBatches.ofByteSize((long)0x200000L, (SerializableFunction & Serializable)e -> e.getPayload().length).withMaxBufferingDuration(this.triggeringFrequency).withShardedKey());
        } else {
            PCollection shardedRecords = this.createShardedKeyValuePairs(result).setCoder((Coder)KvCoder.of((Coder)ShardedKey.Coder.of(this.destinationCoder), payloadCoder));
            groupedRecords = (PCollection)shardedRecords.apply("GroupIntoBatches", (PTransform)GroupIntoBatches.ofByteSize((long)0x200000L, (SerializableFunction & Serializable)e -> e.getPayload().length).withMaxBufferingDuration(this.triggeringFrequency));
        }
        groupedRecords.apply("StorageApiWriteSharded", new StorageApiWritesShardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.createDisposition, this.kmsKey, this.bqServices, this.destinationCoder));
        return WriteResult.in(input.getPipeline(), null, null, null, null, null, this.failedRowsTag, (PCollection<BigQueryStorageApiInsertError>)result.get(this.failedRowsTag));
    }

    private PCollection<KV<ShardedKey<DestinationT>, StorageApiWritePayload>> createShardedKeyValuePairs(PCollectionTuple pCollection) {
        return (PCollection)pCollection.get(this.successfulRowsTag).apply("AddShard", (PTransform)ParDo.of((DoFn)new DoFn<KV<DestinationT, StorageApiWritePayload>, KV<ShardedKey<DestinationT>, StorageApiWritePayload>>(){
            int shardNumber;

            @DoFn.Setup
            public void setup() {
                this.shardNumber = ThreadLocalRandom.current().nextInt(StorageApiLoads.this.numShards);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element KV<DestinationT, StorageApiWritePayload> element, DoFn.OutputReceiver<KV<ShardedKey<DestinationT>, StorageApiWritePayload>> o) {
                Object destination = element.getKey();
                ByteBuffer buffer = ByteBuffer.allocate(4);
                buffer.putInt(++this.shardNumber % StorageApiLoads.this.numShards);
                o.output((Object)KV.of((Object)ShardedKey.of((Object)destination, (byte[])buffer.array()), (Object)((StorageApiWritePayload)element.getValue())));
            }
        }));
    }

    public WriteResult expandUntriggered(PCollection<KV<DestinationT, ElementT>> input, Coder<KV<DestinationT, StorageApiWritePayload>> successCoder) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        PCollectionTuple convertedRecords = (PCollectionTuple)((PCollection)inputInGlobalWindow.apply("CreateTables", new CreateTableDestinations(this.createDisposition, this.bqServices, this.dynamicDestinations, this.kmsKey))).apply("Convert", new StorageApiConvertMessages<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, this.successfulRowsTag, BigQueryStorageApiInsertErrorCoder.of(), successCoder));
        convertedRecords.get(this.successfulRowsTag).apply("StorageApiWriteUnsharded", new StorageApiWriteUnshardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices));
        return WriteResult.in(input.getPipeline(), null, null, null, null, null, this.failedRowsTag, (PCollection<BigQueryStorageApiInsertError>)convertedRecords.get(this.failedRowsTag));
    }
}

