/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.getfilenames;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.fileinput.FileInputList;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.getfilenames.FileItem;
import org.apache.hop.pipeline.transforms.getfilenames.FilterItem;
import org.apache.hop.pipeline.transforms.getfilenames.GetFileNamesMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GetFileNamesDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = GetFileNamesMeta.class;
    private static final String[] YES_NO_COMBO = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    private Button wDoNotFailIfNoFile;
    private Label wlDoNotFailIfNoFile;
    private Label wlRaiseAnExceptionIfNoFile;
    private Button wRaiseAnExceptionIfNoFile;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private Label wlExcludeFilemask;
    private TextVar wExcludeFilemask;
    private Label wlFilemask;
    private TextVar wFilemask;
    private Button wbShowFiles;
    private CCombo wFilterFileType;
    private final GetFileNamesMeta input;
    private Button wFileField;
    private Label wlFilenameField;
    private CCombo wFilenameField;
    private Label wlWildcardField;
    private CCombo wWildcardField;
    private Label wlExcludeWildcardField;
    private CCombo wExcludeWildcardField;
    private Label wlIncludeSubFolder;
    private Button wIncludeSubFolder;
    private Button wAddResult;
    private Text wLimit;
    private Button wInclRownum;
    private TextVar wInclRownumField;
    private boolean getPreviousFields = false;

    public GetFileNamesDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (GetFileNamesMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getFormMargin();
        formLayout.marginHeight = PropsUi.getFormMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        GetFileNamesDialog getFileNamesDialog = this;
        int margin = getFileNamesDialog.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Preview.Button", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        CTabItem wFileTab = new CTabItem(wTabFolder, 0);
        wFileTab.setFont(GuiResource.getInstance().getFontDefault());
        wFileTab.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileTab.TabTitle", (String[])new String[0]));
        Composite wFileComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wFileComp.setLayout((Layout)fileLayout);
        Group wOriginFiles = new Group(wFileComp, 32);
        PropsUi.setLook((Widget)wOriginFiles);
        wOriginFiles.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.OriginFiles.Label", (String[])new String[0]));
        FormLayout originFilesgroupLayout = new FormLayout();
        originFilesgroupLayout.marginWidth = 10;
        originFilesgroupLayout.marginHeight = 10;
        wOriginFiles.setLayout((Layout)originFilesgroupLayout);
        Label wlFileField = new Label((Composite)wOriginFiles, 131072);
        wlFileField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFileField);
        FormData fdlFileField = new FormData();
        fdlFileField.left = new FormAttachment(0, -margin);
        fdlFileField.top = new FormAttachment(0, margin);
        fdlFileField.right = new FormAttachment(middle, -2 * margin);
        wlFileField.setLayoutData((Object)fdlFileField);
        this.wFileField = new Button((Composite)wOriginFiles, 32);
        PropsUi.setLook((Widget)this.wFileField);
        this.wFileField.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileField.Tooltip", (String[])new String[0]));
        FormData fdFileField = new FormData();
        fdFileField.left = new FormAttachment(middle, -margin);
        fdFileField.top = new FormAttachment((Control)wlFileField, 0, 0x1000000);
        this.wFileField.setLayoutData((Object)fdFileField);
        SelectionAdapter lfilefield = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetFileNamesDialog.this.activateFileField();
                GetFileNamesDialog.this.setFileField();
                GetFileNamesDialog.this.input.setChanged();
            }
        };
        this.wFileField.addSelectionListener((SelectionListener)lfilefield);
        this.wlFilenameField = new Label((Composite)wOriginFiles, 131072);
        this.wlFilenameField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameField);
        FormData fdlFilenameField = new FormData();
        fdlFilenameField.left = new FormAttachment(0, -margin);
        fdlFilenameField.top = new FormAttachment((Control)this.wFileField, margin);
        fdlFilenameField.right = new FormAttachment(middle, -2 * margin);
        this.wlFilenameField.setLayoutData((Object)fdlFilenameField);
        this.wFilenameField = new CCombo((Composite)wOriginFiles, 2056);
        this.wFilenameField.setEditable(true);
        PropsUi.setLook((Widget)this.wFilenameField);
        this.wFilenameField.addModifyListener(lsMod);
        FormData fdFilenameField = new FormData();
        fdFilenameField.left = new FormAttachment(middle, -margin);
        fdFilenameField.top = new FormAttachment((Control)this.wFileField, margin);
        fdFilenameField.right = new FormAttachment(100, -margin);
        this.wFilenameField.setLayoutData((Object)fdFilenameField);
        this.wlWildcardField = new Label((Composite)wOriginFiles, 131072);
        this.wlWildcardField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.WildcardField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlWildcardField);
        FormData fdlWildcardField = new FormData();
        fdlWildcardField.left = new FormAttachment(0, -margin);
        fdlWildcardField.top = new FormAttachment((Control)this.wFilenameField, margin);
        fdlWildcardField.right = new FormAttachment(middle, -2 * margin);
        this.wlWildcardField.setLayoutData((Object)fdlWildcardField);
        this.wWildcardField = new CCombo((Composite)wOriginFiles, 2056);
        this.wWildcardField.setEditable(true);
        PropsUi.setLook((Widget)this.wWildcardField);
        this.wWildcardField.addModifyListener(lsMod);
        FormData fdWildcardField = new FormData();
        fdWildcardField.left = new FormAttachment(middle, -margin);
        fdWildcardField.top = new FormAttachment((Control)this.wFilenameField, margin);
        fdWildcardField.right = new FormAttachment(100, -margin);
        this.wWildcardField.setLayoutData((Object)fdWildcardField);
        this.wlExcludeWildcardField = new Label((Composite)wOriginFiles, 131072);
        this.wlExcludeWildcardField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeWildcardField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlExcludeWildcardField);
        FormData fdlExcludeWildcardField = new FormData();
        fdlExcludeWildcardField.left = new FormAttachment(0, -margin);
        fdlExcludeWildcardField.top = new FormAttachment((Control)this.wWildcardField, margin);
        fdlExcludeWildcardField.right = new FormAttachment(middle, -2 * margin);
        this.wlExcludeWildcardField.setLayoutData((Object)fdlExcludeWildcardField);
        this.wExcludeWildcardField = new CCombo((Composite)wOriginFiles, 2056);
        this.wExcludeWildcardField.setEditable(true);
        PropsUi.setLook((Widget)this.wExcludeWildcardField);
        this.wExcludeWildcardField.addModifyListener(lsMod);
        FormData fdExcludeWildcardField = new FormData();
        fdExcludeWildcardField.left = new FormAttachment(middle, -margin);
        fdExcludeWildcardField.top = new FormAttachment((Control)this.wWildcardField, margin);
        fdExcludeWildcardField.right = new FormAttachment(100, -margin);
        this.wExcludeWildcardField.setLayoutData((Object)fdExcludeWildcardField);
        this.wlIncludeSubFolder = new Label((Composite)wOriginFiles, 131072);
        this.wlIncludeSubFolder.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlIncludeSubFolder);
        FormData fdlIncludeSubFolder = new FormData();
        fdlIncludeSubFolder.left = new FormAttachment(0, -margin);
        fdlIncludeSubFolder.top = new FormAttachment((Control)this.wExcludeWildcardField, margin);
        fdlIncludeSubFolder.right = new FormAttachment(middle, -2 * margin);
        this.wlIncludeSubFolder.setLayoutData((Object)fdlIncludeSubFolder);
        this.wIncludeSubFolder = new Button((Composite)wOriginFiles, 32);
        PropsUi.setLook((Widget)this.wIncludeSubFolder);
        this.wIncludeSubFolder.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubFolder.Tooltip", (String[])new String[0]));
        FormData fdIncludeSubFolder = new FormData();
        fdIncludeSubFolder.left = new FormAttachment(middle, -margin);
        fdIncludeSubFolder.top = new FormAttachment((Control)this.wlIncludeSubFolder, 0, 0x1000000);
        this.wIncludeSubFolder.setLayoutData((Object)fdIncludeSubFolder);
        this.wIncludeSubFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        FormData fdOriginFiles = new FormData();
        fdOriginFiles.left = new FormAttachment(0, margin);
        fdOriginFiles.top = new FormAttachment((Control)this.wFilenameList, margin);
        fdOriginFiles.right = new FormAttachment(100, -margin);
        wOriginFiles.setLayoutData((Object)fdOriginFiles);
        this.wlFilename = new Label(wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Filename.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)wOriginFiles, 2 * margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbbFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbaFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        FormData fdbaFilename = new FormData();
        fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        fdbaFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wbaFilename.setLayoutData((Object)fdbaFilename);
        this.wFilename = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbaFilename, -margin);
        fdFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wlFilemask = new Label(wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Filemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilemask);
        FormData fdlFilemask = new FormData();
        fdlFilemask.left = new FormAttachment(0, 0);
        fdlFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        fdlFilemask.right = new FormAttachment(middle, -margin);
        this.wlFilemask.setLayoutData((Object)fdlFilemask);
        this.wFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wFilemask);
        this.wFilemask.addModifyListener(lsMod);
        FormData fdFilemask = new FormData();
        fdFilemask.left = new FormAttachment(middle, 0);
        fdFilemask.top = new FormAttachment((Control)this.wlFilemask, 0, 0x1000000);
        fdFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wFilemask.setLayoutData((Object)fdFilemask);
        this.wlExcludeFilemask = new Label(wFileComp, 131072);
        this.wlExcludeFilemask.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeFilemask.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlExcludeFilemask);
        FormData fdlExcludeFilemask = new FormData();
        fdlExcludeFilemask.left = new FormAttachment(0, 0);
        fdlExcludeFilemask.top = new FormAttachment((Control)this.wFilemask, margin);
        fdlExcludeFilemask.right = new FormAttachment(middle, -margin);
        this.wlExcludeFilemask.setLayoutData((Object)fdlExcludeFilemask);
        this.wExcludeFilemask = new TextVar(this.variables, wFileComp, 18436);
        PropsUi.setLook((Widget)this.wExcludeFilemask);
        this.wExcludeFilemask.addModifyListener(lsMod);
        FormData fdExcludeFilemask = new FormData();
        fdExcludeFilemask.left = new FormAttachment(middle, 0);
        fdExcludeFilemask.top = new FormAttachment((Control)this.wlExcludeFilemask, 0, 0x1000000);
        fdExcludeFilemask.right = new FormAttachment((Control)this.wFilename, 0, 131072);
        this.wExcludeFilemask.setLayoutData((Object)fdExcludeFilemask);
        this.wlFilenameList = new Label(wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameList.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlFilenameList);
        FormData fdlFilenameList = new FormData();
        fdlFilenameList.left = new FormAttachment(0, 0);
        fdlFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, margin);
        fdlFilenameList.right = new FormAttachment(middle, -margin);
        this.wlFilenameList.setLayoutData((Object)fdlFilenameList);
        this.wbdFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameDelete.Button", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameDelete.Tooltip", (String[])new String[0]));
        FormData fdbdFilename = new FormData();
        fdbdFilename.right = new FormAttachment(100, 0);
        fdbdFilename.top = new FormAttachment((Control)this.wExcludeFilemask, margin);
        this.wbdFilename.setLayoutData((Object)fdbdFilename);
        this.wbeFilename = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        FormData fdbeFilename = new FormData();
        fdbeFilename.right = new FormAttachment(100, 0);
        fdbeFilename.left = new FormAttachment((Control)this.wbdFilename, 0, 16384);
        fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, margin);
        this.wbeFilename.setLayoutData((Object)fdbeFilename);
        this.wbShowFiles = new Button(wFileComp, 0x1000008);
        PropsUi.setLook((Widget)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ShowFiles.Button", (String[])new String[0]));
        FormData fdbShowFiles = new FormData();
        fdbShowFiles.left = new FormAttachment(middle, 0);
        fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)fdbShowFiles);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileDirColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.WildcardColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeWildcardColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Required.Column", (String[])new String[0]), 2, YES_NO_COMBO), new ColumnInfo(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubDirs.Column", (String[])new String[0]), 2, YES_NO_COMBO)};
        colinfo[0].setUsingVariables(true);
        colinfo[1].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.RegExpColumn.Column", (String[])new String[0]));
        colinfo[2].setUsingVariables(true);
        colinfo[2].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ExcludeRegExpColumn.Column", (String[])new String[0]));
        colinfo[3].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Required.Tooltip", (String[])new String[0]));
        colinfo[4].setToolTip(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.IncludeSubDirs.ToolTip", (String[])new String[0]));
        this.wFilenameList = new TableView(this.variables, wFileComp, 67588, colinfo, colinfo.length, lsMod, this.props);
        PropsUi.setLook((Widget)this.wFilenameList);
        FormData fdFilenameList = new FormData();
        fdFilenameList.left = new FormAttachment(middle, 0);
        fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -margin);
        fdFilenameList.top = new FormAttachment((Control)this.wExcludeFilemask, margin);
        fdFilenameList.bottom = new FormAttachment((Control)this.wbShowFiles, -margin);
        this.wFilenameList.setLayoutData((Object)fdFilenameList);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        wFileComp.setLayoutData((Object)fdFileComp);
        wFileComp.layout();
        wFileTab.setControl((Control)wFileComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        CTabItem wFilterTab = new CTabItem(wTabFolder, 0);
        wFilterTab.setFont(GuiResource.getInstance().getFontDefault());
        wFilterTab.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.TabTitle", (String[])new String[0]));
        Composite wFilterComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFilterComp);
        FormLayout filesettingLayout = new FormLayout();
        filesettingLayout.marginWidth = 3;
        filesettingLayout.marginHeight = 3;
        wFilterComp.setLayout((Layout)fileLayout);
        Label wlFilterFileType = new Label(wFilterComp, 131072);
        wlFilterFileType.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFilterFileType);
        FormData fdlFilterFileType = new FormData();
        fdlFilterFileType.left = new FormAttachment(0, 0);
        fdlFilterFileType.right = new FormAttachment(middle, 0);
        fdlFilterFileType.top = new FormAttachment(0, 3 * margin);
        wlFilterFileType.setLayoutData((Object)fdlFilterFileType);
        this.wFilterFileType = new CCombo(wFilterComp, 2060);
        this.wFilterFileType.add(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.All.Label", (String[])new String[0]));
        this.wFilterFileType.add(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.OnlyFile.Label", (String[])new String[0]));
        this.wFilterFileType.add(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FilterTab.FileType.OnlyFolder.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wFilterFileType);
        FormData fdFilterFileType = new FormData();
        fdFilterFileType.left = new FormAttachment(middle, 0);
        fdFilterFileType.top = new FormAttachment(0, 3 * margin);
        fdFilterFileType.right = new FormAttachment(100, 0);
        this.wFilterFileType.setLayoutData((Object)fdFilterFileType);
        this.wFilterFileType.addModifyListener(lsMod);
        Group wAdditionalGroup = new Group(wFilterComp, 32);
        PropsUi.setLook((Widget)wAdditionalGroup);
        wAdditionalGroup.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Group.AdditionalGroup.Label", (String[])new String[0]));
        FormLayout additionalgroupLayout = new FormLayout();
        additionalgroupLayout.marginWidth = 10;
        additionalgroupLayout.marginHeight = 10;
        wAdditionalGroup.setLayout((Layout)additionalgroupLayout);
        Label wlInclRownum = new Label((Composite)wAdditionalGroup, 131072);
        wlInclRownum.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.InclRownum.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownum);
        FormData fdlInclRownum = new FormData();
        fdlInclRownum.left = new FormAttachment(0, 0);
        fdlInclRownum.top = new FormAttachment((Control)this.wFilterFileType, 2 * margin);
        fdlInclRownum.right = new FormAttachment(middle, -margin);
        wlInclRownum.setLayoutData((Object)fdlInclRownum);
        this.wInclRownum = new Button((Composite)wAdditionalGroup, 32);
        PropsUi.setLook((Widget)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.InclRownum.Tooltip", (String[])new String[0]));
        FormData fdRownum = new FormData();
        fdRownum.left = new FormAttachment(middle, 0);
        fdRownum.top = new FormAttachment((Control)wlInclRownum, 0, 0x1000000);
        this.wInclRownum.setLayoutData((Object)fdRownum);
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        Label wlInclRownumField = new Label((Composite)wAdditionalGroup, 131072);
        wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.InclRownumField.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlInclRownumField);
        FormData fdlInclRownumField = new FormData();
        fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, margin);
        fdlInclRownumField.top = new FormAttachment((Control)this.wFilterFileType, 2 * margin);
        wlInclRownumField.setLayoutData((Object)fdlInclRownumField);
        this.wInclRownumField = new TextVar(this.variables, (Composite)wAdditionalGroup, 18436);
        PropsUi.setLook((Widget)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(lsMod);
        FormData fdInclRownumField = new FormData();
        fdInclRownumField.left = new FormAttachment((Control)wlInclRownumField, margin);
        fdInclRownumField.top = new FormAttachment((Control)this.wFilterFileType, 2 * margin);
        fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)fdInclRownumField);
        FormData fdAdditionalGroup = new FormData();
        fdAdditionalGroup.left = new FormAttachment(0, margin);
        fdAdditionalGroup.top = new FormAttachment((Control)this.wFilterFileType, margin);
        fdAdditionalGroup.right = new FormAttachment(100, -margin);
        wAdditionalGroup.setLayoutData((Object)fdAdditionalGroup);
        Group wNoFilesFolderGroup = new Group(wFilterComp, 32);
        PropsUi.setLook((Widget)wNoFilesFolderGroup);
        wNoFilesFolderGroup.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Group.NoFilesFolder.Label", (String[])new String[0]));
        FormLayout noFilesOrFoldersGroupLayout = new FormLayout();
        noFilesOrFoldersGroupLayout.marginWidth = 10;
        noFilesOrFoldersGroupLayout.marginHeight = 10;
        wNoFilesFolderGroup.setLayout((Layout)noFilesOrFoldersGroupLayout);
        this.wlDoNotFailIfNoFile = new Label((Composite)wNoFilesFolderGroup, 131072);
        this.wlDoNotFailIfNoFile.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.DoNotFailIfNoFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlDoNotFailIfNoFile);
        FormData fdldoNotFailIfNoFile = new FormData();
        fdldoNotFailIfNoFile.left = new FormAttachment(0, 0);
        fdldoNotFailIfNoFile.top = new FormAttachment((Control)wAdditionalGroup, 2 * margin);
        fdldoNotFailIfNoFile.right = new FormAttachment(middle, -margin);
        this.wlDoNotFailIfNoFile.setLayoutData((Object)fdldoNotFailIfNoFile);
        this.wDoNotFailIfNoFile = new Button((Composite)wNoFilesFolderGroup, 32);
        PropsUi.setLook((Widget)this.wDoNotFailIfNoFile);
        this.wDoNotFailIfNoFile.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.DoNotFailIfNoFile.Tooltip", (String[])new String[0]));
        FormData fddoNotFailIfNoFile = new FormData();
        fddoNotFailIfNoFile.left = new FormAttachment(middle, 0);
        fddoNotFailIfNoFile.top = new FormAttachment((Control)this.wlDoNotFailIfNoFile, 0, 0x1000000);
        this.wDoNotFailIfNoFile.setLayoutData((Object)fddoNotFailIfNoFile);
        this.wlRaiseAnExceptionIfNoFile = new Label((Composite)wNoFilesFolderGroup, 131072);
        this.wlRaiseAnExceptionIfNoFile.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.RaiseAnExceptionIfNoFiles.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRaiseAnExceptionIfNoFile);
        FormData fdlRaiseAnExceptionIfNoFile = new FormData();
        fdlRaiseAnExceptionIfNoFile.left = new FormAttachment(0, 0);
        fdlRaiseAnExceptionIfNoFile.top = new FormAttachment((Control)this.wlDoNotFailIfNoFile, 2 * margin);
        fdlRaiseAnExceptionIfNoFile.right = new FormAttachment(middle, -margin);
        this.wlRaiseAnExceptionIfNoFile.setLayoutData((Object)fdlRaiseAnExceptionIfNoFile);
        this.wRaiseAnExceptionIfNoFile = new Button((Composite)wNoFilesFolderGroup, 32);
        PropsUi.setLook((Widget)this.wRaiseAnExceptionIfNoFile);
        this.wRaiseAnExceptionIfNoFile.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.RaiseAnExceptionIfNoFiles.Tooltip", (String[])new String[0]));
        FormData fddoRaiseAnExceptionIfNoFile = new FormData();
        fddoRaiseAnExceptionIfNoFile.left = new FormAttachment(middle, 0);
        fddoRaiseAnExceptionIfNoFile.top = new FormAttachment((Control)this.wlRaiseAnExceptionIfNoFile, 0, 0x1000000);
        this.wRaiseAnExceptionIfNoFile.setLayoutData((Object)fddoRaiseAnExceptionIfNoFile);
        this.wRaiseAnExceptionIfNoFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.wDoNotFailIfNoFile.setSelection(false);
                GetFileNamesDialog.this.wlDoNotFailIfNoFile.setEnabled(!GetFileNamesDialog.this.wRaiseAnExceptionIfNoFile.getSelection());
                GetFileNamesDialog.this.wDoNotFailIfNoFile.setEnabled(!GetFileNamesDialog.this.wRaiseAnExceptionIfNoFile.getSelection());
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        this.wDoNotFailIfNoFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.wlRaiseAnExceptionIfNoFile.setEnabled(!GetFileNamesDialog.this.wDoNotFailIfNoFile.getSelection());
                GetFileNamesDialog.this.wRaiseAnExceptionIfNoFile.setEnabled(!GetFileNamesDialog.this.wDoNotFailIfNoFile.getSelection());
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        FormData fdNoFilesOrFoldersGroup = new FormData();
        fdNoFilesOrFoldersGroup.left = new FormAttachment(0, margin);
        fdNoFilesOrFoldersGroup.top = new FormAttachment((Control)wAdditionalGroup, margin);
        fdNoFilesOrFoldersGroup.right = new FormAttachment(100, -margin);
        wNoFilesFolderGroup.setLayoutData((Object)fdNoFilesOrFoldersGroup);
        Label wlLimit = new Label(wFilterComp, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.Limit.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.top = new FormAttachment((Control)wNoFilesFolderGroup, margin);
        fdlLimit.right = new FormAttachment(middle, -margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text(wFilterComp, 18436);
        PropsUi.setLook((Widget)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.top = new FormAttachment((Control)wNoFilesFolderGroup, margin);
        fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlAddResult = new Label(wFilterComp, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.AddResult.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wLimit, margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button(wFilterComp, 32);
        PropsUi.setLook((Widget)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        FormData fdFilterComp = new FormData();
        fdFilterComp.left = new FormAttachment(0, 0);
        fdFilterComp.top = new FormAttachment(0, 0);
        fdFilterComp.right = new FormAttachment(100, 0);
        fdFilterComp.bottom = new FormAttachment(100, 0);
        wFilterComp.setLayoutData((Object)fdFilterComp);
        wFilterComp.layout();
        wFilterTab.setControl((Control)wFilterComp);
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                GetFileNamesDialog.this.wFilenameList.add(new String[]{GetFileNamesDialog.this.wFilename.getText(), GetFileNamesDialog.this.wFilemask.getText(), GetFileNamesDialog.this.wExcludeFilemask.getText(), GetFileNamesMeta.RequiredFilesCode[0], GetFileNamesMeta.RequiredFilesCode[0]});
                GetFileNamesDialog.this.wFilename.setText("");
                GetFileNamesDialog.this.wFilemask.setText("");
                GetFileNamesDialog.this.wFilenameList.removeEmptyRows();
                GetFileNamesDialog.this.wFilenameList.setRowNums();
                GetFileNamesDialog.this.wFilenameList.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = GetFileNamesDialog.this.wFilenameList.getSelectionIndices();
                GetFileNamesDialog.this.wFilenameList.remove(idx);
                GetFileNamesDialog.this.wFilenameList.removeEmptyRows();
                GetFileNamesDialog.this.wFilenameList.setRowNums();
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = GetFileNamesDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = GetFileNamesDialog.this.wFilenameList.getItem(idx);
                    GetFileNamesDialog.this.wFilename.setText(string[0]);
                    GetFileNamesDialog.this.wFilemask.setText(string[1]);
                    GetFileNamesDialog.this.wExcludeFilemask.setText(string[2]);
                    GetFileNamesDialog.this.wFilenameList.remove(idx);
                }
                GetFileNamesDialog.this.wFilenameList.removeEmptyRows();
                GetFileNamesDialog.this.wFilenameList.setRowNums();
                GetFileNamesDialog.this.input.setChanged();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GetFileNamesMeta tfii = new GetFileNamesMeta();
                GetFileNamesDialog.this.getInfo(tfii);
                String[] files = tfii.getFilePaths(GetFileNamesDialog.this.variables);
                if (files != null && files.length > 0) {
                    EnterSelectionDialog esd = new EnterSelectionDialog(GetFileNamesDialog.this.shell, files, "Files read", "Files read:");
                    esd.setViewOnly();
                    esd.open();
                } else {
                    String elementTypeToGet = FileInputList.FileTypeFilter.getByOrdinal((int)GetFileNamesDialog.this.wFilterFileType.getSelectionIndex()).toString();
                    MessageBox mb = new MessageBox(GetFileNamesDialog.this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"GetFileNamesDialog.NoFilesFound.DialogMessage", (String[])new String[]{elementTypeToGet}));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                    mb.open();
                }
            }
        });
        this.wbbFilename.addListener(13, e -> {
            if (!Utils.isEmpty((CharSequence)this.wFilemask.getText()) || !Utils.isEmpty((CharSequence)this.wExcludeFilemask.getText())) {
                BaseDialog.presentDirectoryDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables);
            } else {
                BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*.txt;*.csv", "*.csv", "*.txt", "*"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FileType.TextAndCSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])}, (boolean)true);
            }
        });
        wTabFolder.setSelection(0);
        this.setFileField();
        this.getData(this.input);
        this.activateFileField();
        this.setErrorsMgmtCheckboxesStatus();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setFileField() {
        try {
            if (!this.getPreviousFields) {
                this.getPreviousFields = true;
                String filename = this.wFilenameField.getText();
                String wildcard = this.wWildcardField.getText();
                String excludewildcard = this.wExcludeWildcardField.getText();
                this.wFilenameField.removeAll();
                this.wWildcardField.removeAll();
                this.wExcludeWildcardField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wFilenameField.setItems(r.getFieldNames());
                    this.wWildcardField.setItems(r.getFieldNames());
                    this.wExcludeWildcardField.setItems(r.getFieldNames());
                }
                if (filename != null) {
                    this.wFilenameField.setText(filename);
                }
                if (wildcard != null) {
                    this.wWildcardField.setText(wildcard);
                }
                if (excludewildcard != null) {
                    this.wExcludeWildcardField.setText(excludewildcard);
                }
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void activateFileField() {
        this.wlFilenameField.setEnabled(this.wFileField.getSelection());
        this.wFilenameField.setEnabled(this.wFileField.getSelection());
        this.wlWildcardField.setEnabled(this.wFileField.getSelection());
        this.wWildcardField.setEnabled(this.wFileField.getSelection());
        this.wlExcludeWildcardField.setEnabled(this.wFileField.getSelection());
        this.wExcludeWildcardField.setEnabled(this.wFileField.getSelection());
        this.wlFilename.setEnabled(!this.wFileField.getSelection());
        this.wbbFilename.setEnabled(!this.wFileField.getSelection());
        this.wbaFilename.setEnabled(!this.wFileField.getSelection());
        this.wFilename.setEnabled(!this.wFileField.getSelection());
        this.wlFilemask.setEnabled(!this.wFileField.getSelection());
        this.wFilemask.setEnabled(!this.wFileField.getSelection());
        this.wlExcludeFilemask.setEnabled(!this.wFileField.getSelection());
        this.wExcludeFilemask.setEnabled(!this.wFileField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFileField.getSelection());
        this.wbdFilename.setEnabled(!this.wFileField.getSelection());
        this.wbeFilename.setEnabled(!this.wFileField.getSelection());
        this.wbShowFiles.setEnabled(!this.wFileField.getSelection());
        this.wlFilenameList.setEnabled(!this.wFileField.getSelection());
        this.wFilenameList.setEnabled(!this.wFileField.getSelection());
        this.wPreview.setEnabled(!this.wFileField.getSelection());
        this.wlIncludeSubFolder.setEnabled(this.wFileField.getSelection());
        this.wIncludeSubFolder.setEnabled(this.wFileField.getSelection());
    }

    protected void setErrorsMgmtCheckboxesStatus() {
        if (this.wRaiseAnExceptionIfNoFile.getSelection()) {
            this.wDoNotFailIfNoFile.setSelection(false);
        }
        this.wlRaiseAnExceptionIfNoFile.setEnabled(!this.wDoNotFailIfNoFile.getSelection());
        this.wRaiseAnExceptionIfNoFile.setEnabled(!this.wDoNotFailIfNoFile.getSelection());
        if (this.wDoNotFailIfNoFile.getSelection()) {
            this.wRaiseAnExceptionIfNoFile.setSelection(false);
        }
        this.wlDoNotFailIfNoFile.setEnabled(!this.wRaiseAnExceptionIfNoFile.getSelection());
        this.wDoNotFailIfNoFile.setEnabled(!this.wRaiseAnExceptionIfNoFile.getSelection());
    }

    public void getData(GetFileNamesMeta meta) {
        GetFileNamesMeta in = meta;
        if (in.getFilesList().size() > 0) {
            this.wFilenameList.removeAll();
            for (int i = 0; i < meta.getFilesList().size(); ++i) {
                FileItem fi = meta.getFilesList().get(i);
                this.wFilenameList.add(new String[]{fi.getFileName(), fi.getFileMask(), fi.getExcludeFileMask(), fi.getFileRequired(), fi.getIncludeSubFolders()});
            }
        }
        this.wDoNotFailIfNoFile.setSelection(in.isDoNotFailIfNoFile());
        this.wRaiseAnExceptionIfNoFile.setSelection(in.isRaiseAnExceptionIfNoFile());
        this.wFilenameList.removeEmptyRows();
        this.wFilenameList.setRowNums();
        this.wFilenameList.optWidth(true);
        FileInputList.FileTypeFilter elementTypeToGet = FileInputList.FileTypeFilter.getByName((String)in.getFilterItemList().get(0).getFileTypeFilterSelection());
        if (elementTypeToGet != null) {
            this.wFilterFileType.select(elementTypeToGet.ordinal());
        } else {
            this.wFilterFileType.select(0);
        }
        this.wInclRownum.setSelection(in.isIncludeRowNumber());
        this.wAddResult.setSelection(in.isAddResultFile());
        this.wFileField.setSelection(in.isFileField());
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        if (in.getDynamicFilenameField() != null) {
            this.wFilenameField.setText(in.getDynamicFilenameField());
        }
        if (in.getDynamicWildcardField() != null) {
            this.wWildcardField.setText(in.getDynamicWildcardField());
        }
        if (in.getDynamicExcludeWildcardField() != null) {
            this.wExcludeWildcardField.setText(in.getDynamicExcludeWildcardField());
        }
        this.wLimit.setText("" + in.getRowLimit());
        this.wIncludeSubFolder.setSelection(in.isDynamicIncludeSubFolders());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(GetFileNamesMeta in) {
        this.transformName = this.wTransformName.getText();
        int itemsNum = this.wFilenameList.getItemCount();
        in.getFilesList().clear();
        for (int i = 0; i < itemsNum; ++i) {
            FileItem fi = new FileItem(this.wFilenameList.getItem(i, 1), this.wFilenameList.getItem(i, 2), this.wFilenameList.getItem(i, 3), this.wFilenameList.getItem(i, 4), this.wFilenameList.getItem(i, 5));
            in.getFilesList().add(fi);
        }
        in.getFilterItemList().clear();
        in.getFilterItemList().add(new FilterItem(FileInputList.FileTypeFilter.getByOrdinal((int)this.wFilterFileType.getSelectionIndex()).toString()));
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        in.setAddResultFile(this.wAddResult.getSelection());
        in.setDynamicFilenameField(this.wFilenameField.getText());
        in.setDynamicWildcardField(this.wWildcardField.getText());
        in.setDynamicExcludeWildcardField(this.wExcludeWildcardField.getText());
        in.setFileField(this.wFileField.getSelection());
        in.setRowNumberField(this.wInclRownumField.getText());
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setDynamicIncludeSubFolders(this.wIncludeSubFolder.getSelection());
        in.setDoNotFailIfNoFile(this.wDoNotFailIfNoFile.getSelection());
        in.setRaiseAnExceptionIfNoFile(this.wRaiseAnExceptionIfNoFile.getSelection());
    }

    private void preview() {
        GetFileNamesMeta oneMeta = new GetFileNamesMeta();
        this.getInfo(oneMeta);
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            if (!progressDialog.isCancelled()) {
                Pipeline pipeline = progressDialog.getPipeline();
                String loggingText = progressDialog.getLoggingText();
                if (pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GetFileNamesDialog.ErrorInPreview.DialogMessage", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
                prd.open();
            }
        }
    }
}

