/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.snowflake.bulkloader;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class SnowflakeBulkLoaderField
implements Cloneable {
    @HopMetadataProperty(key="stream_field", injectionGroupKey="OUTPUT_FIELDS")
    private String streamField;
    @HopMetadataProperty(key="table_field", injectionGroupKey="OUTPUT_FIELDS")
    private String tableField;

    public SnowflakeBulkLoaderField(String streamField, String tableField) {
        this.streamField = streamField;
        this.tableField = tableField;
    }

    public SnowflakeBulkLoaderField() {
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public boolean validate() throws HopException {
        if (this.streamField == null || this.tableField == null) {
            throw new HopException("Validation error: Both stream field and database field must be populated.");
        }
        return true;
    }

    public String getStreamField() {
        return this.streamField;
    }

    public void setStreamField(String streamField) {
        this.streamField = streamField;
    }

    public String getTableField() {
        return this.tableField;
    }

    public void setTableField(String tableField) {
        this.tableField = tableField;
    }

    public String toString() {
        return this.streamField + " -> " + this.tableField;
    }
}

