/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.values.PCollectionView;

@Internal
public class CombineContextFactory {
    private static final CombineWithContext.Context NULL_CONTEXT = new CombineWithContext.Context(){

        @Override
        public PipelineOptions getPipelineOptions() {
            throw new IllegalArgumentException("cannot call getPipelineOptions() in a null context");
        }

        @Override
        public <T> T sideInput(PCollectionView<T> view) {
            throw new IllegalArgumentException("cannot call sideInput() in a null context");
        }
    };

    public static CombineWithContext.Context nullContext() {
        return NULL_CONTEXT;
    }

    public static CombineWithContext.Context createFromStateContext(final StateContext<?> c) {
        return new CombineWithContext.Context(){

            @Override
            public PipelineOptions getPipelineOptions() {
                return c.getPipelineOptions();
            }

            @Override
            public <T> T sideInput(PCollectionView<T> view) {
                return c.sideInput(view);
            }
        };
    }
}

