/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.google.auto.value.AutoValue;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.AutoValue_WithFailures_ExceptionElement;
import org.apache.beam.sdk.transforms.AutoValue_WithFailures_Result;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.EncodableThrowable;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.WITH_EXCEPTIONS)
public class WithFailures {

    @AutoValue
    public static abstract class Result<OutputT extends POutput, FailureElementT>
    implements PInput,
    POutput {
        public abstract OutputT output();

        abstract @Nullable TupleTag<?> outputTag();

        public abstract PCollection<FailureElementT> failures();

        abstract TupleTag<FailureElementT> failuresTag();

        public static <OutputT extends POutput, FailureElementT> Result<OutputT, FailureElementT> of(OutputT output, PCollection<FailureElementT> failures) {
            return new AutoValue_WithFailures_Result<OutputT, FailureElementT>(output, null, failures, new TupleTag());
        }

        public static <OutputElementT, FailureElementT> Result<PCollection<OutputElementT>, FailureElementT> of(PCollection<OutputElementT> output, PCollection<FailureElementT> failures) {
            return new AutoValue_WithFailures_Result<PCollection<OutputElementT>, FailureElementT>(output, new TupleTag(), failures, new TupleTag());
        }

        public static <OutputElementT, FailureElementT> Result<PCollection<OutputElementT>, FailureElementT> of(PCollectionTuple tuple, TupleTag<OutputElementT> outputTag, TupleTag<FailureElementT> failureTag) {
            return new AutoValue_WithFailures_Result<PCollection<OutputElementT>, FailureElementT>(tuple.get(outputTag), outputTag, tuple.get(failureTag), failureTag);
        }

        public OutputT failuresTo(List<PCollection<FailureElementT>> failureCollections) {
            failureCollections.add(this.failures());
            return this.output();
        }

        @Override
        public Pipeline getPipeline() {
            return this.output().getPipeline();
        }

        @Override
        public Map<TupleTag<?>, PValue> expand() {
            HashMap values = new HashMap();
            values.put(this.failuresTag(), this.failures());
            if (this.outputTag() != null && this.output() instanceof PValue) {
                values.put(this.outputTag(), (PValue)this.output());
            }
            return values;
        }

        @Override
        public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        }
    }

    public static class ExceptionAsMapHandler<T>
    extends SimpleFunction<ExceptionElement<T>, KV<T, Map<String, String>>> {
        @Override
        public KV<T, Map<String, String>> apply(ExceptionElement<T> f) {
            return KV.of(f.element(), ImmutableMap.of((Object)"className", (Object)f.exception().getClass().getName(), (Object)"message", (Object)f.exception().getMessage(), (Object)"stackTrace", (Object)Arrays.toString(f.exception().getStackTrace())));
        }
    }

    public static class ThrowableHandler<T>
    extends SimpleFunction<ExceptionElement<T>, KV<T, EncodableThrowable>> {
        @Override
        public KV<T, EncodableThrowable> apply(ExceptionElement<T> f) {
            return KV.of(f.element(), EncodableThrowable.forThrowable(f.exception()));
        }
    }

    @AutoValue
    public static abstract class ExceptionElement<T> {
        public abstract T element();

        public abstract Exception exception();

        public static <T> ExceptionElement<T> of(T element, Exception exception) {
            return new AutoValue_WithFailures_ExceptionElement<T>(element, exception);
        }
    }
}

