/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.beam.sdk.schemas.AutoValue_FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.annotations.SchemaCaseFormat;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldNumber;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.CaseFormat;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class FieldValueTypeInformation
implements Serializable {
    public abstract @Nullable Integer getNumber();

    public abstract String getName();

    public abstract boolean isNullable();

    public abstract TypeDescriptor getType();

    public abstract Class getRawType();

    public abstract @Nullable Field getField();

    public abstract @Nullable Method getMethod();

    public abstract Map<String, FieldValueTypeInformation> getOneOfTypes();

    public abstract @Nullable FieldValueTypeInformation getElementType();

    public abstract @Nullable FieldValueTypeInformation getMapKeyType();

    public abstract @Nullable FieldValueTypeInformation getMapValueType();

    abstract Builder toBuilder();

    public static FieldValueTypeInformation forOneOf(String name, boolean nullable, Map<String, FieldValueTypeInformation> oneOfTypes) {
        TypeDescriptor<OneOfType.Value> typeDescriptor = TypeDescriptor.of(OneOfType.Value.class);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(name).setNullable(nullable).setType(typeDescriptor).setRawType(typeDescriptor.getRawType()).setField(null).setElementType(null).setMapKeyType(null).setMapValueType(null).setOneOfTypes(oneOfTypes).build();
    }

    public static FieldValueTypeInformation forField(Field field, int index) {
        TypeDescriptor<?> type = TypeDescriptor.of(field.getGenericType());
        return new AutoValue_FieldValueTypeInformation.Builder().setName(FieldValueTypeInformation.getNameOverride(field.getName(), field)).setNumber(FieldValueTypeInformation.getNumberOverride(index, field)).setNullable(FieldValueTypeInformation.hasNullableAnnotation(field)).setType(type).setRawType(type.getRawType()).setField(field).setElementType(FieldValueTypeInformation.getIterableComponentType(field)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(field)).setMapValueType(FieldValueTypeInformation.getMapValueType(field)).setOneOfTypes(Collections.emptyMap()).build();
    }

    public static <T extends AnnotatedElement & Member> int getNumberOverride(int index, T member) {
        @Nullable SchemaFieldNumber fieldNumber = member.getAnnotation(SchemaFieldNumber.class);
        if (fieldNumber == null) {
            return index;
        }
        return Integer.parseInt(fieldNumber.value());
    }

    public static <T extends AnnotatedElement & Member> String getNameOverride(String original, T member) {
        @Nullable SchemaFieldName fieldName = member.getAnnotation(SchemaFieldName.class);
        @Nullable SchemaCaseFormat caseFormatAnnotation = member.getAnnotation(SchemaCaseFormat.class);
        @Nullable SchemaCaseFormat classCaseFormatAnnotation = ((Member)member).getDeclaringClass().getAnnotation(SchemaCaseFormat.class);
        if (fieldName != null) {
            if (caseFormatAnnotation != null) {
                throw new RuntimeException(String.format("Cannot define both @SchemaFieldName and @SchemaCaseFormat. From member '%s'.", ((Member)member).getName()));
            }
            return fieldName.value();
        }
        if (caseFormatAnnotation != null) {
            return CaseFormat.LOWER_CAMEL.to(caseFormatAnnotation.value(), original);
        }
        if (classCaseFormatAnnotation != null) {
            return CaseFormat.LOWER_CAMEL.to(classCaseFormatAnnotation.value(), original);
        }
        return original;
    }

    public static FieldValueTypeInformation forGetter(Method method, int index) {
        String name;
        if (method.getName().startsWith("get")) {
            name = ReflectUtils.stripPrefix(method.getName(), "get");
        } else if (method.getName().startsWith("is")) {
            name = ReflectUtils.stripPrefix(method.getName(), "is");
        } else {
            throw new RuntimeException("Getter has wrong prefix " + method.getName());
        }
        TypeDescriptor<?> type = TypeDescriptor.of(method.getGenericReturnType());
        boolean nullable = FieldValueTypeInformation.hasNullableReturnType(method);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(FieldValueTypeInformation.getNameOverride(name, method)).setNumber(FieldValueTypeInformation.getNumberOverride(index, method)).setNullable(nullable).setType(type).setRawType(type.getRawType()).setMethod(method).setElementType(FieldValueTypeInformation.getIterableComponentType(type)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(type)).setMapValueType(FieldValueTypeInformation.getMapValueType(type)).setOneOfTypes(Collections.emptyMap()).build();
    }

    private static boolean hasNullableAnnotation(Field field) {
        Stream<Annotation> annotations = Stream.concat(Stream.of(field.getAnnotations()), Stream.of(field.getAnnotatedType().getAnnotations()));
        return annotations.anyMatch(FieldValueTypeInformation::isNullableAnnotation);
    }

    private static boolean hasNullableReturnType(Method method) {
        Stream<Annotation> annotations = Stream.concat(Stream.of(method.getAnnotations()), Stream.of(method.getAnnotatedReturnType().getAnnotations()));
        return annotations.anyMatch(FieldValueTypeInformation::isNullableAnnotation);
    }

    private static boolean hasSingleNullableParameter(Method method) {
        if (method.getParameterCount() != 1) {
            throw new RuntimeException("Setter methods should take a single argument " + method.getName());
        }
        Stream<Annotation> annotations = Stream.concat(Arrays.stream(method.getAnnotatedParameterTypes()[0].getAnnotations()), Arrays.stream(method.getParameterAnnotations()[0]));
        return annotations.anyMatch(FieldValueTypeInformation::isNullableAnnotation);
    }

    private static boolean isNullableAnnotation(Annotation annotation) {
        return annotation.annotationType().getSimpleName().equals("Nullable");
    }

    public static FieldValueTypeInformation forSetter(Method method) {
        return FieldValueTypeInformation.forSetter(method, "set");
    }

    public static FieldValueTypeInformation forSetter(Method method, String setterPrefix) {
        if (!method.getName().startsWith(setterPrefix)) {
            throw new RuntimeException("Setter has wrong prefix " + method.getName());
        }
        String name = ReflectUtils.stripPrefix(method.getName(), setterPrefix);
        TypeDescriptor<?> type = TypeDescriptor.of(method.getGenericParameterTypes()[0]);
        boolean nullable = FieldValueTypeInformation.hasSingleNullableParameter(method);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(name).setNullable(nullable).setType(type).setRawType(type.getRawType()).setMethod(method).setElementType(FieldValueTypeInformation.getIterableComponentType(type)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(type)).setMapValueType(FieldValueTypeInformation.getMapValueType(type)).setOneOfTypes(Collections.emptyMap()).build();
    }

    public FieldValueTypeInformation withName(String name) {
        return this.toBuilder().setName(name).build();
    }

    private static FieldValueTypeInformation getIterableComponentType(Field field) {
        return FieldValueTypeInformation.getIterableComponentType(TypeDescriptor.of(field.getGenericType()));
    }

    static @Nullable FieldValueTypeInformation getIterableComponentType(TypeDescriptor valueType) {
        TypeDescriptor componentType = ReflectUtils.getIterableComponentType(valueType);
        if (componentType == null) {
            return null;
        }
        return new AutoValue_FieldValueTypeInformation.Builder().setName("").setNullable(false).setType(componentType).setRawType(componentType.getRawType()).setElementType(FieldValueTypeInformation.getIterableComponentType(componentType)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(componentType)).setMapValueType(FieldValueTypeInformation.getMapValueType(componentType)).setOneOfTypes(Collections.emptyMap()).build();
    }

    private static @Nullable FieldValueTypeInformation getMapKeyType(Field field) {
        return FieldValueTypeInformation.getMapKeyType(TypeDescriptor.of(field.getGenericType()));
    }

    private static @Nullable FieldValueTypeInformation getMapKeyType(TypeDescriptor<?> typeDescriptor) {
        return FieldValueTypeInformation.getMapType(typeDescriptor, 0);
    }

    private static @Nullable FieldValueTypeInformation getMapValueType(Field field) {
        return FieldValueTypeInformation.getMapType(TypeDescriptor.of(field.getGenericType()), 1);
    }

    private static @Nullable FieldValueTypeInformation getMapValueType(TypeDescriptor typeDescriptor) {
        return FieldValueTypeInformation.getMapType(typeDescriptor, 1);
    }

    private static @Nullable FieldValueTypeInformation getMapType(TypeDescriptor valueType, int index) {
        TypeDescriptor mapType = ReflectUtils.getMapType(valueType, index);
        if (mapType == null) {
            return null;
        }
        return new AutoValue_FieldValueTypeInformation.Builder().setName("").setNullable(false).setType(mapType).setRawType(mapType.getRawType()).setElementType(FieldValueTypeInformation.getIterableComponentType(mapType)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(mapType)).setMapValueType(FieldValueTypeInformation.getMapValueType(mapType)).setOneOfTypes(Collections.emptyMap()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setNumber(@Nullable Integer var1);

        public abstract Builder setName(String var1);

        public abstract Builder setNullable(boolean var1);

        public abstract Builder setType(TypeDescriptor var1);

        public abstract Builder setRawType(Class var1);

        public abstract Builder setField(@Nullable Field var1);

        public abstract Builder setMethod(@Nullable Method var1);

        public abstract Builder setOneOfTypes(Map<String, FieldValueTypeInformation> var1);

        public abstract Builder setElementType(@Nullable FieldValueTypeInformation var1);

        public abstract Builder setMapKeyType(@Nullable FieldValueTypeInformation var1);

        public abstract Builder setMapValueType(@Nullable FieldValueTypeInformation var1);

        abstract FieldValueTypeInformation build();
    }
}

