/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.WriteType;
import org.apache.cassandra.locator.EndpointsForToken;
import org.apache.cassandra.locator.IEndpointSnitch;
import org.apache.cassandra.locator.NetworkTopologyStrategy;
import org.apache.cassandra.locator.Replica;
import org.apache.cassandra.locator.ReplicaPlan;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.service.AbstractWriteResponseHandler;

public class DatacenterSyncWriteResponseHandler<T>
extends AbstractWriteResponseHandler<T> {
    private static final IEndpointSnitch snitch = DatabaseDescriptor.getEndpointSnitch();
    private final Map<String, AtomicInteger> responses = new HashMap<String, AtomicInteger>();
    private final AtomicInteger acks = new AtomicInteger(0);

    public DatacenterSyncWriteResponseHandler(ReplicaPlan.ForTokenWrite replicaPlan, Runnable callback, WriteType writeType, long queryStartNanoTime) {
        super(replicaPlan, callback, writeType, queryStartNanoTime);
        assert (replicaPlan.consistencyLevel() == ConsistencyLevel.EACH_QUORUM);
        if (replicaPlan.replicationStrategy() instanceof NetworkTopologyStrategy) {
            NetworkTopologyStrategy strategy = (NetworkTopologyStrategy)replicaPlan.replicationStrategy();
            for (String dc : strategy.getDatacenters()) {
                int rf = strategy.getReplicationFactor((String)dc).allReplicas;
                this.responses.put(dc, new AtomicInteger(rf / 2 + 1));
            }
        } else {
            this.responses.put(DatabaseDescriptor.getLocalDataCenter(), new AtomicInteger(ConsistencyLevel.quorumFor(replicaPlan.replicationStrategy())));
        }
        for (Replica pending : (EndpointsForToken)replicaPlan.pending()) {
            this.responses.get(snitch.getDatacenter(pending)).incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResponse(Message<T> message) {
        try {
            String dataCenter = message == null ? DatabaseDescriptor.getLocalDataCenter() : snitch.getDatacenter(message.from());
            this.responses.get(dataCenter).getAndDecrement();
            this.acks.incrementAndGet();
            for (AtomicInteger i : this.responses.values()) {
                if (i.get() <= 0) continue;
                return;
            }
            this.signal();
        }
        finally {
            this.logResponseToIdealCLDelegate(message);
        }
    }

    @Override
    protected int ackCount() {
        return this.acks.get();
    }
}

