/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.gui;

import java.lang.reflect.Method;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.GuiElementType;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.GuiPluginType;
import org.apache.hop.core.gui.plugin.GuiWidgetElement;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiCompositeWidgets;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.util.EnvironmentUtils;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

@GuiPlugin
public class WelcomeBeam {
    private static final Class<?> PKG = WelcomeBeam.class;
    private static final String WELCOME_BEAM_PARENT_ID = "WelcomeBeam.Parent.ID";
    public static final String WEB_NAME_BEAM_GETTING_STARTED = "Getting started with Apache Beam page";
    public static final String WEB_LINK_BEAM_GETTING_STARTED = "https://hop.apache.org/manual/latest/pipeline/beam/getting-started-with-beam.html";
    private static final String EXAMPLE1_NAME = "input-process-output.hpl";
    private static final String EXAMPLE1_FILE = "${PROJECT_HOME}/beam/pipelines/input-process-output.hpl";
    private static final String EXAMPLE2_NAME = "complex.hpl";
    private static final String EXAMPLE2_FILE = "${PROJECT_HOME}/beam/pipelines/complex.hpl";
    private static final String EI_PERSPECTIVE_NAME = "execution information perspective";
    private static final String EXP_PERSPECTIVE_NAME = "file explorer perspective";

    @GuiWidgetElement(type=GuiElementType.COMPOSITE, id="20000-beam-welcome", label="Apache Beam", parentId="WelcomeDialog.Parent.ID")
    public void welcome(Composite parent) {
        PropsUi props = PropsUi.getInstance();
        Composite parentComposite = new Composite(parent, 0);
        parentComposite.setLayout(props.createFormLayout());
        FormData fdParentComposite = new FormData();
        fdParentComposite.left = new FormAttachment(0, 0);
        fdParentComposite.right = new FormAttachment(100, 0);
        fdParentComposite.top = new FormAttachment(0, 0);
        fdParentComposite.bottom = new FormAttachment(100, 0);
        parentComposite.setLayoutData((Object)fdParentComposite);
        PropsUi.setLook((Widget)parentComposite);
        GuiCompositeWidgets compositeWidgets = new GuiCompositeWidgets(HopGui.getInstance().getVariables());
        compositeWidgets.createCompositeWidgets((Object)this, null, parentComposite, WELCOME_BEAM_PARENT_ID, null);
    }

    @GuiWidgetElement(id="WelcomeBeam.10010.getting-started", parentId="WelcomeBeam.Parent.ID", type=GuiElementType.LINK, label="To get started with building and running Beam pipelines, see our <a>Getting started with Apache Beam page</a>.\n\nYou can also open one of the 'Hello, world' examples below:")
    public void homepageLink(Event event) {
        this.handleWebLinkEvent(event, WEB_NAME_BEAM_GETTING_STARTED, WEB_LINK_BEAM_GETTING_STARTED);
    }

    @GuiWidgetElement(id="WelcomeBeam.11000.example1", parentId="WelcomeBeam.Parent.ID", type=GuiElementType.LINK, label="- A simple pipeline which read from and writes to a file: <a>input-process-output.hpl</a>")
    public void openBeamSample1(Event event) {
        this.openSampleFileEvent(event, EXAMPLE1_NAME, EXAMPLE1_FILE);
    }

    @GuiWidgetElement(id="WelcomeBeam.11000.example1", parentId="WelcomeBeam.Parent.ID", type=GuiElementType.LINK, label="- Open a more complex pipeline showcasing the possibilities: <a>complex.hpl</a>")
    public void openBeamSample2(Event event) {
        this.openSampleFileEvent(event, EXAMPLE2_NAME, EXAMPLE2_FILE);
    }

    @GuiWidgetElement(id="WelcomeBeam.12000.running-a-sample", parentId="WelcomeBeam.Parent.ID", type=GuiElementType.LINK, label="\nTo run a sample, click on the start icon (triangle).  You can safely use the Direct, Spark and Flink run configurations to execute.\nDuring the execution you can take a look in the <a>execution information perspective</a>.\nThe results of the pipelines are written to the beam/output folder in the form of CSV files. You can list and even open these files with the <a>file explorer perspective</a>.\n")
    public void runningSamples(Event event) {
        if (EI_PERSPECTIVE_NAME.equals(event.text)) {
            HopGui.getExecutionPerspective().activate();
        }
        if (EXP_PERSPECTIVE_NAME.equals(event.text)) {
            HopGui.getExplorerPerspective().activate();
        }
    }

    private void openSampleFileEvent(Event event, String expectedText, String filename) {
        try {
            if (expectedText.equals(event.text)) {
                if (!this.checkProject()) {
                    return;
                }
                IVariables variables = HopGui.getInstance().getVariables();
                HopGui.getInstance().fileDelegate.fileOpen(variables.resolve(filename));
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error opening sample file " + filename, e);
        }
    }

    private void handleWebLinkEvent(Event event, String text, String url) {
        try {
            if (text.equals(event.text)) {
                EnvironmentUtils.getInstance().openUrl(url);
            }
        }
        catch (Exception e) {
            new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Error opening link to " + url, e);
        }
    }

    private boolean checkProject() {
        String projectName = HopNamespace.getNamespace();
        if ("samples".equalsIgnoreCase(projectName)) {
            return true;
        }
        MessageBox box = new MessageBox(HopGui.getInstance().getShell(), 448);
        box.setText("Switch to samples project");
        box.setMessage("This example works best in the samples project.\nDo you want to switch to the samples project now?\n");
        int answer = box.open();
        if ((answer & 0x80) != 0) {
            return true;
        }
        if ((answer & 0x40) != 0) {
            try {
                PluginRegistry registry = PluginRegistry.getInstance();
                String guiPluginClassName = "org.apache.hop.projects.gui.ProjectsGuiPlugin";
                IPlugin plugin = registry.findPluginWithId(GuiPluginType.class, guiPluginClassName);
                if (plugin == null) {
                    throw new HopException("Unable to switch projects because the projects GUI plugin couldn't be found");
                }
                ClassLoader classLoader = registry.getClassLoader(plugin);
                Class<?> guiPluginClass = classLoader.loadClass(guiPluginClassName);
                Method method = guiPluginClass.getMethod("enableProject", String.class);
                method.invoke(null, "samples");
                return true;
            }
            catch (Exception e) {
                new ErrorDialog(HopGui.getInstance().getShell(), "Error", "Sorry, I couldn't switch to the samples project", e);
                return false;
            }
        }
        return false;
    }
}

