/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.graph;

import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrivialNativeTransformExpander {
    private static final Logger LOG = LoggerFactory.getLogger(TrivialNativeTransformExpander.class);

    public static RunnerApi.Pipeline forKnownUrns(RunnerApi.Pipeline pipeline, Set<String> knownUrns) {
        return TrivialNativeTransformExpander.makeKnownUrnsPrimitives(pipeline, knownUrns);
    }

    private static RunnerApi.Pipeline makeKnownUrnsPrimitives(RunnerApi.Pipeline pipeline, Set<String> knownUrns) {
        RunnerApi.Pipeline.Builder trimmedPipeline = pipeline.toBuilder();
        for (String ptransformId : pipeline.getComponents().getTransformsMap().keySet()) {
            RunnerApi.PTransform currentTransform = trimmedPipeline.getComponents().getTransformsOrDefault(ptransformId, null);
            if (currentTransform == null || !knownUrns.contains(currentTransform.getSpec().getUrn())) continue;
            LOG.debug("Removing descendants and environment of known native PTransform {}", (Object)ptransformId);
            TrivialNativeTransformExpander.removeDescendants(trimmedPipeline, ptransformId);
            trimmedPipeline.getComponentsBuilder().putTransforms(ptransformId, currentTransform.toBuilder().clearSubtransforms().clearEnvironmentId().build());
        }
        return trimmedPipeline.build();
    }

    private static void removeDescendants(RunnerApi.Pipeline.Builder pipeline, String parentId) {
        RunnerApi.PTransform parentProto = pipeline.getComponents().getTransformsOrThrow(parentId);
        for (String childId : parentProto.getSubtransformsList()) {
            TrivialNativeTransformExpander.removeDescendants(pipeline, childId);
            pipeline.getComponentsBuilder().removeTransforms(childId);
        }
    }
}

