/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandraoutput;

import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transforms.cassandraoutput.CassandraOutput;
import org.apache.hop.pipeline.transforms.cassandraoutput.CassandraOutputData;
import org.w3c.dom.Node;

@Transform(id="CassandraOutput", image="Cassandraout.svg", name="Cassandra output", description="Writes to a Cassandra table", documentationUrl="/pipeline/transforms/cassandra-output.html", keywords={"i18n::CassandraOutputMeta.keyword"}, categoryDescription="Cassandra")
@InjectionSupported(localizationPrefix="CassandraOutput.Injection.")
public class CassandraOutputMeta
extends BaseTransformMeta<CassandraOutput, CassandraOutputData> {
    public static final Class<?> PKG = CassandraOutputMeta.class;
    @Injection(name="CONNECTION")
    protected String connectionName;
    @Injection(name="SCHEMA_HOST")
    protected String schemaHost;
    @Injection(name="SCHEMA_PORT")
    protected String schemaPort;
    @Injection(name="TABLE")
    protected String tableName = "";
    @Injection(name="CONSISTENCY_LEVEL")
    protected String consistency = "";
    @Injection(name="BATCH_SIZE")
    protected String batchSize = "100";
    @Injection(name="USE_UNLOGGED_BATCH")
    protected boolean useUnloggedBatch = false;
    @Injection(name="CREATE_TABLE")
    protected boolean createTable = true;
    @Injection(name="CREATE_TABLE_WITH_CLAUSE")
    protected String createTableWithClause;
    @Injection(name="KEY_FIELD")
    protected String keyField = "";
    @Injection(name="BATCH_TIMEOUT")
    protected String cqlBatchInsertTimeout = "";
    @Injection(name="SUB_BATCH_SIZE")
    protected String cqlSubBatchSize = "10";
    @Injection(name="INSERT_FIELDS_NOT_IN_META")
    protected boolean insertFieldsNotInMeta = false;
    @Injection(name="UPDATE_CASSANDRA_META")
    protected boolean updateCassandraMeta = false;
    @Injection(name="TRUNCATE_TABLE")
    protected boolean truncateTable = false;
    @Injection(name="TTL")
    protected String ttl = "";
    @Injection(name="TTL_UNIT")
    protected String ttlUnit = TtlUnits.NONE.toString();

    public String getXml() {
        StringBuffer xml = new StringBuffer();
        xml.append(XmlHandler.addTagValue((String)"connection", (String)this.connectionName));
        xml.append(XmlHandler.addTagValue((String)"schema_host", (String)this.schemaHost));
        xml.append(XmlHandler.addTagValue((String)"schema_port", (String)this.schemaPort));
        xml.append(XmlHandler.addTagValue((String)"table", (String)this.tableName));
        xml.append(XmlHandler.addTagValue((String)"key_field", (String)this.keyField));
        xml.append(XmlHandler.addTagValue((String)"consistency", (String)this.consistency));
        xml.append(XmlHandler.addTagValue((String)"batch_size", (String)this.batchSize));
        xml.append(XmlHandler.addTagValue((String)"cql_batch_timeout", (String)this.cqlBatchInsertTimeout));
        xml.append(XmlHandler.addTagValue((String)"cql_sub_batch_size", (String)this.cqlSubBatchSize));
        xml.append(XmlHandler.addTagValue((String)"insert_fields_not_in_meta", (boolean)this.insertFieldsNotInMeta));
        xml.append(XmlHandler.addTagValue((String)"update_cassandra_meta", (boolean)this.updateCassandraMeta));
        xml.append(XmlHandler.addTagValue((String)"truncate_table", (boolean)this.truncateTable));
        xml.append(XmlHandler.addTagValue((String)"unlogged_batch", (boolean)this.useUnloggedBatch));
        xml.append(XmlHandler.addTagValue((String)"create_table", (boolean)this.createTable));
        xml.append(XmlHandler.addTagValue((String)"create_table_with_clause", (String)this.createTableWithClause));
        xml.append(XmlHandler.addTagValue((String)"ttl", (String)this.ttl));
        xml.append(XmlHandler.addTagValue((String)"ttl_unit", (String)this.ttlUnit));
        return xml.toString();
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.connectionName = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
        this.schemaHost = XmlHandler.getTagValue((Node)transformNode, (String)"schema_host");
        this.schemaPort = XmlHandler.getTagValue((Node)transformNode, (String)"schema_port");
        this.tableName = XmlHandler.getTagValue((Node)transformNode, (String)"table");
        this.keyField = XmlHandler.getTagValue((Node)transformNode, (String)"key_field");
        this.consistency = XmlHandler.getTagValue((Node)transformNode, (String)"consistency");
        this.batchSize = XmlHandler.getTagValue((Node)transformNode, (String)"batch_size");
        this.cqlBatchInsertTimeout = XmlHandler.getTagValue((Node)transformNode, (String)"cql_batch_timeout");
        this.cqlSubBatchSize = XmlHandler.getTagValue((Node)transformNode, (String)"cql_sub_batch_size");
        this.createTable = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"create_table"));
        this.insertFieldsNotInMeta = XmlHandler.getTagValue((Node)transformNode, (String)"insert_fields_not_in_meta").equalsIgnoreCase("Y");
        this.updateCassandraMeta = XmlHandler.getTagValue((Node)transformNode, (String)"update_cassandra_meta").equalsIgnoreCase("Y");
        this.truncateTable = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"truncate_table"));
        this.createTableWithClause = XmlHandler.getTagValue((Node)transformNode, (String)"create_table_with_clause");
        this.useUnloggedBatch = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"unlogged_batch"));
        this.ttl = XmlHandler.getTagValue((Node)transformNode, (String)"ttl");
        this.ttlUnit = XmlHandler.getTagValue((Node)transformNode, (String)"ttl_unit");
        if (Utils.isEmpty((CharSequence)this.ttlUnit)) {
            this.ttlUnit = TtlUnits.NONE.toString();
        }
    }

    public void setDefault() {
        this.schemaHost = "localhost";
        this.schemaPort = "9042";
        this.tableName = "";
        this.batchSize = "100";
        this.insertFieldsNotInMeta = false;
        this.updateCassandraMeta = false;
        this.truncateTable = false;
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public String getSchemaHost() {
        return this.schemaHost;
    }

    public void setSchemaHost(String schemaHost) {
        this.schemaHost = schemaHost;
    }

    public String getSchemaPort() {
        return this.schemaPort;
    }

    public void setSchemaPort(String schemaPort) {
        this.schemaPort = schemaPort;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getConsistency() {
        return this.consistency;
    }

    public void setConsistency(String consistency) {
        this.consistency = consistency;
    }

    public String getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(String batchSize) {
        this.batchSize = batchSize;
    }

    public boolean isUseUnloggedBatch() {
        return this.useUnloggedBatch;
    }

    public void setUseUnloggedBatch(boolean useUnloggedBatch) {
        this.useUnloggedBatch = useUnloggedBatch;
    }

    public boolean isCreateTable() {
        return this.createTable;
    }

    public void setCreateTable(boolean createTable) {
        this.createTable = createTable;
    }

    public String getCreateTableWithClause() {
        return this.createTableWithClause;
    }

    public void setCreateTableWithClause(String createTableWithClause) {
        this.createTableWithClause = createTableWithClause;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getCqlBatchInsertTimeout() {
        return this.cqlBatchInsertTimeout;
    }

    public void setCqlBatchInsertTimeout(String cqlBatchInsertTimeout) {
        this.cqlBatchInsertTimeout = cqlBatchInsertTimeout;
    }

    public String getCqlSubBatchSize() {
        return this.cqlSubBatchSize;
    }

    public void setCqlSubBatchSize(String cqlSubBatchSize) {
        this.cqlSubBatchSize = cqlSubBatchSize;
    }

    public boolean isInsertFieldsNotInMeta() {
        return this.insertFieldsNotInMeta;
    }

    public void setInsertFieldsNotInMeta(boolean insertFieldsNotInMeta) {
        this.insertFieldsNotInMeta = insertFieldsNotInMeta;
    }

    public boolean isUpdateCassandraMeta() {
        return this.updateCassandraMeta;
    }

    public void setUpdateCassandraMeta(boolean updateCassandraMeta) {
        this.updateCassandraMeta = updateCassandraMeta;
    }

    public boolean isTruncateTable() {
        return this.truncateTable;
    }

    public void setTruncateTable(boolean truncateTable) {
        this.truncateTable = truncateTable;
    }

    public String getTtl() {
        return this.ttl;
    }

    public void setTtl(String ttl) {
        this.ttl = ttl;
    }

    public String getTtlUnit() {
        return this.ttlUnit;
    }

    public void setTtlUnit(String ttlUnit) {
        this.ttlUnit = ttlUnit;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(String connectionName) {
        this.connectionName = connectionName;
    }

    public static enum TtlUnits {
        NONE(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.None", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return -1;
            }
        }
        ,
        SECONDS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Seconds", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value;
            }
        }
        ,
        MINUTES(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Minutes", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value * 60;
            }
        }
        ,
        HOURS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Hours", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value * 60 * 60;
            }
        }
        ,
        DAYS(BaseMessages.getString(PKG, (String)"CassandraOutput.TTLUnit.Days", (String[])new String[0])){

            @Override
            int convertToSeconds(int value) {
                return value * 60 * 60 * 24;
            }
        };

        private final String stringVal;

        private TtlUnits(String name) {
            this.stringVal = name;
        }

        public String toString() {
            return this.stringVal;
        }

        abstract int convertToSeconds(int var1);
    }
}

