/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.dataflow.util.CloudObject;
import org.apache.beam.runners.dataflow.util.CloudObjectTranslator;
import org.apache.beam.runners.dataflow.util.Structs;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaTranslation;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.util.StringUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.Message;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.MessageOrBuilder;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.util.JsonFormat;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SchemaCoderCloudObjectTranslator
implements CloudObjectTranslator<SchemaCoder> {
    private static final String SCHEMA = "schema";
    private static final String TYPE_DESCRIPTOR = "typeDescriptor";
    private static final String TO_ROW_FUNCTION = "toRowFunction";
    private static final String FROM_ROW_FUNCTION = "fromRowFunction";

    @Override
    public CloudObject toCloudObject(SchemaCoder target, SdkComponents sdkComponents) {
        CloudObject base = CloudObject.forClass(SchemaCoder.class);
        Structs.addString((Map<String, Object>)((Object)base), TYPE_DESCRIPTOR, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getEncodedTypeDescriptor())));
        Structs.addString((Map<String, Object>)((Object)base), TO_ROW_FUNCTION, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getToRowFunction())));
        Structs.addString((Map<String, Object>)((Object)base), FROM_ROW_FUNCTION, StringUtils.byteArrayToJsonString((byte[])SerializableUtils.serializeToByteArray((Serializable)target.getFromRowFunction())));
        try {
            Structs.addString((Map<String, Object>)((Object)base), SCHEMA, JsonFormat.printer().print((MessageOrBuilder)SchemaTranslation.schemaToProto((Schema)target.getSchema(), (boolean)true)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return base;
    }

    @Override
    public SchemaCoder fromCloudObject(CloudObject cloudObject) {
        try {
            TypeDescriptor typeDescriptor = (TypeDescriptor)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), TYPE_DESCRIPTOR)), (String)TYPE_DESCRIPTOR);
            SerializableFunction toRowFunction = (SerializableFunction)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), TO_ROW_FUNCTION)), (String)TO_ROW_FUNCTION);
            SerializableFunction fromRowFunction = (SerializableFunction)SerializableUtils.deserializeFromByteArray((byte[])StringUtils.jsonStringToByteArray((String)Structs.getString((Map<String, Object>)((Object)cloudObject), FROM_ROW_FUNCTION)), (String)FROM_ROW_FUNCTION);
            SchemaApi.Schema.Builder schemaBuilder = SchemaApi.Schema.newBuilder();
            JsonFormat.parser().merge(Structs.getString((Map<String, Object>)((Object)cloudObject), SCHEMA), (Message.Builder)schemaBuilder);
            Schema schema = SchemaTranslation.schemaFromProto((SchemaApi.Schema)schemaBuilder.build());
            UUID uuid = schema.getUUID();
            if (schema.isEncodingPositionsOverridden() && uuid != null) {
                SchemaCoder.overrideEncodingPositions((UUID)uuid, (Map)schema.getEncodingPositions());
            }
            return SchemaCoder.of((Schema)schema, (TypeDescriptor)typeDescriptor, (SerializableFunction)toRowFunction, (SerializableFunction)fromRowFunction);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Class<? extends SchemaCoder> getSupportedClass() {
        return SchemaCoder.class;
    }

    @Override
    public String cloudObjectClassName() {
        return CloudObject.forClass(SchemaCoder.class).getClassName();
    }
}

