/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;

public class BeamConst {
    public static final String STRING_BEAM_INPUT_PLUGIN_ID = "BeamInput";
    public static final String STRING_BEAM_OUTPUT_PLUGIN_ID = "BeamOutput";
    public static final String STRING_BEAM_SUBSCRIBE_PLUGIN_ID = "BeamSubscribe";
    public static final String STRING_BEAM_PUBLISH_PLUGIN_ID = "BeamPublish";
    public static final String STRING_MEMORY_GROUP_BY_PLUGIN_ID = "MemoryGroupBy";
    public static final String STRING_MERGE_JOIN_PLUGIN_ID = "MergeJoin";
    public static final String STRING_BEAM_WINDOW_PLUGIN_ID = "BeamWindow";
    public static final String STRING_BEAM_TIMESTAMP_PLUGIN_ID = "BeamTimestamp";
    public static final String STRING_BEAM_BIGQUERY_INPUT_PLUGIN_ID = "BeamBQInput";
    public static final String STRING_BEAM_BIGQUERY_OUTPUT_PLUGIN_ID = "BeamBQOutput";
    public static final String STRING_BEAM_KAFKA_CONSUME_PLUGIN_ID = "BeamKafkaConsume";
    public static final String STRING_BEAM_KAFKA_PRODUCE_PLUGIN_ID = "BeamKafkaProduce";
    public static final String STRING_BEAM_ROW_GENERATOR_PLUGIN_ID = "RowGenerator";
    public static final String STRING_HOP_BEAM = "Hop Beam";
    public static final String STRING_TRANSFORM_FLAG_BATCH = "Batch";
    public static final String STRING_TRANSFORM_FLAG_SINGLE_THREADED = "SingleThreaded";
    private static List<String[]> gcpWorkerCodeDescriptions = Arrays.asList({"n1-standard-1", "Standard machine type with 1 vCPU and 3.75 GB of memory."}, {"n1-standard-2", "Standard machine type with 2 vCPUs and 7.5 GB of memory."}, {"n1-standard-4", "Standard machine type with 4 vCPUs and 15 GB of memory."}, {"n1-standard-8", "Standard machine type with 8 vCPUs and 30 GB of memory."}, {"n1-standard-16", "Standard machine type with 16 vCPUs and 60 GB of memory."}, {"n1-standard-32", "Standard machine type with 32 vCPUs and 120 GB of memory."}, {"n1-standard-64", "Standard machine type with 64 vCPUs and 240 GB of memory."}, {"n1-standard-96", "Standard machine type with 96 vCPUs and 360 GB of memory."}, {"n1-highmem-2", "High memory machine type with 2 vCPUs and 13 GB of memory."}, {"n1-highmem-4", "High memory machine type with 4 vCPUs, and 26 GB of memory."}, {"n1-highmem-8", "High memory machine type with 8 vCPUs and 52 GB of memory."}, {"n1-highmem-16", "High memory machine type with 16 vCPUs and 104 GB of memory."}, {"n1-highmem-32", "High memory machine type with 32 vCPUs and 208 GB of memory."}, {"n1-highmem-64", "High memory machine type with 64 vCPUs and 416 GB of memory."}, {"n1-highmem-96", "High memory machine type with 96 vCPUs and 624 GB of memory."}, {"n1-highcpu-2", "High-CPU machine type with 2 vCPUs and 1.80 GB of memory."}, {"n1-highcpu-4", "High-CPU machine type with 4 vCPUs and 3.60 GB of memory."}, {"n1-highcpu-8", "High-CPU machine type with 8 vCPUs and 7.20 GB of memory."}, {"n1-highcpu-16", "High-CPU machine type with 16 vCPUs and 14.4 GB of memory."}, {"n1-highcpu-32", "High-CPU machine type with 32 vCPUs and 28.8 GB of memory."}, {"n1-highcpu-64", "High-CPU machine type with 64 vCPUs and 57.6 GB of memory."}, {"n1-highcpu-96", "High-CPU machine type with 96 vCPUs and 86.4 GB of memory."}, {"f1-micro", "Micro machine type with 0.2 vCPU, 0.60 GB of memory, backed by a shared physical core."}, {"g1-small", "Shared-core machine type with 0.5 vCPU, 1.70 GB of memory, backed by a shared physical core."}, {"n1-ultramem-40", "Memory-optimized machine type with 40 vCPUs and 961GB of memory."}, {"n1-ultramem-80", "Memory-optimized machine type with 80 vCPUs and 1.87 TB of memory."}, {"n1-megamem-96", "Memory-optimized machine type with 96 vCPUs and 1.4 TB of memory."}, {"n1-ultramem-160", "Memory-optimized machine type with 160 vCPUs and 3.75 TB of memory."});
    private static List<String[]> gcpRegionCodeZonesDescriptions = Arrays.asList({"asia-east1", "a, b, c", "Changhua County, Taiwan"}, {"asia-east2", "a, b, c", "Hong Kong"}, {"asia-northeast1", "a, b, c", "Tokyo, Japan"}, {"asia-south1", "a, b, c", "Mumbai, India"}, {"asia-southeast1", "a, b, c", "Jurong West, Singapore"}, {"australia-southeast1", "a, b, c", "Sydney, Australia"}, {"europe-north1", "a, b, c", "Hamina, Finland"}, {"europe-west1", "b, c, d", "St. Ghislain, Belgium"}, {"europe-west2", "a, b, c", "London, England, UK"}, {"europe-west3", "a, b, c", "Frankfurt, Germany"}, {"europe-west4", "a, b, c", "Eemshaven, Netherlands"}, {"northamerica-northeast1", "a, b, c", "Montr\u00e9al, Qu\u00e9bec, Canada"}, {"southamerica-east1", "a, b, c", "S\u00e3o Paulo, Brazil"}, {"us-central1", "a, b, c, f", "Council Bluffs, Iowa, USA"}, {"us-east1", "b, c, d", "Moncks Corner, South Carolina, USA"}, {"us-east4", "a, b, c", "Ashburn, Northern Virginia, USA"}, {"us-west1", "a, b, c", "The Dalles, Oregon, USA"}, {"us-west2", "a, b, c", "Los Angeles, California, USA"});

    public static final String[] getGcpWorkerMachineTypeCodes() {
        String[] codes = new String[gcpWorkerCodeDescriptions.size()];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = gcpWorkerCodeDescriptions.get(i)[0];
        }
        return codes;
    }

    public static final String[] getGcpWorkerMachineTypeDescriptions() {
        String[] descriptions = new String[gcpWorkerCodeDescriptions.size()];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = gcpWorkerCodeDescriptions.get(i)[1];
        }
        return descriptions;
    }

    public static final String[] getGcpRegionCodes() {
        String[] codes = new String[gcpRegionCodeZonesDescriptions.size()];
        for (int i = 0; i < codes.length; ++i) {
            codes[i] = gcpRegionCodeZonesDescriptions.get(i)[0];
        }
        return codes;
    }

    public static final String[] getGcpRegionDescriptions() {
        String[] descriptions = new String[gcpRegionCodeZonesDescriptions.size()];
        for (int i = 0; i < descriptions.length; ++i) {
            descriptions[i] = gcpRegionCodeZonesDescriptions.get(i)[2];
        }
        return descriptions;
    }

    public static final List<String> findLibraryFilesToStage(String baseFolder, String pluginFolders, boolean includeParent, boolean includeBeam) throws HopException {
        try {
            File base = baseFolder == null ? new File(".") : new File(baseFolder);
            HashSet<String> pluginFoldersSet = new HashSet<String>();
            if (StringUtils.isNotEmpty((String)pluginFolders)) {
                String[] folders;
                for (String folder : folders = pluginFolders.split(",")) {
                    pluginFoldersSet.add(folder);
                }
            }
            if (includeBeam) {
                pluginFoldersSet.add("engines/beam");
            }
            return BeamConst.findLibraryFilesToStage(base, includeParent, pluginFoldersSet);
        }
        catch (Exception e) {
            throw new HopException("Error finding libraries to stage", (Throwable)e);
        }
    }

    public static List<String> findLibraryFilesToStage(File baseFolder, boolean includeParent, Set<String> pluginFoldersSet) throws IOException {
        ArrayList<String> libraries = new ArrayList<String>();
        HashSet<String> uniqueNames = new HashSet<String>();
        for (String pluginFolder : pluginFoldersSet) {
            File pluginsFolder = new File(baseFolder.toString() + "/plugins/" + pluginFolder);
            if (pluginsFolder.exists()) {
                Collection pluginFiles = FileUtils.listFiles((File)pluginsFolder, (String[])new String[]{"jar"}, (boolean)true);
                if (pluginFiles == null) continue;
                for (File file : pluginFiles) {
                    String shortName = file.getName();
                    if (uniqueNames.contains(shortName)) continue;
                    uniqueNames.add(shortName);
                    libraries.add(file.getCanonicalPath());
                }
                continue;
            }
            System.out.println("Warning: couldn't find plugins folder: " + pluginsFolder);
        }
        if (includeParent) {
            File libFolder = new File(baseFolder.toString() + "/lib");
            if (libFolder.exists()) {
                Collection files = FileUtils.listFiles((File)libFolder, (String[])new String[]{"jar"}, (boolean)true);
                if (files != null) {
                    for (File file : files) {
                        String shortName = file.getName();
                        if (uniqueNames.contains(shortName)) continue;
                        uniqueNames.add(shortName);
                        libraries.add(file.getCanonicalPath());
                    }
                }
            } else {
                System.out.println("Warning: couldn't find hop lib folder: " + libFolder);
            }
        }
        return libraries;
    }
}

