/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.AvroGenericCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamKafkaOutputTransform;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.kafka.BeamProduce;
import org.apache.hop.beam.transforms.kafka.BeamProduceDialog;
import org.apache.hop.beam.transforms.kafka.ConfigOption;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaAvroRecord;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dummy.DummyData;

@Transform(id="BeamKafkaProduce", name="Beam Kafka Produce", description="Send messages to a Kafka Topic (Producer)", image="beam-kafka-output.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.BigData", keywords={"i18n::BeamProduceMeta.keyword"}, documentationUrl="/pipeline/transforms/beamkafkaproduce.html")
public class BeamProduceMeta
extends BaseTransformMeta<BeamProduce, DummyData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="bootstrap_servers")
    private String bootstrapServers = "bootstrapServer1:9001,bootstrapServer2:9001";
    @HopMetadataProperty
    private String topic = "Topic1";
    @HopMetadataProperty(key="key_field")
    private String keyField = "";
    @HopMetadataProperty(key="message_field")
    private String messageField = "";
    @HopMetadataProperty(groupKey="config_options", key="config_option")
    private List<ConfigOption> configOptions = new ArrayList<ConfigOption>();

    public String getDialogClassName() {
        return BeamProduceDialog.class.getName();
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        inputRowMeta.clear();
    }

    @Override
    public boolean isInput() {
        return false;
    }

    @Override
    public boolean isOutput() {
        return true;
    }

    @Override
    public void handleTransform(ILogChannel log, IVariables variables, IBeamPipelineEngineRunConfiguration runConfiguration, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, List<String> transformPluginClasses, List<String> xpPluginClasses, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input) throws HopException {
        String[] parameters = new String[this.getConfigOptions().size()];
        String[] values = new String[this.getConfigOptions().size()];
        String[] types = new String[this.getConfigOptions().size()];
        for (int i = 0; i < parameters.length; ++i) {
            ConfigOption option = this.getConfigOptions().get(i);
            parameters[i] = variables.resolve(option.getParameter());
            values[i] = variables.resolve(option.getValue());
            types[i] = option.getType() == null ? ConfigOption.Type.String.name() : option.getType().name();
        }
        String messageFieldName = variables.resolve(this.getMessageField());
        IValueMeta messageValueMeta = rowMeta.searchValueMeta(messageFieldName);
        if (messageValueMeta == null) {
            throw new HopException("Error finding message/value field " + messageFieldName + " in the input rows");
        }
        if (messageValueMeta.getType() == 20) {
            ValueMetaAvroRecord valueMetaAvroRecord = (ValueMetaAvroRecord)messageValueMeta;
            Schema schema = valueMetaAvroRecord.getSchema();
            AvroGenericCoder coder = AvroCoder.of((Schema)schema);
            pipeline.getCoderRegistry().registerCoderForClass(GenericRecord.class, (Coder)coder);
        }
        BeamKafkaOutputTransform beamOutputTransform = new BeamKafkaOutputTransform(transformMeta.getName(), variables.resolve(this.getBootstrapServers()), variables.resolve(this.getTopic()), variables.resolve(this.getKeyField()), messageFieldName, parameters, values, types, JsonRowMeta.toJson(rowMeta), transformPluginClasses, xpPluginClasses);
        if (previousTransforms.size() > 1) {
            throw new HopException("Combining data from multiple transforms is not supported yet!");
        }
        TransformMeta previousTransform = previousTransforms.get(0);
        input.apply((PTransform)beamOutputTransform);
        log.logBasic("Handled transform (KAFKA OUTPUT) : " + transformMeta.getName() + ", gets data from " + previousTransform.getName());
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getKeyField() {
        return this.keyField;
    }

    public void setKeyField(String keyField) {
        this.keyField = keyField;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }

    public String getBootstrapServers() {
        return this.bootstrapServers;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public List<ConfigOption> getConfigOptions() {
        return this.configOptions;
    }

    public void setConfigOptions(List<ConfigOption> configOptions) {
        this.configOptions = configOptions;
    }
}

