/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.HopToBQTableRowFn;
import org.apache.hop.beam.core.util.JsonRowMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamBQOutputTransform
extends PTransform<PCollection<HopRow>, PDone> {
    private String transformName;
    private String projectId;
    private String datasetId;
    private String tableId;
    private String rowMetaJson;
    private boolean createIfNeeded;
    private boolean truncateTable;
    private boolean failIfNotEmpty;
    private List<String> transformPluginClasses;
    private List<String> xpPluginClasses;
    private static final Logger LOG = LoggerFactory.getLogger(BeamBQOutputTransform.class);
    private static final Counter numErrors = Metrics.counter((String)"main", (String)"BeamOutputError");

    public BeamBQOutputTransform() {
    }

    public BeamBQOutputTransform(String transformName, String projectId, String datasetId, String tableId, boolean createIfNeeded, boolean truncateTable, boolean failIfNotEmpty, String rowMetaJson, List<String> transformPluginClasses, List<String> xpPluginClasses) {
        this.transformName = transformName;
        this.projectId = projectId;
        this.datasetId = datasetId;
        this.tableId = tableId;
        this.createIfNeeded = createIfNeeded;
        this.truncateTable = truncateTable;
        this.failIfNotEmpty = failIfNotEmpty;
        this.rowMetaJson = rowMetaJson;
        this.transformPluginClasses = transformPluginClasses;
        this.xpPluginClasses = xpPluginClasses;
    }

    public PDone expand(PCollection<HopRow> input) {
        try {
            BeamHop.init(this.transformPluginClasses, this.xpPluginClasses);
            IRowMeta rowMeta = JsonRowMeta.fromJson(this.rowMetaJson);
            TableReference tableReference = new TableReference();
            if (StringUtils.isNotEmpty((String)this.projectId)) {
                tableReference.setProjectId(this.projectId);
            }
            tableReference.setDatasetId(this.datasetId);
            tableReference.setTableId(this.tableId);
            TableSchema tableSchema = new TableSchema();
            ArrayList<TableFieldSchema> schemaFields = new ArrayList<TableFieldSchema>();
            for (IValueMeta valueMeta : rowMeta.getValueMetaList()) {
                TableFieldSchema schemaField = new TableFieldSchema();
                BeamBQOutputTransform.validateBQFieldName(valueMeta.getName());
                schemaField.setName(valueMeta.getName());
                switch (valueMeta.getType()) {
                    case 2: {
                        schemaField.setType("STRING");
                        break;
                    }
                    case 5: {
                        schemaField.setType("INTEGER");
                        break;
                    }
                    case 3: {
                        schemaField.setType("DATETIME");
                        break;
                    }
                    case 4: {
                        schemaField.setType("BOOLEAN");
                        break;
                    }
                    case 1: {
                        schemaField.setType("FLOAT");
                        break;
                    }
                    default: {
                        throw new RuntimeException("Conversion from Hop value " + valueMeta.toString() + " to BigQuery TableRow isn't supported yet");
                    }
                }
                schemaFields.add(schemaField);
            }
            tableSchema.setFields(schemaFields);
            HopToBQTableRowFn formatFunction = new HopToBQTableRowFn(this.transformName, this.rowMetaJson, this.transformPluginClasses, this.xpPluginClasses);
            BigQueryIO.Write.CreateDisposition createDisposition = this.createIfNeeded ? BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED : BigQueryIO.Write.CreateDisposition.CREATE_NEVER;
            BigQueryIO.Write.WriteDisposition writeDisposition = this.truncateTable ? BigQueryIO.Write.WriteDisposition.WRITE_TRUNCATE : (this.failIfNotEmpty ? BigQueryIO.Write.WriteDisposition.WRITE_EMPTY : BigQueryIO.Write.WriteDisposition.WRITE_APPEND);
            BigQueryIO.Write bigQueryWrite = BigQueryIO.write().to(tableReference).withSchema(tableSchema).withCreateDisposition(createDisposition).withWriteDisposition(writeDisposition).withFormatFunction((SerializableFunction)formatFunction);
            input.apply(this.transformName, (PTransform)bigQueryWrite);
            return PDone.in((Pipeline)input.getPipeline());
        }
        catch (Exception e) {
            numErrors.inc();
            LOG.error("Error in Beam BigQuery output transform", (Throwable)e);
            throw new RuntimeException("Error in Beam BigQuery output transform", e);
        }
    }

    public static void validateBQFieldName(String name) throws HopException {
        if (StringUtils.isEmpty((String)name)) {
            throw new HopException("A BigQuery field name can not be empty");
        }
        if (name.length() > 300) {
            throw new HopException("A BigQuery field name can not be longer than 300 characters: '" + name + "'");
        }
        String lowerName = name.toLowerCase();
        char first = lowerName.charAt(0);
        if ((first < 'a' || first > 'z') && first != '_') {
            throw new HopException("A BigQuery field name must start with a letter or an underscore: '" + name + "'");
        }
        for (String prefix : new String[]{"_table_", "_file_", "_partition_"}) {
            if (!lowerName.startsWith(prefix)) continue;
            throw new HopException("A BigQuery field name can not start with : " + prefix.toUpperCase() + " for name: '" + name + "'");
        }
        if (name.length() > 1) {
            for (char c : name.substring(1).toLowerCase().toCharArray()) {
                if (c >= 'a' && c <= 'z' || c == '_' || c >= '0' && c <= '9') continue;
                throw new HopException("A BigQuery field name can only contain letters, digits or an underscore: '" + name + "'");
            }
        }
    }
}

