/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.encryption.Encr;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.xml.IXml;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.server.HopServer;
import org.apache.hop.www.HopServerSequence;
import org.w3c.dom.Node;

public class HopServerConfig
implements IXml {
    public static final String XML_TAG = "hop-server-config";
    public static final String XML_TAG_SEQUENCES = "sequences";
    public static final String XML_TAG_AUTOSEQUENCE = "autosequence";
    public static final String XML_TAG_AUTO_CREATE = "autocreate";
    public static final String XML_TAG_JETTY_OPTIONS = "jetty_options";
    public static final String XML_TAG_ACCEPTORS = "acceptors";
    public static final String XML_TAG_ACCEPT_QUEUE_SIZE = "acceptQueueSize";
    public static final String XML_TAG_LOW_RES_MAX_IDLE_TIME = "lowResourcesMaxIdleTime";
    public static final String XML_METADATA_FOLDER = "metadata_folder";
    private HopServer hopServer;
    private boolean joining;
    private int maxLogLines;
    private int maxLogTimeoutMinutes;
    private int objectTimeoutMinutes;
    private String filename;
    private List<DatabaseMeta> databases = new ArrayList<DatabaseMeta>();
    private List<HopServerSequence> hopServerSequences = new ArrayList<HopServerSequence>();
    private HopServerSequence autoSequence;
    private boolean automaticCreationAllowed = false;
    private String passwordFile = null;
    private String metadataFolder;
    private IVariables variables = Variables.getADefaultVariableSpace();
    private MultiMetadataProvider metadataProvider = new MultiMetadataProvider(Encr.getEncoder(), Collections.emptyList(), this.variables);

    public HopServerConfig() {
    }

    public HopServerConfig(HopServer hopServer) {
        this();
        this.hopServer = hopServer;
    }

    public String getXml(IVariables variables) {
        StringBuilder xml = new StringBuilder();
        xml.append(XmlHandler.openTag((String)XML_TAG));
        if (this.hopServer != null) {
            xml.append(this.hopServer.getXml(variables));
        }
        XmlHandler.addTagValue((String)"joining", (boolean)this.joining);
        XmlHandler.addTagValue((String)"max_log_lines", (int)this.maxLogLines);
        XmlHandler.addTagValue((String)"max_log_timeout_minutes", (int)this.maxLogTimeoutMinutes);
        XmlHandler.addTagValue((String)"object_timeout_minutes", (int)this.objectTimeoutMinutes);
        XmlHandler.addTagValue((String)XML_METADATA_FOLDER, (String)this.metadataFolder);
        xml.append(XmlHandler.openTag((String)XML_TAG_SEQUENCES));
        for (HopServerSequence hopServerSequence : this.hopServerSequences) {
            xml.append(XmlHandler.openTag((String)"sequence"));
            xml.append(hopServerSequence.getXml());
            xml.append(XmlHandler.closeTag((String)"sequence"));
        }
        xml.append(XmlHandler.closeTag((String)XML_TAG_SEQUENCES));
        if (this.autoSequence != null) {
            xml.append(XmlHandler.openTag((String)XML_TAG_AUTOSEQUENCE));
            xml.append(this.autoSequence.getXml());
            xml.append(XmlHandler.addTagValue((String)XML_TAG_AUTO_CREATE, (boolean)this.automaticCreationAllowed));
            xml.append(XmlHandler.closeTag((String)XML_TAG_AUTOSEQUENCE));
        }
        xml.append(XmlHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public HopServerConfig(ILogChannel log, Node node) throws HopXmlException {
        this();
        Node hopServerNode = XmlHandler.getSubNode((Node)node, (String)"hop-server");
        if (hopServerNode != null) {
            this.hopServer = new HopServer(hopServerNode);
            this.checkNetworkInterfaceSetting(log, hopServerNode, this.hopServer);
        }
        this.joining = XmlHandler.getTagBoolean((Node)node, (String)"joining", (boolean)true);
        this.maxLogLines = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"max_log_lines"), (int)0);
        this.maxLogTimeoutMinutes = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"max_log_timeout_minutes"), (int)0);
        this.objectTimeoutMinutes = Const.toInt((String)XmlHandler.getTagValue((Node)node, (String)"object_timeout_minutes"), (int)0);
        this.metadataFolder = XmlHandler.getTagValue((Node)node, (String)XML_METADATA_FOLDER);
        Node sequencesNode = XmlHandler.getSubNode((Node)node, (String)XML_TAG_SEQUENCES);
        List seqNodes = XmlHandler.getNodes((Node)sequencesNode, (String)"sequence");
        for (Node seqNode : seqNodes) {
            this.hopServerSequences.add(new HopServerSequence(seqNode, this.databases));
        }
        Node autoSequenceNode = XmlHandler.getSubNode((Node)node, (String)XML_TAG_AUTOSEQUENCE);
        if (autoSequenceNode != null) {
            this.autoSequence = new HopServerSequence(autoSequenceNode, this.databases);
            this.automaticCreationAllowed = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)autoSequenceNode, (String)XML_TAG_AUTO_CREATE));
        }
        this.setUpJettyOptions(node);
    }

    protected void setUpJettyOptions(Node node) {
        Map<String, String> jettyOptions = this.parseJettyOptions(node);
        if (jettyOptions != null && jettyOptions.size() > 0) {
            for (Map.Entry<String, String> jettyOption : jettyOptions.entrySet()) {
                System.setProperty(jettyOption.getKey(), jettyOption.getValue());
            }
        }
    }

    protected Map<String, String> parseJettyOptions(Node node) {
        HashMap<String, String> jettyOptions = null;
        Node jettyOptionsNode = XmlHandler.getSubNode((Node)node, (String)XML_TAG_JETTY_OPTIONS);
        if (jettyOptionsNode != null) {
            jettyOptions = new HashMap<String, String>();
            if (XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPTORS) != null) {
                jettyOptions.put("HOP_SERVER_JETTY_ACCEPTORS", XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPTORS));
            }
            if (XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPT_QUEUE_SIZE) != null) {
                jettyOptions.put("HOP_SERVER_JETTY_ACCEPT_QUEUE_SIZE", XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_ACCEPT_QUEUE_SIZE));
            }
            if (XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_LOW_RES_MAX_IDLE_TIME) != null) {
                jettyOptions.put("HOP_SERVER_JETTY_RES_MAX_IDLE_TIME", XmlHandler.getTagValue((Node)jettyOptionsNode, (String)XML_TAG_LOW_RES_MAX_IDLE_TIME));
            }
        }
        return jettyOptions;
    }

    public void readAutoSequences() throws HopException {
        if (this.autoSequence == null) {
            return;
        }
        Database database = null;
        try {
            DatabaseMeta databaseMeta = this.autoSequence.getDatabaseMeta();
            SimpleLoggingObject loggingInterface = new SimpleLoggingObject("auto-sequence", LoggingObjectType.GENERAL, null);
            database = new Database((ILoggingObject)loggingInterface, this.variables, databaseMeta);
            database.connect();
            String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, this.autoSequence.getSchemaName(), this.autoSequence.getTableName());
            String seqField = databaseMeta.quoteField(this.autoSequence.getSequenceNameField());
            String valueField = databaseMeta.quoteField(this.autoSequence.getValueField());
            String sql = "SELECT " + seqField + ", " + valueField + " FROM " + schemaTable;
            List rows = database.getRows(sql, 0);
            IRowMeta rowMeta = database.getReturnRowMeta();
            for (Object[] row : rows) {
                Long value;
                String sequenceName = rowMeta.getString(row, seqField, null);
                if (Utils.isEmpty((CharSequence)sequenceName) || (value = rowMeta.getInteger(row, valueField, null)) == null) continue;
                HopServerSequence hopServerSequence = new HopServerSequence(sequenceName, value, databaseMeta, this.autoSequence.getSchemaName(), this.autoSequence.getTableName(), this.autoSequence.getSequenceNameField(), this.autoSequence.getValueField());
                this.hopServerSequences.add(hopServerSequence);
                LogChannel.GENERAL.logBasic("Automatically created server sequence '" + hopServerSequence.getName() + "' with start value " + hopServerSequence.getStartValue());
            }
        }
        catch (Exception e) {
            throw new HopException("Unable to automatically configure server sequences", (Throwable)e);
        }
        finally {
            if (database != null) {
                database.disconnect();
            }
        }
    }

    private void checkNetworkInterfaceSetting(ILogChannel log, Node serverNode, HopServer hopServer) {
        String networkInterfaceName = XmlHandler.getTagValue((Node)serverNode, (String)"network_interface");
        if (!Utils.isEmpty((CharSequence)networkInterfaceName)) {
            try {
                String newHostname = Const.getIPAddress((String)networkInterfaceName);
                if (newHostname != null) {
                    hopServer.setHostname(newHostname);
                    hopServer.setName(hopServer.getName() + "-" + newHostname);
                    log.logBasic("Hostname for hop server [" + hopServer.getName() + "] is set to [" + newHostname + "], information derived from network " + networkInterfaceName);
                }
            }
            catch (SocketException e) {
                log.logError("Unable to get the IP address for network interface " + networkInterfaceName + " for hop server [" + hopServer.getName() + "]", (Throwable)e);
            }
        }
    }

    public HopServerConfig(String hostname, int port, boolean joining) {
        this();
        this.joining = joining;
        this.hopServer = new HopServer(hostname + ":" + port, hostname, "" + port, null, null);
    }

    public HopServer getHopServer() {
        return this.hopServer;
    }

    public void setHopServer(HopServer hopServer) {
        this.hopServer = hopServer;
    }

    public boolean isJoining() {
        return this.joining;
    }

    public void setJoining(boolean joining) {
        this.joining = joining;
    }

    public int getMaxLogLines() {
        return this.maxLogLines;
    }

    public void setMaxLogLines(int maxLogLines) {
        this.maxLogLines = maxLogLines;
    }

    public int getMaxLogTimeoutMinutes() {
        return this.maxLogTimeoutMinutes;
    }

    public void setMaxLogTimeoutMinutes(int maxLogTimeoutMinutes) {
        this.maxLogTimeoutMinutes = maxLogTimeoutMinutes;
    }

    public int getObjectTimeoutMinutes() {
        return this.objectTimeoutMinutes;
    }

    public void setObjectTimeoutMinutes(int objectTimeoutMinutes) {
        this.objectTimeoutMinutes = objectTimeoutMinutes;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public List<DatabaseMeta> getDatabases() {
        return this.databases;
    }

    public void setDatabases(List<DatabaseMeta> databases) {
        this.databases = databases;
    }

    public List<HopServerSequence> getHopServerSequences() {
        return this.hopServerSequences;
    }

    public void setHopServerSequences(List<HopServerSequence> hopServerSequences) {
        this.hopServerSequences = hopServerSequences;
    }

    public HopServerSequence getAutoSequence() {
        return this.autoSequence;
    }

    public void setAutoSequence(HopServerSequence autoSequence) {
        this.autoSequence = autoSequence;
    }

    public boolean isAutomaticCreationAllowed() {
        return this.automaticCreationAllowed;
    }

    public void setAutomaticCreationAllowed(boolean automaticCreationAllowed) {
        this.automaticCreationAllowed = automaticCreationAllowed;
    }

    public String getPasswordFile() {
        return this.passwordFile;
    }

    public void setPasswordFile(String passwordFile) {
        this.passwordFile = passwordFile;
    }

    public IVariables getVariables() {
        return this.variables;
    }

    public void setVariables(IVariables variables) {
        this.variables = variables;
    }

    public String getMetadataFolder() {
        return this.metadataFolder;
    }

    public void setMetadataFolder(String metadataFolder) {
        this.metadataFolder = metadataFolder;
    }

    public MultiMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    public void setMetadataProvider(MultiMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }
}

