/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.www;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.annotations.HopServerServlet;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.logging.SimpleLoggingObject;
import org.apache.hop.core.metadata.SerializableMetadataProvider;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineConfiguration;
import org.apache.hop.pipeline.PipelineExecutionConfiguration;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engine.PipelineEngineFactory;
import org.apache.hop.workflow.WorkflowConfiguration;
import org.apache.hop.workflow.WorkflowExecutionConfiguration;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEngineFactory;
import org.apache.hop.www.BaseHttpServlet;
import org.apache.hop.www.IHopServerPlugin;
import org.apache.hop.www.PipelineMap;
import org.apache.hop.www.RegisterPackageServlet;
import org.apache.hop.www.WebResult;
import org.apache.hop.www.WorkflowMap;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

@HopServerServlet(id="addExport", name="Upload a resources export file")
public class AddExportServlet
extends BaseHttpServlet
implements IHopServerPlugin {
    public static final String PARAMETER_LOAD = "load";
    public static final String PARAMETER_TYPE = "type";
    public static final String TYPE_WORKFLOW = "workflow";
    public static final String TYPE_PIPELINE = "pipeline";
    private static final long serialVersionUID = -6850701762586992604L;
    public static final String CONTEXT_PATH = "/hop/addExport";

    public AddExportServlet() {
    }

    public AddExportServlet(WorkflowMap workflowMap, PipelineMap transformationMap) {
        super(transformationMap, workflowMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.isJettyMode() && !request.getRequestURI().startsWith(CONTEXT_PATH)) {
            return;
        }
        if (this.log.isDebug()) {
            this.logDebug("Addition of export requested");
        }
        PrintWriter out = response.getWriter();
        ServletInputStream in = request.getInputStream();
        if (this.log.isDetailed()) {
            this.logDetailed("Encoding: " + request.getCharacterEncoding());
        }
        boolean isWorkflow = TYPE_WORKFLOW.equalsIgnoreCase(request.getParameter(PARAMETER_TYPE));
        String load = request.getParameter(PARAMETER_LOAD);
        response.setContentType("text/xml");
        out.print(XmlHandler.getXmlHeader());
        response.setStatus(200);
        try (OutputStream outputStream = null;){
            int c;
            FileObject tempFile = HopVfs.createTempFile((String)"export", (String)".zip", (String)System.getProperty("java.io.tmpdir"));
            outputStream = HopVfs.getOutputStream((FileObject)tempFile, (boolean)false);
            while ((c = in.read()) != -1) {
                outputStream.write(c);
            }
            outputStream.flush();
            outputStream.close();
            outputStream = null;
            String archiveUrl = tempFile.getName().toString();
            Object fileUrl = null;
            String serverObjectId = null;
            SimpleLoggingObject servletLoggingObject = new SimpleLoggingObject(CONTEXT_PATH, LoggingObjectType.HOP_SERVER, null);
            if (!Utils.isEmpty((CharSequence)load)) {
                String metaStoreJson = RegisterPackageServlet.getMetaStoreJsonFromZIP("zip:" + archiveUrl + "!metadata.json");
                SerializableMetadataProvider metadataProvider = new SerializableMetadataProvider(metaStoreJson);
                fileUrl = "zip:" + archiveUrl + "!" + load;
                if (isWorkflow) {
                    HopVfs.getFileObject((String)fileUrl);
                    WorkflowMeta workflowMeta = new WorkflowMeta((String)fileUrl);
                    String configUrl = "zip:" + archiveUrl + "!__workflow_execution_configuration__.xml";
                    Document configDoc = XmlHandler.loadXmlFile((String)configUrl);
                    WorkflowExecutionConfiguration workflowExecutionConfiguration = new WorkflowExecutionConfiguration(XmlHandler.getSubNode((Node)configDoc, (String)"workflow_execution_configuration"));
                    serverObjectId = UUID.randomUUID().toString();
                    servletLoggingObject.setContainerObjectId(serverObjectId);
                    servletLoggingObject.setLogLevel(workflowExecutionConfiguration.getLogLevel());
                    String runConfigurationName = workflowExecutionConfiguration.getRunConfiguration();
                    workflowMeta.setMetadataProvider(metadataProvider);
                    IWorkflowEngine<WorkflowMeta> workflow = WorkflowEngineFactory.createWorkflowEngine(this.variables, runConfigurationName, metadataProvider, workflowMeta, (ILoggingObject)servletLoggingObject);
                    this.getWorkflowMap().addWorkflow(workflow.getWorkflowName(), serverObjectId, workflow, new WorkflowConfiguration(workflowMeta, workflowExecutionConfiguration, metadataProvider));
                    this.log.setLogLevel(workflowExecutionConfiguration.getLogLevel());
                } else {
                    String configUrl = "zip:" + archiveUrl + "!__job_execution_configuration__.xml";
                    Document configDoc = XmlHandler.loadXmlFile((String)configUrl);
                    PipelineExecutionConfiguration executionConfiguration = new PipelineExecutionConfiguration(XmlHandler.getSubNode((Node)configDoc, (String)"pipeline_execution_configuration"));
                    PipelineMeta pipelineMeta = new PipelineMeta((String)fileUrl, (IHopMetadataProvider)metadataProvider, true, Variables.getADefaultVariableSpace());
                    serverObjectId = UUID.randomUUID().toString();
                    servletLoggingObject.setContainerObjectId(serverObjectId);
                    servletLoggingObject.setLogLevel(executionConfiguration.getLogLevel());
                    String runConfigurationName = executionConfiguration.getRunConfiguration();
                    IPipelineEngine<PipelineMeta> pipeline = PipelineEngineFactory.createPipelineEngine(this.variables, runConfigurationName, metadataProvider, pipelineMeta);
                    pipeline.setParent((ILoggingObject)servletLoggingObject);
                    this.getPipelineMap().addPipeline(pipeline.getPipelineMeta().getName(), serverObjectId, pipeline, new PipelineConfiguration(pipelineMeta, executionConfiguration, metadataProvider));
                }
            } else {
                fileUrl = archiveUrl;
            }
            out.println(new WebResult("OK", (String)fileUrl, serverObjectId));
        }
    }

    public String toString() {
        return "Add export";
    }

    @Override
    public String getService() {
        return "/hop/addExport (" + this.toString() + ")";
    }

    @Override
    public String getContextPath() {
        return CONTEXT_PATH;
    }
}

