/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transform;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.BlockingRowSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.IExtensionData;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopRowException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.logging.HopLogStore;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LoggingObjectType;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.EnvUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.BasePartitioner;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.engine.EngineComponent;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engine.IPipelineEngine;
import org.apache.hop.pipeline.engines.local.LocalPipelineRunConfiguration;
import org.apache.hop.pipeline.transform.DynamicWaitTimes;
import org.apache.hop.pipeline.transform.IRowDistribution;
import org.apache.hop.pipeline.transform.IRowHandler;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformFinishedListener;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.ITransformStartedListener;
import org.apache.hop.pipeline.transform.TransformErrorMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.TransformPartitioningMeta;

public class BaseTransform<Meta extends ITransformMeta, Data extends ITransformData>
implements ITransform,
IVariables,
ILoggingObject,
IExtensionData,
IEngineComponent {
    private static final Class<?> PKG = BaseTransform.class;
    protected IVariables variables = new Variables();
    private final PipelineMeta pipelineMeta;
    private final TransformMeta transformMeta;
    private String transformName;
    protected ILogChannel log;
    private String containerObjectId;
    private final IPipelineEngine<PipelineMeta> pipeline;
    private final Object statusCountersLock = new Object();
    protected Date initStartDate;
    protected Date executionStartDate;
    protected Date firstRowReadDate;
    protected Date lastRowWrittenDate;
    protected Date executionEndDate;
    private long linesRead;
    private long linesWritten;
    private long linesInput;
    private long linesOutput;
    private long linesUpdated;
    private long linesSkipped;
    private long linesRejected;
    private boolean distributed;
    private IRowDistribution rowDistribution;
    private long errors;
    private TransformMeta[] nextTransforms;
    private TransformMeta[] prevTransforms;
    private int currentInputRowSetNr;
    private int currentOutputRowSetNr;
    private List<IRowSet> inputRowSets;
    private final ReentrantReadWriteLock inputRowSetsLock = new ReentrantReadWriteLock();
    private List<IRowSet> outputRowSets;
    private DynamicWaitTimes.SingleStreamStatus waitingTime;
    private final ReadWriteLock outputRowSetsLock = new ReentrantReadWriteLock();
    private IRowSet errorRowSet;
    private AtomicBoolean running;
    private AtomicBoolean stopped;
    protected AtomicBoolean safeStopped;
    private AtomicBoolean paused;
    private boolean init;
    private int copyNr;
    private Date startTime;
    private Date stopTime;
    public boolean first;
    public boolean terminator;
    public List<Object[]> terminatorRows;
    protected final Meta meta;
    protected final Data data;
    protected List<IRowListener> rowListeners;
    private final Map<String, ResultFile> resultFiles;
    private final ReentrantReadWriteLock resultFilesLock;
    private IRowMeta inputReferenceRow;
    private boolean partitioned;
    private String partitionId;
    private int repartitioning;
    private Map<String, BlockingRowSet> partitionTargets;
    private IRowMeta inputRowMeta;
    private TransformPartitioningMeta nextTransformPartitioningMeta;
    private IRowMeta errorRowMeta = null;
    private IRowMeta previewRowMeta;
    private boolean checkPipelineRunning;
    private static final int NR_OF_ROWS_IN_BLOCK = 500;
    private int blockPointer;
    private List<ITransformFinishedListener> transformFinishedListeners;
    private List<ITransformStartedListener> transformStartedListeners;
    private int upperBufferBoundary;
    private int lowerBufferBoundary;
    private Long maxErrors = -1L;
    private int maxPercentErrors = -1;
    private long minRowsForMaxErrorPercent = -1L;
    private boolean allowEmptyFieldNamesAndTypes = false;
    protected long deadLockCounter;
    protected IHopMetadataProvider metadataProvider;
    protected Map<String, Object> extensionDataMap;
    private IRowHandler rowHandler;
    private AtomicBoolean markStopped;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseTransform(TransformMeta transformMeta, Meta meta, Data data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        this.transformMeta = transformMeta;
        this.meta = meta;
        this.data = data;
        this.copyNr = copyNr;
        this.pipelineMeta = pipelineMeta;
        this.pipeline = pipeline;
        this.transformName = transformMeta.getName();
        if (transformMeta.getName() == null) {
            throw new RuntimeException("A transform in pipeline [" + pipelineMeta.toString() + "] doesn't have a name.  A transform should always have a name to identify it by.");
        }
        if (pipeline != null) {
            this.initializeFrom(pipeline);
        }
        this.log = HopLogStore.getLogChannelFactory().create((Object)this, (ILoggingObject)pipeline);
        this.first = true;
        this.running = new AtomicBoolean(false);
        this.stopped = new AtomicBoolean(false);
        this.safeStopped = new AtomicBoolean(false);
        this.paused = new AtomicBoolean(false);
        this.init = false;
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRead = 0L;
            this.linesWritten = 0L;
            this.linesUpdated = 0L;
            this.linesSkipped = 0L;
            this.linesRejected = 0L;
            this.linesInput = 0L;
            this.linesOutput = 0L;
        }
        this.inputRowSets = null;
        this.outputRowSets = null;
        this.nextTransforms = null;
        this.terminator = transformMeta.hasTerminator();
        this.terminatorRows = this.terminator ? new ArrayList<Object[]>() : null;
        this.startTime = null;
        this.stopTime = null;
        this.distributed = transformMeta.isDistributes();
        this.rowDistribution = transformMeta.getRowDistribution();
        this.rowListeners = new CopyOnWriteArrayList<IRowListener>();
        this.resultFiles = new HashMap<String, ResultFile>();
        this.resultFilesLock = new ReentrantReadWriteLock();
        this.repartitioning = 0;
        this.partitionTargets = new Hashtable<String, BlockingRowSet>();
        this.extensionDataMap = new HashMap<String, Object>();
        this.checkPipelineRunning = false;
        this.blockPointer = 0;
        this.transformFinishedListeners = Collections.synchronizedList(new ArrayList());
        this.transformStartedListeners = Collections.synchronizedList(new ArrayList());
        this.markStopped = new AtomicBoolean(false);
        this.dispatch();
        this.upperBufferBoundary = (int)((double)pipeline.getRowSetSize() * 0.99);
        this.lowerBufferBoundary = (int)((double)pipeline.getRowSetSize() * 0.01);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean init() {
        this.initStartDate = new Date();
        this.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_INIT);
        if (this.transformMeta.isPartitioned()) {
            int partitionNr = this.copyNr;
            String partitionNrString = new DecimalFormat("000").format(partitionNr);
            this.setVariable("Internal.Transform.Partition.Number", partitionNrString);
            List<String> partitionIdList = this.transformMeta.getTransformPartitioningMeta().getPartitionSchema().calculatePartitionIds(this);
            if (partitionIdList.size() <= 0) {
                this.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.UnableToRetrievePartitionId", (String[])new String[]{this.transformMeta.getTransformPartitioningMeta().getPartitionSchema().getName()}));
                return false;
            }
            String partitionId = partitionIdList.get(partitionNr);
            this.setVariable("Internal.Transform.Partition.ID", partitionId);
        } else if (!Utils.isEmpty((CharSequence)this.partitionId)) {
            this.setVariable("Internal.Transform.Partition.ID", this.partitionId);
        }
        this.setVariable("Internal.Transform.CopyNr", Integer.toString(this.copyNr));
        this.allowEmptyFieldNamesAndTypes = ValueMetaBase.convertStringToBoolean((String)System.getProperties().getProperty("HOP_ALLOW_EMPTY_FIELD_NAMES_AND_TYPES", "N"));
        TransformErrorMeta transformErrorMeta = this.transformMeta.getTransformErrorMeta();
        if (transformErrorMeta == null) return true;
        boolean envSubFailed = false;
        try {
            this.maxErrors = !Utils.isEmpty((CharSequence)transformErrorMeta.getMaxErrors()) ? Long.valueOf(this.pipeline.resolve(transformErrorMeta.getMaxErrors())) : -1L;
        }
        catch (NumberFormatException nfe) {
            this.log.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.NumberFormatException", (String[])new String[]{BaseMessages.getString(PKG, (String)"BaseTransform.Property.MaxErrors.Name", (String[])new String[0]), this.transformName, transformErrorMeta.getMaxErrors() != null ? transformErrorMeta.getMaxErrors() : ""}));
            envSubFailed = true;
        }
        try {
            this.minRowsForMaxErrorPercent = !Utils.isEmpty((CharSequence)transformErrorMeta.getMinPercentRows()) ? Long.parseLong(this.pipeline.resolve(transformErrorMeta.getMinPercentRows())) : -1L;
        }
        catch (NumberFormatException nfe) {
            this.log.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.NumberFormatException", (String[])new String[]{BaseMessages.getString(PKG, (String)"BaseTransform.Property.MinRowsForErrorsPercentCalc.Name", (String[])new String[0]), this.transformName, transformErrorMeta.getMinPercentRows() != null ? transformErrorMeta.getMinPercentRows() : ""}));
            envSubFailed = true;
        }
        try {
            this.maxPercentErrors = !Utils.isEmpty((CharSequence)transformErrorMeta.getMaxPercentErrors()) ? Integer.valueOf(this.pipeline.resolve(transformErrorMeta.getMaxPercentErrors())) : -1;
        }
        catch (NumberFormatException nfe) {
            this.log.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.NumberFormatException", (String[])new String[]{BaseMessages.getString(PKG, (String)"BaseTransform.Property.MaxPercentErrors.Name", (String[])new String[0]), this.transformName, transformErrorMeta.getMaxPercentErrors() != null ? transformErrorMeta.getMaxPercentErrors() : ""}));
            return false;
        }
        if (!envSubFailed) return true;
        return false;
    }

    @Override
    public void dispose() {
        this.data.setStatus(EngineComponent.ComponentExecutionStatus.STATUS_DISPOSED);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public long getProcessed() {
        if (this.getLinesRead() > this.getLinesWritten()) {
            return this.getLinesRead();
        }
        return this.getLinesWritten();
    }

    public void setCopy(int cop) {
        this.copyNr = cop;
    }

    @Override
    public int getCopy() {
        return this.copyNr;
    }

    @Override
    public long getErrors() {
        return this.errors;
    }

    @Override
    public void setErrors(long e) {
        this.errors = e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementLinesRead() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return --this.linesRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesRead(long newLinesReadValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRead = newLinesReadValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesInput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesInput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesInput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesInput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesInput(long newLinesInputValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesInput = newLinesInputValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesOutput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesOutput() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesOutput;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesOutput(long newLinesOutputValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesOutput = newLinesOutputValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long decrementLinesWritten() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return --this.linesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesWritten(long newLinesWrittenValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesWritten = newLinesWrittenValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesUpdated() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesUpdated() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesUpdated;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesUpdated(long newLinesUpdatedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesUpdated = newLinesUpdatedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLinesRejected() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesRejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesRejected() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesRejected;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLinesRejected(long newLinesRejectedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesRejected = newLinesRejectedValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLinesSkipped() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return this.linesSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementLinesSkipped() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            return ++this.linesSkipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinesSkipped(long newLinesSkippedValue) {
        Object object = this.statusCountersLock;
        synchronized (object) {
            this.linesSkipped = newLinesSkippedValue;
        }
    }

    @Override
    public boolean isSelected() {
        return this.transformMeta != null && this.transformMeta.isSelected();
    }

    @Override
    public String getTransformName() {
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public IPipelineEngine<PipelineMeta> getDispatcher() {
        return this.pipeline;
    }

    @Override
    public String getStatusDescription() {
        return this.getStatus().getDescription();
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Data getData() {
        return this.data;
    }

    @Override
    public TransformMeta getTransformMeta() {
        return this.transformMeta;
    }

    public PipelineMeta getPipelineMeta() {
        return this.pipelineMeta;
    }

    @Override
    public IPipelineEngine<PipelineMeta> getPipeline() {
        return this.pipeline;
    }

    @Override
    public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        if (rowMeta != null && !this.allowEmptyFieldNamesAndTypes) {
            for (IValueMeta vmi : rowMeta.getValueMetaList()) {
                if (StringUtils.isBlank((String)vmi.getName())) {
                    throw new HopTransformException("Please set a field name for all field(s) that have 'null'.");
                }
                if (vmi.getType() > 0) continue;
                throw new HopTransformException("Please set a value for the missing field(s) type for field: '" + vmi.getName() + "'");
            }
        }
        this.getRowHandler().putRow(rowMeta, row);
        if (this.firstRowReadDate == null) {
            this.firstRowReadDate = new Date();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handlePutRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.stopped.get() && !this.safeStopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseTransform.Log.StopPuttingARow", (String[])new String[0]));
            }
            this.stopAll();
            return;
        }
        if (!this.checkPipelineRunning) {
            int counter = 0;
            while (!this.pipeline.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1000L);
                    ++counter;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (counter < 3) continue;
            }
            this.checkPipelineRunning = true;
        }
        for (IRowListener listener : this.rowListeners) {
            listener.rowWrittenEvent(rowMeta, row);
        }
        if (this.terminator && this.terminatorRows != null) {
            try {
                this.terminatorRows.add(rowMeta.cloneRow(row));
            }
            catch (HopValueException e) {
                throw new HopTransformException("Unable to clone row while adding rows to the terminator rows.", (Throwable)e);
            }
        }
        this.outputRowSetsLock.readLock().lock();
        try {
            if (this.outputRowSets.isEmpty()) {
                this.incrementLinesWritten();
                return;
            }
            switch (this.repartitioning) {
                case 0: {
                    this.noPartitioning(rowMeta, row);
                    return;
                }
                case 2: {
                    this.specialPartitioning(rowMeta, row);
                    return;
                }
                case 1: {
                    this.mirrorPartitioning(rowMeta, row);
                    return;
                }
                default: {
                    throw new HopTransformException("Internal error: invalid repartitioning type: " + this.repartitioning);
                }
            }
        }
        finally {
            this.outputRowSetsLock.readLock().unlock();
        }
    }

    private void mirrorPartitioning(IRowMeta rowMeta, Object[] row) {
        for (IRowSet rowSet : this.outputRowSets) {
            this.putRowToRowSet(rowSet, rowMeta, row);
        }
    }

    private void specialPartitioning(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        int partitionNr;
        List<TransformMeta> nextTransforms;
        if (this.nextTransformPartitioningMeta == null && (nextTransforms = this.pipelineMeta.findNextTransforms(this.transformMeta)).size() > 0) {
            this.nextTransformPartitioningMeta = nextTransforms.get(0).getTransformPartitioningMeta();
        }
        try {
            partitionNr = this.nextTransformPartitioningMeta.getPartition(this, rowMeta, row);
        }
        catch (HopException e) {
            throw new HopTransformException("Unable to convert a value to integer while calculating the partition number", (Throwable)e);
        }
        int partCount = ((BasePartitioner)this.nextTransformPartitioningMeta.getPartitioner()).getNrPartitions();
        for (int i = 0; i < this.nextTransforms.length; ++i) {
            IRowSet selectedRowSet = this.outputRowSets.get(partitionNr + i * partCount);
            if (selectedRowSet == null) {
                this.logBasic(BaseMessages.getString(PKG, (String)"BaseTransform.TargetRowsetIsNotAvailable", (Object[])new Object[]{partitionNr}));
                continue;
            }
            this.putRowToRowSet(selectedRowSet, rowMeta, row);
            this.incrementLinesWritten();
            if (!this.log.isRowLevel()) continue;
            try {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"BaseTransform.PartitionedToRow", (Object[])new Object[]{partitionNr, selectedRowSet, rowMeta.getString(row)}));
                continue;
            }
            catch (HopValueException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    private void noPartitioning(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        if (this.distributed) {
            if (this.rowDistribution != null) {
                this.rowDistribution.distributeRow(rowMeta, row, this);
                this.incrementLinesWritten();
            } else {
                IRowSet rs = this.outputRowSets.get(this.currentOutputRowSetNr);
                if (!rs.isDone() && rs.size() >= this.upperBufferBoundary && !this.isStopped()) {
                    try {
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.putRowToRowSet(rs, rowMeta, row);
                this.incrementLinesWritten();
                if (this.outputRowSets.size() > 1) {
                    ++this.currentOutputRowSetNr;
                    if (this.currentOutputRowSetNr >= this.outputRowSets.size()) {
                        this.currentOutputRowSetNr = 0;
                    }
                }
            }
        } else {
            for (int i = 1; i < this.outputRowSets.size(); ++i) {
                IRowSet rs = this.outputRowSets.get(i);
                if (!rs.isDone() && rs.size() >= this.upperBufferBoundary && !this.isStopped()) {
                    try {
                        Thread.sleep(0L, 1);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                try {
                    this.putRowToRowSet(rs, rowMeta, rowMeta.cloneRow(row));
                    this.incrementLinesWritten();
                    continue;
                }
                catch (HopValueException e) {
                    throw new HopTransformException("Unable to clone row while copying rows to multiple target transforms", (Throwable)e);
                }
            }
            IRowSet rs = this.outputRowSets.get(0);
            this.putRowToRowSet(rs, rowMeta, row);
            this.incrementLinesWritten();
        }
    }

    private void putRowToRowSet(IRowSet rs, IRowMeta rowMeta, Object[] row) {
        IRowMeta metaFromRs = rs.getRowMeta();
        IRowMeta toBeSent = metaFromRs == null ? rowMeta.clone() : metaFromRs;
        while (!rs.putRow(toBeSent, row)) {
            if (!this.isStopped() || this.safeStopped.get()) continue;
            return;
        }
    }

    public void putRowTo(IRowMeta rowMeta, Object[] row, IRowSet rowSet) throws HopTransformException {
        this.getRowHandler().putRowTo(rowMeta, row, rowSet);
        if (this.firstRowReadDate == null) {
            this.firstRowReadDate = new Date();
        }
    }

    public void handlePutRowTo(IRowMeta rowMeta, Object[] row, IRowSet rowSet) throws HopTransformException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        for (IRowListener listener : this.rowListeners) {
            listener.rowWrittenEvent(rowMeta, row);
        }
        if (this.terminator && this.terminatorRows != null) {
            try {
                this.terminatorRows.add(rowMeta.cloneRow(row));
            }
            catch (HopValueException e) {
                throw new HopTransformException("Unable to clone row while adding rows to the terminator buffer", (Throwable)e);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseTransform.Log.StopPuttingARow", (String[])new String[0]));
            }
            this.stopAll();
            return;
        }
        while (!rowSet.putRow(rowMeta, row) && !this.isStopped()) {
        }
        this.incrementLinesWritten();
    }

    public void putError(IRowMeta rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws HopTransformException {
        this.getRowHandler().putError(rowMeta, row, nrErrors, errorDescriptions, fieldNames, errorCodes);
    }

    private void handlePutError(IVariables variables, IRowMeta rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws HopTransformException {
        if (this.pipeline.isSafeModeEnabled() && (row == null || rowMeta.size() > row.length)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"BaseTransform.Exception.MetadataDoesntMatchDataRowSize", (String[])new String[]{Integer.toString(rowMeta.size()), Integer.toString(row != null ? row.length : 0)}));
        }
        TransformErrorMeta transformErrorMeta = this.transformMeta.getTransformErrorMeta();
        if (this.errorRowMeta == null) {
            this.errorRowMeta = rowMeta.clone();
            IRowMeta add = transformErrorMeta.getErrorRowMeta(variables);
            this.errorRowMeta.addRowMeta(add);
        }
        Object[] errorRowData = RowDataUtil.allocateRowData((int)this.errorRowMeta.size());
        if (row != null) {
            System.arraycopy(row, 0, errorRowData, 0, rowMeta.size());
        }
        transformErrorMeta.addErrorRowData(this, errorRowData, rowMeta.size(), nrErrors, errorDescriptions, fieldNames, errorCodes);
        for (IRowListener listener : this.rowListeners) {
            listener.errorRowWrittenEvent(rowMeta, row);
        }
        if (this.errorRowSet != null) {
            while (!this.errorRowSet.putRow(this.errorRowMeta, errorRowData) && !this.isStopped()) {
            }
            this.incrementLinesRejected();
        }
        this.verifyRejectionRates();
    }

    private void verifyRejectionRates() {
        int pct;
        TransformErrorMeta transformErrorMeta = this.transformMeta.getTransformErrorMeta();
        if (transformErrorMeta == null) {
            return;
        }
        if (this.maxErrors > 0L && this.getLinesRejected() > this.maxErrors) {
            this.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.TooManyRejectedRows", (String[])new String[]{Long.toString(this.maxErrors), Long.toString(this.getLinesRejected())}));
            this.setErrors(1L);
            this.stopAll();
        }
        if (this.maxPercentErrors > 0 && this.getLinesRejected() > 0L && (this.minRowsForMaxErrorPercent <= 0L || this.getLinesRead() >= this.minRowsForMaxErrorPercent) && (pct = (int)Math.ceil(100.0 * (double)this.getLinesRejected() / (double)this.getLinesRead())) > this.maxPercentErrors) {
            this.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.MaxPercentageRejectedReached", (String[])new String[]{Integer.toString(pct), Long.toString(this.getLinesRejected()), Long.toString(this.getLinesRead())}));
            this.setErrors(1L);
            this.stopAll();
        }
    }

    @VisibleForTesting
    IRowSet currentInputStream() {
        this.inputRowSetsLock.readLock().lock();
        try {
            IRowSet iRowSet = this.inputRowSets.get(this.currentInputRowSetNr);
            return iRowSet;
        }
        finally {
            this.inputRowSetsLock.readLock().unlock();
        }
    }

    private void nextInputStream() {
        this.blockPointer = 0;
        int streams = this.inputRowSets.size();
        if (streams == 0) {
            return;
        }
        if (streams == 1) {
            this.currentInputRowSetNr = 0;
        }
        ++this.currentInputRowSetNr;
        if (this.currentInputRowSetNr >= streams) {
            this.currentInputRowSetNr = 0;
        }
    }

    protected void waitUntilPipelineIsStarted() {
        if (!this.checkPipelineRunning) {
            while (!this.pipeline.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.checkPipelineRunning = true;
        }
    }

    @Override
    public Object[] getRow() throws HopException {
        Object[] row = this.getRowHandler().getRow();
        if (this.firstRowReadDate == null) {
            this.firstRowReadDate = new Date();
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] handleGetRow() throws HopException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseTransform.Log.StopLookingForMoreRows", (String[])new String[0]));
            }
            this.stopAll();
            return null;
        }
        this.waitUntilPipelineIsStarted();
        IRowSet inputRowSet = null;
        Object[] row = null;
        this.inputRowSetsLock.readLock().lock();
        try {
            LocalPipelineRunConfiguration runconfig;
            if (this.inputRowSets.isEmpty()) {
                Object[] objectArray = null;
                return objectArray;
            }
            if (this.blockPointer >= 500) {
                for (int r = 0; r < this.inputRowSets.size() && row == null; ++r) {
                    this.nextInputStream();
                    inputRowSet = this.currentInputStream();
                    row = inputRowSet.getRowImmediate();
                }
                if (row != null) {
                    this.incrementLinesRead();
                }
            } else {
                inputRowSet = this.currentInputStream();
            }
            if (!inputRowSet.isDone() && inputRowSet.size() <= this.lowerBufferBoundary && !this.isStopped()) {
                try {
                    Thread.sleep(0L, 1);
                }
                catch (InterruptedException r) {
                    // empty catch block
                }
            }
            if (this.waitingTime == null) {
                Integer waitTime = Const.toInt((String)EnvUtil.getSystemProperty((String)"HOP_DEFAULT_BUFFER_POLLING_WAITTIME"), (int)20);
                if (this.pipeline.getPipelineRunConfiguration().getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration) {
                    runconfig = (LocalPipelineRunConfiguration)this.pipeline.getPipelineRunConfiguration().getEngineRunConfiguration();
                    waitTime = Const.toInt((String)runconfig.getWaitTime(), (int)waitTime);
                }
                this.waitingTime = DynamicWaitTimes.build(this.inputRowSets, this::getCurrentInputRowSetNr, waitTime);
            }
            while (row == null && !this.isStopped()) {
                boolean timeout;
                block36: {
                    row = inputRowSet.getRowWait(this.waitingTime.get(), TimeUnit.MILLISECONDS);
                    timeout = false;
                    if (row != null) {
                        this.incrementLinesRead();
                        ++this.blockPointer;
                        this.waitingTime.reset();
                        continue;
                    }
                    if (inputRowSet.isDone()) {
                        row = inputRowSet.getRowWait(1L, TimeUnit.MILLISECONDS);
                        if (row == null) {
                            this.inputRowSetsLock.readLock().unlock();
                            this.inputRowSetsLock.writeLock().lock();
                            try {
                                this.removeRowSetFromInputRowSets(inputRowSet);
                                if (this.inputRowSets.isEmpty()) {
                                    runconfig = null;
                                    return runconfig;
                                }
                                break block36;
                            }
                            finally {
                                this.inputRowSetsLock.readLock().lock();
                                this.inputRowSetsLock.writeLock().unlock();
                            }
                        }
                        this.incrementLinesRead();
                    } else {
                        timeout = true;
                    }
                }
                this.nextInputStream();
                inputRowSet = this.currentInputStream();
                this.waitingTime.adjust(timeout, inputRowSet);
            }
            while (row == null && !this.stopped.get()) {
                if (this.inputRowSets.isEmpty()) {
                    Object[] objectArray = null;
                    return objectArray;
                }
                this.nextInputStream();
                inputRowSet = this.currentInputStream();
                row = this.getRowFrom(inputRowSet);
            }
        }
        finally {
            this.inputRowSetsLock.readLock().unlock();
        }
        if (this.inputRowMeta == null || this.prevTransforms.length > 1) {
            this.inputRowMeta = inputRowSet.getRowMeta();
        }
        if (row != null) {
            if (this.pipeline.isSafeModeEnabled()) {
                this.pipelineMeta.checkRowMixingStatically(this, this.transformMeta, null);
            }
            for (IRowListener listener : this.rowListeners) {
                listener.rowReadEvent(this.inputRowMeta, row);
            }
        }
        this.verifyRejectionRates();
        return row;
    }

    public void setRowHandler(IRowHandler rowHandler) {
        Preconditions.checkNotNull((Object)rowHandler);
        this.rowHandler = rowHandler;
    }

    public IRowHandler getRowHandler() {
        if (this.rowHandler == null) {
            this.rowHandler = new DefaultRowHandler();
        }
        return this.rowHandler;
    }

    protected void safeModeChecking(IRowMeta row) throws HopRowException {
        if (row == null) {
            return;
        }
        if (this.inputReferenceRow == null) {
            this.inputReferenceRow = row.clone();
            Object[] fieldnames = row.getFieldNames();
            Arrays.sort(fieldnames);
            for (int i = 0; i < fieldnames.length - 1; ++i) {
                if (!((String)fieldnames[i]).equals(fieldnames[i + 1])) continue;
                throw new HopRowException(BaseMessages.getString(PKG, (String)"BaseTransform.SafeMode.Exception.DoubleFieldnames", (String[])new String[]{fieldnames[i]}));
            }
        } else {
            BaseTransform.safeModeChecking(this.inputReferenceRow, row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void identifyErrorOutput() {
        if (this.transformMeta.isDoingErrorHandling()) {
            TransformErrorMeta transformErrorMeta = this.transformMeta.getTransformErrorMeta();
            this.outputRowSetsLock.writeLock().lock();
            try {
                for (int rowsetNr = 0; rowsetNr < this.outputRowSets.size(); ++rowsetNr) {
                    IRowSet outputRowSet = this.outputRowSets.get(rowsetNr);
                    if (!outputRowSet.getDestinationTransformName().equalsIgnoreCase(transformErrorMeta.getTargetTransform().getName())) continue;
                    this.errorRowSet = outputRowSet;
                    this.outputRowSets.remove(rowsetNr);
                    return;
                }
            }
            finally {
                this.outputRowSetsLock.writeLock().unlock();
            }
        }
    }

    public static void safeModeChecking(IRowMeta referenceRowMeta, IRowMeta rowMeta) throws HopRowException {
        if (referenceRowMeta.size() != rowMeta.size()) {
            throw new HopRowException(BaseMessages.getString(PKG, (String)"BaseTransform.SafeMode.Exception.VaryingSize", (String[])new String[]{"" + referenceRowMeta.size(), "" + rowMeta.size(), rowMeta.toString()}));
        }
        for (int i = 0; i < referenceRowMeta.size(); ++i) {
            IValueMeta referenceValue = referenceRowMeta.getValueMeta(i);
            IValueMeta compareValue = rowMeta.getValueMeta(i);
            if (!referenceValue.getName().equalsIgnoreCase(compareValue.getName())) {
                throw new HopRowException(BaseMessages.getString(PKG, (String)"BaseTransform.SafeMode.Exception.MixingLayout", (String[])new String[]{"" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()}));
            }
            if (referenceValue.getType() != compareValue.getType()) {
                throw new HopRowException(BaseMessages.getString(PKG, (String)"BaseTransform.SafeMode.Exception.MixingTypes", (String[])new String[]{"" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()}));
            }
            if (referenceValue.getStorageType() == compareValue.getStorageType()) continue;
            throw new HopRowException(BaseMessages.getString(PKG, (String)"BaseTransform.SafeMode.Exception.MixingStorageTypes", (String[])new String[]{"" + (i + 1), referenceValue.getName() + " " + referenceValue.toStringMeta(), compareValue.getName() + " " + compareValue.toStringMeta()}));
        }
    }

    public Object[] getRowFrom(IRowSet rowSet) throws HopTransformException {
        Object[] row = this.getRowHandler().getRowFrom(rowSet);
        if (this.firstRowReadDate == null) {
            this.firstRowReadDate = new Date();
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] handleGetRowFrom(IRowSet rowSet) throws HopTransformException {
        while (this.paused.get() && !this.stopped.get()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        if (!this.checkPipelineRunning) {
            while (!this.pipeline.isRunning() && !this.stopped.get()) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {}
            }
            this.checkPipelineRunning = true;
        }
        Object[] rowData = null;
        if (!rowSet.isDone() && rowSet.size() <= this.lowerBufferBoundary && !this.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        rowData = rowSet.getRow();
        while (rowData == null && !rowSet.isDone() && !this.stopped.get()) {
            rowData = rowSet.getRow();
        }
        if (rowData == null && rowSet.isDone()) {
            rowData = rowSet.getRow();
        }
        if (this.stopped.get()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseTransform.Log.StopLookingForMoreRows", (String[])new String[0]));
            }
            this.stopAll();
            return null;
        }
        if (rowData == null && rowSet.isDone() && (rowData = rowSet.getRow()) == null) {
            int i;
            Integer waitTime = 20;
            if (this.pipeline.getPipelineRunConfiguration().getEngineRunConfiguration() instanceof LocalPipelineRunConfiguration) {
                LocalPipelineRunConfiguration runconfig = (LocalPipelineRunConfiguration)this.pipeline.getPipelineRunConfiguration().getEngineRunConfiguration();
                waitTime = Integer.parseInt(runconfig.getWaitTime());
            }
            if (waitTime == null) {
                waitTime = 20;
            }
            if (this.waitingTime == null) {
                this.waitingTime = DynamicWaitTimes.build(this.inputRowSets, this::getCurrentInputRowSetNr, waitTime);
            }
            int holdCount = this.inputRowSetsLock.getReadHoldCount();
            for (i = 0; i < holdCount; ++i) {
                this.inputRowSetsLock.readLock().unlock();
            }
            this.inputRowSetsLock.writeLock().lock();
            try {
                this.removeRowSetFromInputRowSets(rowSet);
                for (i = 0; i < holdCount; ++i) {
                    this.inputRowSetsLock.readLock().lock();
                }
                Object[] objectArray = null;
                return objectArray;
            }
            finally {
                this.inputRowSetsLock.writeLock().unlock();
            }
        }
        this.incrementLinesRead();
        for (IRowListener listener : this.rowListeners) {
            listener.rowReadEvent(rowSet.getRowMeta(), rowData);
        }
        return rowData;
    }

    public IRowSet findInputRowSet(String sourceTransformName) throws HopTransformException {
        TransformMeta sourceTransformMeta = this.pipelineMeta.findTransform(sourceTransformName);
        if (sourceTransformMeta == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"BaseTransform.Exception.SourceTransformToReadFromDoesntExist", (String[])new String[]{sourceTransformName}));
        }
        if (this.transformMeta.isPartitioned() && !sourceTransformMeta.isPartitioned()) {
            throw new HopTransformException("When reading from info transforms and running partitioned the source transform needs to be partitioned in the same way");
        }
        if (!this.transformMeta.isPartitioned() && sourceTransformMeta.isPartitioned()) {
            throw new HopTransformException("The info transform to read data from called [" + sourceTransformMeta.getName() + "] is partitioned when transform [" + this.getTransformName() + "] isn't.  Make sure both are partitioned or neither.");
        }
        if (sourceTransformMeta.isPartitioned() && !sourceTransformMeta.isRepartitioning() && this.transformMeta.isPartitioned()) {
            if (!sourceTransformMeta.getTransformPartitioningMeta().equals(this.transformMeta.getTransformPartitioningMeta())) {
                throw new HopTransformException("When reading from info transforms and running partitioned the source transform needs to be partitioned in the same way");
            }
            return this.findInputRowSet(sourceTransformName, this.getCopy(), this.getTransformName(), this.getCopy());
        }
        if (sourceTransformMeta.getCopies(this) > 1) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"BaseTransform.Exception.SourceTransformToReadFromCantRunInMultipleCopies", (String[])new String[]{sourceTransformName, Integer.toString(sourceTransformMeta.getCopies(this))}));
        }
        return this.findInputRowSet(sourceTransformName, 0, this.getTransformName(), this.getCopy());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowSet findInputRowSet(String from, int fromCopy, String to, int toCopy) {
        this.inputRowSetsLock.readLock().lock();
        try {
            for (IRowSet rs : this.inputRowSets) {
                if (!rs.getOriginTransformName().equalsIgnoreCase(from) || !rs.getDestinationTransformName().equalsIgnoreCase(to) || rs.getOriginTransformCopy() != fromCopy || rs.getDestinationTransformCopy() != toCopy) continue;
                IRowSet iRowSet = rs;
                return iRowSet;
            }
        }
        finally {
            this.inputRowSetsLock.readLock().unlock();
        }
        return null;
    }

    public IRowSet findOutputRowSet(String targetTransform) throws HopTransformException {
        TransformMeta targetTransformMeta = this.pipelineMeta.findTransform(targetTransform);
        if (targetTransformMeta == null) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"BaseTransform.Exception.TargetTransformToWriteToDoesntExist", (String[])new String[]{targetTransform}));
        }
        if (targetTransformMeta.getCopies(this) > 1) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"BaseTransform.Exception.TargetTransformToWriteToCantRunInMultipleCopies", (String[])new String[]{targetTransform, Integer.toString(targetTransformMeta.getCopies(this))}));
        }
        return this.findOutputRowSet(this.getTransformName(), this.getCopy(), targetTransform, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRowSet findOutputRowSet(String from, int fromcopy, String to, int tocopy) {
        this.outputRowSetsLock.readLock().lock();
        try {
            for (IRowSet rs : this.outputRowSets) {
                if (!rs.getOriginTransformName().equalsIgnoreCase(from) || !rs.getDestinationTransformName().equalsIgnoreCase(to) || rs.getOriginTransformCopy() != fromcopy || rs.getDestinationTransformCopy() != tocopy) continue;
                IRowSet iRowSet = rs;
                return iRowSet;
            }
        }
        finally {
            this.outputRowSetsLock.readLock().unlock();
        }
        return null;
    }

    @Override
    public void setOutputDone() {
        this.outputRowSetsLock.readLock().lock();
        try {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"BaseTransform.Log.OutputDone", (String[])new String[]{String.valueOf(this.outputRowSets.size())}));
            }
            for (IRowSet rs : this.outputRowSets) {
                rs.setDone();
            }
            if (this.errorRowSet != null) {
                this.errorRowSet.setDone();
            }
        }
        finally {
            this.lastRowWrittenDate = new Date();
            this.outputRowSetsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch() {
        if (this.pipelineMeta == null) {
            return;
        }
        TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.StartingBuffersAllocation", (String[])new String[0]));
        }
        List<TransformMeta> previousTransforms = this.pipelineMeta.findPreviousTransforms(transformMeta, true);
        List<TransformMeta> succeedingTransforms = this.pipelineMeta.findNextTransforms(transformMeta);
        int nrInput = previousTransforms.size();
        int nrOutput = succeedingTransforms.size();
        this.inputRowSetsLock.writeLock().lock();
        this.outputRowSetsLock.writeLock().lock();
        try {
            IRowSet rowSet;
            int c;
            int nrCopies;
            int dispatchType;
            boolean repartitioning;
            int nextCopies;
            int prevCopies;
            int i;
            this.inputRowSets = new ArrayList<IRowSet>();
            this.outputRowSets = new ArrayList<IRowSet>();
            this.errorRowSet = null;
            this.prevTransforms = new TransformMeta[nrInput];
            this.nextTransforms = new TransformMeta[nrOutput];
            this.currentInputRowSetNr = 0;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.TransformMeta", (String[])new String[]{String.valueOf(nrInput), String.valueOf(nrOutput)}));
            }
            for (i = 0; i < previousTransforms.size(); ++i) {
                this.prevTransforms[i] = previousTransforms.get(i);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.GotPreviousTransform", (String[])new String[]{this.transformName, String.valueOf(i), this.prevTransforms[i].getName()}));
                }
                prevCopies = this.prevTransforms[i].getCopies(this);
                nextCopies = transformMeta.getCopies(this);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.InputRowInfo", (String[])new String[]{String.valueOf(prevCopies), String.valueOf(nextCopies)}));
                }
                repartitioning = this.prevTransforms[i].isPartitioned() ? !this.prevTransforms[i].getTransformPartitioningMeta().equals(transformMeta.getTransformPartitioningMeta()) : transformMeta.isPartitioned();
                if (prevCopies == 1 && nextCopies == 1) {
                    dispatchType = 1;
                    nrCopies = 1;
                } else if (prevCopies == 1 && nextCopies > 1) {
                    dispatchType = 2;
                    nrCopies = 1;
                } else if (prevCopies > 1 && nextCopies == 1) {
                    dispatchType = 3;
                    nrCopies = prevCopies;
                } else if (prevCopies == nextCopies && !repartitioning) {
                    dispatchType = 4;
                    nrCopies = 1;
                } else {
                    dispatchType = 5;
                    nrCopies = prevCopies;
                }
                for (c = 0; c < nrCopies; ++c) {
                    rowSet = null;
                    switch (dispatchType) {
                        case 1: {
                            rowSet = this.pipeline.findRowSet(this.prevTransforms[i].getName(), 0, this.transformName, 0);
                            break;
                        }
                        case 2: {
                            rowSet = this.pipeline.findRowSet(this.prevTransforms[i].getName(), 0, this.transformName, this.getCopy());
                            break;
                        }
                        case 3: {
                            rowSet = this.pipeline.findRowSet(this.prevTransforms[i].getName(), c, this.transformName, 0);
                            break;
                        }
                        case 4: {
                            rowSet = this.pipeline.findRowSet(this.prevTransforms[i].getName(), this.getCopy(), this.transformName, this.getCopy());
                            break;
                        }
                        case 5: {
                            rowSet = this.pipeline.findRowSet(this.prevTransforms[i].getName(), c, this.transformName, this.getCopy());
                            break;
                        }
                    }
                    if (rowSet != null) {
                        this.inputRowSets.add(rowSet);
                        if (!this.log.isDetailed()) continue;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.FoundInputRowset", (String[])new String[]{rowSet.getName()}));
                        continue;
                    }
                    if (this.prevTransforms[i].isMapping() || transformMeta.isMapping()) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.UnableToFindInputRowset", (String[])new String[0]));
                    this.setErrors(1L);
                    this.stopAll();
                    return;
                }
            }
            for (i = 0; i < nrOutput; ++i) {
                this.nextTransforms[i] = succeedingTransforms.get(i);
                prevCopies = transformMeta.getCopies(this);
                nextCopies = this.nextTransforms[i].getCopies(this);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.OutputRowInfo", (String[])new String[]{String.valueOf(prevCopies), String.valueOf(nextCopies)}));
                }
                repartitioning = transformMeta.isPartitioned() ? !transformMeta.getTransformPartitioningMeta().equals(this.nextTransforms[i].getTransformPartitioningMeta()) : this.nextTransforms[i].isPartitioned();
                if (prevCopies == 1 && nextCopies == 1) {
                    dispatchType = 1;
                    nrCopies = 1;
                } else if (prevCopies == 1 && nextCopies > 1) {
                    dispatchType = 2;
                    nrCopies = nextCopies;
                } else if (prevCopies > 1 && nextCopies == 1) {
                    dispatchType = 3;
                    nrCopies = 1;
                } else if (prevCopies == nextCopies && !repartitioning) {
                    dispatchType = 4;
                    nrCopies = 1;
                } else {
                    dispatchType = 5;
                    nrCopies = nextCopies;
                }
                for (c = 0; c < nrCopies; ++c) {
                    rowSet = null;
                    switch (dispatchType) {
                        case 1: {
                            rowSet = this.pipeline.findRowSet(this.transformName, 0, this.nextTransforms[i].getName(), 0);
                            break;
                        }
                        case 2: {
                            rowSet = this.pipeline.findRowSet(this.transformName, 0, this.nextTransforms[i].getName(), c);
                            break;
                        }
                        case 3: {
                            rowSet = this.pipeline.findRowSet(this.transformName, this.getCopy(), this.nextTransforms[i].getName(), 0);
                            break;
                        }
                        case 4: {
                            rowSet = this.pipeline.findRowSet(this.transformName, this.getCopy(), this.nextTransforms[i].getName(), this.getCopy());
                            break;
                        }
                        case 5: {
                            rowSet = this.pipeline.findRowSet(this.transformName, this.getCopy(), this.nextTransforms[i].getName(), c);
                            break;
                        }
                    }
                    if (rowSet != null) {
                        this.outputRowSets.add(rowSet);
                        if (!this.log.isDetailed()) continue;
                        this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.FoundOutputRowset", (String[])new String[]{rowSet.getName()}));
                        continue;
                    }
                    if (transformMeta.isMapping() || this.nextTransforms[i].isMapping()) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"BaseTransform.Log.UnableToFindOutputRowset", (String[])new String[0]));
                    this.setErrors(1L);
                    this.stopAll();
                    return;
                }
            }
        }
        finally {
            this.inputRowSetsLock.writeLock().unlock();
            this.outputRowSetsLock.writeLock().unlock();
        }
        if (transformMeta.getTargetTransformPartitioningMeta() != null) {
            this.nextTransformPartitioningMeta = transformMeta.getTargetTransformPartitioningMeta();
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.FinishedDispatching", (String[])new String[0]));
        }
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean outputIsDone() {
        int nrstopped = 0;
        this.outputRowSetsLock.readLock().lock();
        try {
            for (IRowSet rs : this.outputRowSets) {
                if (!rs.isDone()) continue;
                ++nrstopped;
            }
            boolean bl = nrstopped >= this.outputRowSets.size();
            return bl;
        }
        finally {
            this.outputRowSetsLock.readLock().unlock();
        }
    }

    @Override
    public void stopAll() {
        this.stopped.set(true);
        this.pipeline.stopAll();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.get();
    }

    @Override
    public boolean isRunning() {
        return this.running.get();
    }

    @Override
    public boolean isPaused() {
        return this.paused.get();
    }

    @Override
    public void setStopped(boolean stopped) {
        this.stopped.set(stopped);
    }

    @Override
    public void setSafeStopped(boolean stopped) {
        this.safeStopped.set(stopped);
    }

    @Override
    public boolean isSafeStopped() {
        return this.safeStopped.get();
    }

    @Override
    public void setRunning(boolean running) {
        this.running.set(running);
    }

    @Override
    public void pauseRunning() {
        this.setPaused(true);
    }

    @Override
    public void resumeRunning() {
        this.setPaused(false);
    }

    public void setPaused(boolean paused) {
        this.paused.set(paused);
    }

    public void setPaused(AtomicBoolean paused) {
        this.paused = paused;
    }

    public boolean isInitialising() {
        return this.init;
    }

    @Override
    public void markStart() {
        Calendar cal = Calendar.getInstance();
        this.startTime = cal.getTime();
        this.setInternalVariables();
    }

    public void setInternalVariables() {
        this.setVariable("Internal.Transform.Name", this.transformName);
        this.setVariable("Internal.Transform.CopyNr", Integer.toString(this.getCopy()));
    }

    @Override
    public synchronized void markStop() {
        if (!this.markStopped.get()) {
            this.markStopped.set(true);
            Calendar cal = Calendar.getInstance();
            this.stopTime = cal.getTime();
            this.fireTransformFinishedListeners();
            this.setRunning(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireTransformFinishedListeners() {
        List<ITransformFinishedListener> list = this.transformFinishedListeners;
        synchronized (list) {
            for (ITransformFinishedListener transformListener : this.transformFinishedListeners) {
                transformListener.transformFinished(this.pipeline, this.transformMeta, this);
            }
        }
    }

    @Override
    public long getExecutionDuration() {
        long lapsed;
        if (this.startTime != null && this.stopTime == null) {
            Calendar cal = Calendar.getInstance();
            long now = cal.getTimeInMillis();
            long st = this.startTime.getTime();
            lapsed = now - st;
        } else {
            lapsed = this.startTime != null && this.stopTime != null ? this.stopTime.getTime() - this.startTime.getTime() : 0L;
        }
        return lapsed;
    }

    @Override
    public long getInputBufferSize() {
        long total = 0L;
        Iterator<IRowSet> iterator = this.getInputRowSets().iterator();
        if (iterator.hasNext()) {
            IRowSet inputRowSet = iterator.next();
            return inputRowSet.size();
        }
        return total;
    }

    @Override
    public long getOutputBufferSize() {
        long total = 0L;
        Iterator<IRowSet> iterator = this.getOutputRowSets().iterator();
        if (iterator.hasNext()) {
            IRowSet outputRowSet = iterator.next();
            return outputRowSet.size();
        }
        return total;
    }

    public String toString() {
        StringBuilder string = new StringBuilder(50);
        if (!Utils.isEmpty((CharSequence)this.partitionId)) {
            string.append(this.transformName).append('.').append(this.partitionId);
        } else {
            string.append(this.transformName).append('.').append(this.getCopy());
        }
        return string.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowsetOutputSize() {
        int size = 0;
        this.outputRowSetsLock.readLock().lock();
        try {
            for (IRowSet outputRowSet : this.outputRowSets) {
                size += outputRowSet.size();
            }
        }
        finally {
            this.outputRowSetsLock.readLock().unlock();
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int rowsetInputSize() {
        int size = 0;
        this.inputRowSetsLock.readLock().lock();
        try {
            for (IRowSet inputRowSet : this.inputRowSets) {
                size += inputRowSet.size();
            }
        }
        finally {
            this.inputRowSetsLock.readLock().unlock();
        }
        return size;
    }

    @Override
    public void stopRunning() throws HopException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSummary() {
        Object object = this.statusCountersLock;
        synchronized (object) {
            long li = this.getLinesInput();
            long lo = this.getLinesOutput();
            long lr = this.getLinesRead();
            long lw = this.getLinesWritten();
            long lu = this.getLinesUpdated();
            long lj = this.getLinesRejected();
            if (li > 0L || lo > 0L || lr > 0L || lw > 0L || lu > 0L || lj > 0L || this.errors > 0L) {
                this.logBasic(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lw), String.valueOf(this.errors + lj)}));
            } else {
                this.logDetailed(BaseMessages.getString(PKG, (String)"BaseTransform.Log.SummaryInfo", (String[])new String[]{String.valueOf(li), String.valueOf(lo), String.valueOf(lr), String.valueOf(lw), String.valueOf(lw), String.valueOf(this.errors + lj)}));
            }
        }
    }

    @Override
    public String getTransformPluginId() {
        if (this.transformMeta != null) {
            return this.transformMeta.getTransformPluginId();
        }
        return null;
    }

    @Override
    public List<IRowSet> getInputRowSets() {
        this.inputRowSetsLock.readLock().lock();
        try {
            ArrayList<IRowSet> arrayList = new ArrayList<IRowSet>(this.inputRowSets);
            return arrayList;
        }
        finally {
            this.inputRowSetsLock.readLock().unlock();
        }
    }

    @Override
    public void addRowSetToInputRowSets(IRowSet rowSet) {
        this.inputRowSetsLock.writeLock().lock();
        try {
            this.inputRowSets.add(rowSet);
        }
        finally {
            this.inputRowSetsLock.writeLock().unlock();
        }
    }

    private void removeRowSetFromInputRowSets(IRowSet rowSet) {
        this.inputRowSets.remove(rowSet);
        this.waitingTime.remove(rowSet);
        if (this.currentInputRowSetNr > 0) {
            --this.currentInputRowSetNr;
        }
    }

    protected IRowSet getFirstInputRowSet() {
        this.inputRowSetsLock.readLock().lock();
        try {
            IRowSet iRowSet = this.inputRowSets.get(0);
            return iRowSet;
        }
        finally {
            this.inputRowSetsLock.readLock().unlock();
        }
    }

    protected void clearInputRowSets() {
        this.inputRowSetsLock.writeLock().lock();
        try {
            this.inputRowSets.clear();
        }
        finally {
            this.inputRowSetsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void swapFirstInputRowSetIfExists(String transformName) {
        this.inputRowSetsLock.writeLock().lock();
        try {
            for (int i = 0; i < this.inputRowSets.size(); ++i) {
                IRowSet rs = this.inputRowSets.get(i);
                if (!rs.getOriginTransformName().equalsIgnoreCase(transformName)) continue;
                IRowSet zero = this.inputRowSets.get(0);
                this.inputRowSets.set(0, rs);
                this.inputRowSets.set(i, zero);
            }
        }
        finally {
            this.inputRowSetsLock.writeLock().unlock();
        }
    }

    public void setInputRowSets(List<IRowSet> inputRowSets) {
        this.inputRowSetsLock.writeLock().lock();
        try {
            this.inputRowSets = inputRowSets;
        }
        finally {
            this.inputRowSetsLock.writeLock().unlock();
        }
    }

    @Override
    public List<IRowSet> getOutputRowSets() {
        this.outputRowSetsLock.readLock().lock();
        try {
            ArrayList<IRowSet> arrayList = new ArrayList<IRowSet>(this.outputRowSets);
            return arrayList;
        }
        finally {
            this.outputRowSetsLock.readLock().unlock();
        }
    }

    @Override
    public void addRowSetToOutputRowSets(IRowSet rowSet) {
        this.outputRowSetsLock.writeLock().lock();
        try {
            this.outputRowSets.add(rowSet);
        }
        finally {
            this.outputRowSetsLock.writeLock().unlock();
        }
    }

    protected void clearOutputRowSets() {
        this.outputRowSetsLock.writeLock().lock();
        try {
            this.outputRowSets.clear();
        }
        finally {
            this.outputRowSetsLock.writeLock().unlock();
        }
    }

    public void setOutputRowSets(List<IRowSet> outputRowSets) {
        this.outputRowSetsLock.writeLock().lock();
        try {
            this.outputRowSets = outputRowSets;
        }
        finally {
            this.outputRowSetsLock.writeLock().unlock();
        }
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    @Override
    public void addRowListener(IRowListener rowListener) {
        this.rowListeners.add(rowListener);
    }

    @Override
    public void removeRowListener(IRowListener rowListener) {
        this.rowListeners.remove(rowListener);
    }

    @Override
    public List<IRowListener> getRowListeners() {
        return Collections.unmodifiableList(this.rowListeners);
    }

    public void addResultFile(ResultFile resultFile) {
        ReentrantReadWriteLock.WriteLock lock = this.resultFilesLock.writeLock();
        lock.lock();
        try {
            this.resultFiles.put(resultFile.getFile().toString(), resultFile);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public Map<String, ResultFile> getResultFiles() {
        ReentrantReadWriteLock.ReadLock lock = this.resultFilesLock.readLock();
        lock.lock();
        try {
            HashMap<String, ResultFile> hashMap = new HashMap<String, ResultFile>(this.resultFiles);
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public EngineComponent.ComponentExecutionStatus getStatus() {
        if (this.isRunning()) {
            if (this.isStopped()) {
                return EngineComponent.ComponentExecutionStatus.STATUS_HALTING;
            }
            if (this.isPaused()) {
                return EngineComponent.ComponentExecutionStatus.STATUS_PAUSED;
            }
            return EngineComponent.ComponentExecutionStatus.STATUS_RUNNING;
        }
        if (this.pipeline.isPreparing()) {
            if (this.isInitialising()) {
                return EngineComponent.ComponentExecutionStatus.STATUS_INIT;
            }
            return EngineComponent.ComponentExecutionStatus.STATUS_IDLE;
        }
        if (this.isStopped()) {
            return EngineComponent.ComponentExecutionStatus.STATUS_STOPPED;
        }
        if (this.data.getStatus() == EngineComponent.ComponentExecutionStatus.STATUS_DISPOSED) {
            return EngineComponent.ComponentExecutionStatus.STATUS_FINISHED;
        }
        return this.data.getStatus();
    }

    @Override
    public String getPartitionId() {
        return this.partitionId;
    }

    @Override
    public void setPartitionId(String partitionId) {
        this.partitionId = partitionId;
    }

    public Map<String, BlockingRowSet> getPartitionTargets() {
        return this.partitionTargets;
    }

    public void setPartitionTargets(Map<String, BlockingRowSet> partitionTargets) {
        this.partitionTargets = partitionTargets;
    }

    public int getRepartitioning() {
        return this.repartitioning;
    }

    @Override
    public void setRepartitioning(int repartitioning) {
        this.repartitioning = repartitioning;
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Override
    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    protected boolean checkFeedback(long lines) {
        return this.getPipeline().isFeedbackShown() && lines > 0L && this.getPipeline().getFeedbackSize() > 0 && lines % (long)this.getPipeline().getFeedbackSize() == 0L;
    }

    public IRowMeta getInputRowMeta() {
        return this.inputRowMeta;
    }

    public void setInputRowMeta(IRowMeta rowMeta) {
        this.inputRowMeta = rowMeta;
    }

    public IRowMeta getErrorRowMeta() {
        return this.errorRowMeta;
    }

    public void setErrorRowMeta(IRowMeta errorRowMeta) {
        this.errorRowMeta = errorRowMeta;
    }

    public IRowMeta getPreviewRowMeta() {
        return this.previewRowMeta;
    }

    public void setPreviewRowMeta(IRowMeta previewRowMeta) {
        this.previewRowMeta = previewRowMeta;
    }

    public void copyFrom(IVariables variables) {
        this.variables.copyFrom(variables);
    }

    public String resolve(String aString) {
        return this.variables.resolve(aString);
    }

    public String[] resolve(String[] aString) {
        return this.variables.resolve(aString);
    }

    public String resolve(String aString, IRowMeta rowMeta, Object[] rowData) throws HopValueException {
        return this.variables.resolve(aString, rowMeta, rowData);
    }

    public IVariables getParentVariables() {
        if (this.pipeline != null) {
            return this.pipeline;
        }
        return this.variables.getParentVariables();
    }

    public void setParentVariables(IVariables parent) {
        this.variables.setParentVariables(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getVariableBoolean(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.getVariable(variableName)))) {
            return ValueMetaString.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeFrom(IVariables parent) {
        this.variables.initializeFrom(parent);
    }

    public String[] getVariableNames() {
        return this.variables.getVariableNames();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareWith(IVariables variables) {
        this.variables = variables;
    }

    public void setVariables(Map<String, String> map) {
        this.variables.setVariables(map);
    }

    @Override
    public void initBeforeStart() throws HopTransformException {
    }

    @Override
    public boolean processRow() throws HopException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canProcessOneRow() {
        this.inputRowSetsLock.readLock().lock();
        try {
            switch (this.inputRowSets.size()) {
                case 0: {
                    boolean bl = false;
                    return bl;
                }
                case 1: {
                    IRowSet set = this.inputRowSets.get(0);
                    if (set.isDone()) {
                        boolean bl = false;
                        return bl;
                    }
                    boolean bl = set.size() > 0;
                    return bl;
                }
            }
            boolean allDone = true;
            for (IRowSet rowSet : this.inputRowSets) {
                if (!rowSet.isDone()) {
                    allDone = false;
                }
                if (rowSet.size() <= 0) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = !allDone;
            return bl;
        }
        finally {
            this.inputRowSetsLock.readLock().unlock();
        }
    }

    @Override
    public void addTransformFinishedListener(ITransformFinishedListener transformFinishedListener) {
        this.transformFinishedListeners.add(transformFinishedListener);
    }

    @Override
    public void addTransformStartedListener(ITransformStartedListener transformStartedListener) {
        this.transformStartedListeners.add(transformStartedListener);
    }

    public List<ITransformFinishedListener> getTransformFinishedListeners() {
        return this.transformFinishedListeners;
    }

    public void setTransformFinishedListeners(List<ITransformFinishedListener> transformFinishedListeners) {
        this.transformFinishedListeners = transformFinishedListeners;
    }

    public List<ITransformStartedListener> getTransformStartedListeners() {
        return this.transformStartedListeners;
    }

    public void setTransformStartedListeners(List<ITransformStartedListener> transformStartedListeners) {
        this.transformStartedListeners = transformStartedListeners;
    }

    @Override
    public boolean isMapping() {
        return this.transformMeta.isMapping();
    }

    public String getObjectName() {
        return this.getTransformName();
    }

    @Override
    public ILogChannel getLogChannel() {
        return this.log;
    }

    @Override
    public String getName() {
        return this.transformName;
    }

    @Override
    public int getCopyNr() {
        return this.copyNr;
    }

    public void setCopyNr(int copyNr) {
        this.copyNr = copyNr;
    }

    @Override
    public String getLogText() {
        StringBuffer buffer = HopLogStore.getAppender().getBuffer(this.log.getLogChannelId(), false);
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    public String getFilename() {
        return null;
    }

    @Override
    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.TRANSFORM;
    }

    public ILoggingObject getParent() {
        return this.pipeline;
    }

    public String getObjectCopy() {
        return Integer.toString(this.copyNr);
    }

    @Override
    public LogLevel getLogLevel() {
        return this.log != null ? this.log.getLogLevel() : null;
    }

    @Override
    public void setLogLevel(LogLevel logLevel) {
        this.log.setLogLevel(logLevel);
    }

    public static void closeQuietly(Closeable cl) {
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getContainerId() {
        return this.containerObjectId;
    }

    public void setCarteObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    @Override
    public void batchComplete() throws HopException {
    }

    public Date getRegistrationDate() {
        return null;
    }

    public boolean isGatheringMetrics() {
        return this.log != null && this.log.isGatheringMetrics();
    }

    public void setGatheringMetrics(boolean gatheringMetrics) {
        if (this.log != null) {
            this.log.setGatheringMetrics(gatheringMetrics);
        }
    }

    public boolean isForcingSeparateLogging() {
        return this.log != null && this.log.isForcingSeparateLogging();
    }

    public void setForcingSeparateLogging(boolean forcingSeparateLogging) {
        if (this.log != null) {
            this.log.setForcingSeparateLogging(forcingSeparateLogging);
        }
    }

    @Override
    public IHopMetadataProvider getMetadataProvider() {
        return this.metadataProvider;
    }

    @Override
    public void setMetadataProvider(IHopMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    @Override
    public int getCurrentOutputRowSetNr() {
        return this.currentOutputRowSetNr;
    }

    @Override
    public void setCurrentOutputRowSetNr(int index) {
        this.currentOutputRowSetNr = index;
    }

    @Override
    public int getCurrentInputRowSetNr() {
        return this.currentInputRowSetNr;
    }

    @Override
    public void setCurrentInputRowSetNr(int index) {
        this.currentInputRowSetNr = index;
    }

    public Map<String, Object> getExtensionDataMap() {
        return this.extensionDataMap;
    }

    @Override
    public Date getInitStartDate() {
        return this.initStartDate;
    }

    @Override
    public void setInitStartDate(Date initStartDate) {
        this.initStartDate = initStartDate;
    }

    @Override
    public Date getExecutionStartDate() {
        return this.executionStartDate;
    }

    @Override
    public void setExecutionStartDate(Date executionStartDate) {
        this.executionStartDate = executionStartDate;
    }

    @Override
    public Date getFirstRowReadDate() {
        return this.firstRowReadDate;
    }

    @Override
    public void setFirstRowReadDate(Date firstRowReadDate) {
        this.firstRowReadDate = firstRowReadDate;
    }

    @Override
    public Date getLastRowWrittenDate() {
        return this.lastRowWrittenDate;
    }

    @Override
    public void setLastRowWrittenDate(Date lastRowWrittenDate) {
        this.lastRowWrittenDate = lastRowWrittenDate;
    }

    @Override
    public Date getExecutionEndDate() {
        return this.executionEndDate;
    }

    @Override
    public void setExecutionEndDate(Date executionEndDate) {
        this.executionEndDate = executionEndDate;
    }

    private class DefaultRowHandler
    implements IRowHandler {
        private DefaultRowHandler() {
        }

        @Override
        public Object[] getRow() throws HopException {
            return BaseTransform.this.handleGetRow();
        }

        @Override
        public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
            BaseTransform.this.handlePutRow(rowMeta, row);
        }

        @Override
        public void putError(IRowMeta rowMeta, Object[] row, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) throws HopTransformException {
            BaseTransform.this.handlePutError(BaseTransform.this.variables, rowMeta, row, nrErrors, errorDescriptions, fieldNames, errorCodes);
        }

        @Override
        public Object[] getRowFrom(IRowSet rowSet) throws HopTransformException {
            return BaseTransform.this.handleGetRowFrom(rowSet);
        }

        @Override
        public void putRowTo(IRowMeta rowMeta, Object[] row, IRowSet rowSet) throws HopTransformException {
            BaseTransform.this.handlePutRowTo(rowMeta, row, rowSet);
        }
    }
}

