/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin.action;

import java.lang.reflect.Method;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.plugin.IGuiActionLambda;
import org.apache.hop.core.gui.plugin.IGuiRefresher;
import org.apache.hop.core.gui.plugin.action.GuiAction;

public class GuiActionLambdaBuilder<T> {
    public GuiAction createLambda(GuiAction guiAction, T methodParameter, IGuiRefresher refresher) {
        if (guiAction.getGuiPluginMethodName() == null) {
            throw new RuntimeException("We need a method to execute this action");
        }
        GuiAction action = new GuiAction(guiAction);
        try {
            Object guiPlugin;
            Class<?> guiPluginClass;
            ClassLoader classLoader = guiAction.getClassLoader() == null ? this.getClass().getClassLoader() : guiAction.getClassLoader();
            try {
                guiPluginClass = classLoader.loadClass(guiAction.getGuiPluginClassName());
            }
            catch (Exception e) {
                throw new HopException("Unable to find class '" + guiAction.getGuiPluginClassName() + "'", e);
            }
            try {
                Method getInstanceMethod = guiPluginClass.getDeclaredMethod("getInstance", new Class[0]);
                guiPlugin = getInstanceMethod.invoke(null, null);
            }
            catch (Exception nsme) {
                try {
                    guiPlugin = guiPluginClass.newInstance();
                }
                catch (Exception e) {
                    throw nsme;
                }
            }
            Method method = guiPluginClass.getMethod(action.getGuiPluginMethodName(), methodParameter.getClass());
            if (method == null) {
                throw new RuntimeException("Unable to find method " + action.getGuiPluginMethodName() + " with parameter " + methodParameter.getClass().getName() + " in class " + guiAction.getGuiPluginClassName());
            }
            Object finalGuiPlugin = guiPlugin;
            IGuiActionLambda<Object> actionLambda = (shiftClicked, controlClicked, objects) -> {
                try {
                    method.invoke(finalGuiPlugin, methodParameter);
                    if (refresher != null) {
                        refresher.updateGui();
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException("Error executing method : " + action.getGuiPluginMethodName() + " in class " + guiAction.getGuiPluginClassName(), e);
                }
            };
            action.setActionLambda(actionLambda);
            return action;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating action function for action : " + this.toString() + ". Probably you need to provide a static getInstance() method in class " + guiAction.getGuiPluginClassName() + " to allow the GuiPlugin to be found and then method " + guiAction.getGuiPluginMethodName() + " can be called.", e);
        }
    }
}

