/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.windowing;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.repackaged.direct_java.sdk.fn.windowing.AutoValue_EncodedBoundedWindow;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.ByteStreams;
import org.joda.time.Instant;

@AutoValue
public abstract class EncodedBoundedWindow
extends BoundedWindow {
    public static EncodedBoundedWindow forEncoding(ByteString encodedWindow) {
        return new AutoValue_EncodedBoundedWindow(encodedWindow);
    }

    public abstract ByteString getEncodedWindow();

    @Override
    public Instant maxTimestamp() {
        throw new UnsupportedOperationException("TODO: Add support for reading the timestamp from the encoded window.");
    }

    public static class Coder
    extends AtomicCoder<EncodedBoundedWindow> {
        public static final Coder INSTANCE = new Coder();

        private Coder() {
        }

        @Override
        public void encode(EncodedBoundedWindow value, OutputStream outStream) throws CoderException, IOException {
            VarInt.encode(value.getEncodedWindow().size(), outStream);
            value.getEncodedWindow().writeTo(outStream);
        }

        @Override
        public EncodedBoundedWindow decode(InputStream inStream) throws CoderException, IOException {
            int size = VarInt.decodeInt(inStream);
            ByteString encodedWindow = ByteString.readFrom((InputStream)ByteStreams.limit((InputStream)inStream, (long)size));
            return EncodedBoundedWindow.forEncoding(encodedWindow);
        }

        @Override
        public boolean consistentWithEquals() {
            return true;
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(EncodedBoundedWindow value) {
            return true;
        }

        @Override
        protected long getEncodedElementByteSize(EncodedBoundedWindow value) throws Exception {
            return (long)VarInt.getLength(value.getEncodedWindow().size()) + (long)value.getEncodedWindow().size();
        }
    }
}

