/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.sdk.fn.channel;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.List;
import org.apache.beam.model.pipeline.v1.Endpoints;
import org.apache.beam.repackaged.direct_java.sdk.fn.channel.SocketAddressFactory;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ClientInterceptor;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ManagedChannel;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.ManagedChannelBuilder;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.inprocess.InProcessChannelBuilder;
import org.apache.beam.vendor.grpc.v1p43p2.io.grpc.netty.NettyChannelBuilder;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.EventLoopGroup;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.epoll.Epoll;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.epoll.EpollDomainSocketChannel;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.epoll.EpollEventLoopGroup;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.epoll.EpollSocketChannel;
import org.apache.beam.vendor.grpc.v1p43p2.io.netty.channel.unix.DomainSocketAddress;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class ManagedChannelFactory {
    private final Type type;
    private final List<ClientInterceptor> interceptors;
    private final boolean directExecutor;

    public static ManagedChannelFactory createDefault() {
        return new ManagedChannelFactory(Type.DEFAULT, Collections.emptyList(), false);
    }

    public static ManagedChannelFactory createEpoll() {
        Epoll.ensureAvailability();
        return new ManagedChannelFactory(Type.EPOLL, Collections.emptyList(), false);
    }

    public static ManagedChannelFactory createInProcess() {
        return new ManagedChannelFactory(Type.IN_PROCESS, Collections.emptyList(), false);
    }

    public ManagedChannel forDescriptor(Endpoints.ApiServiceDescriptor apiServiceDescriptor) {
        ManagedChannelBuilder channelBuilder;
        switch (this.type) {
            case EPOLL: {
                SocketAddress address = SocketAddressFactory.createFrom(apiServiceDescriptor.getUrl());
                channelBuilder = NettyChannelBuilder.forAddress((SocketAddress)address).channelType(address instanceof DomainSocketAddress ? EpollDomainSocketChannel.class : EpollSocketChannel.class).eventLoopGroup((EventLoopGroup)new EpollEventLoopGroup());
                break;
            }
            case DEFAULT: {
                channelBuilder = ManagedChannelBuilder.forTarget((String)apiServiceDescriptor.getUrl());
                break;
            }
            case IN_PROCESS: {
                channelBuilder = InProcessChannelBuilder.forName((String)apiServiceDescriptor.getUrl());
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type " + (Object)((Object)this.type));
            }
        }
        channelBuilder = channelBuilder.usePlaintext().maxInboundMessageSize(Integer.MAX_VALUE).intercept(this.interceptors);
        if (this.directExecutor) {
            channelBuilder = channelBuilder.directExecutor();
        }
        return channelBuilder.build();
    }

    private ManagedChannelFactory(Type type, List<ClientInterceptor> interceptors, boolean directExecutor) {
        this.type = type;
        this.interceptors = interceptors;
        this.directExecutor = directExecutor;
    }

    public ManagedChannelFactory withInterceptors(List<ClientInterceptor> interceptors) {
        return new ManagedChannelFactory(this.type, (List<ClientInterceptor>)ImmutableList.builder().addAll(this.interceptors).addAll(interceptors).build(), this.directExecutor);
    }

    public ManagedChannelFactory withDirectExecutor() {
        return new ManagedChannelFactory(this.type, this.interceptors, true);
    }

    private static enum Type {
        EPOLL,
        DEFAULT,
        IN_PROCESS;

    }
}

