/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.direct_java.runners.core.metrics;

import java.util.HashSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.repackaged.direct_java.runners.core.metrics.ExecutionStateTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTimeUtils;

public class ExecutionStateSampler {
    @GuardedBy(value="this")
    private final HashSet<ExecutionStateTracker> activeTrackers = new HashSet();
    private static final DateTimeUtils.MillisProvider SYSTEM_MILLIS_PROVIDER = System::currentTimeMillis;
    private static final ExecutionStateSampler INSTANCE = new ExecutionStateSampler(SYSTEM_MILLIS_PROVIDER);
    private final DateTimeUtils.MillisProvider clock;
    @VisibleForTesting
    volatile long lastSampleTimeMillis;
    private static long periodMs = 200L;
    private @Nullable Future<Void> executionSamplerFuture = null;

    private ExecutionStateSampler(DateTimeUtils.MillisProvider clock) {
        this.clock = clock;
    }

    public static ExecutionStateSampler instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    public static ExecutionStateSampler newForTest() {
        return new ExecutionStateSampler(SYSTEM_MILLIS_PROVIDER);
    }

    @VisibleForTesting
    public static ExecutionStateSampler newForTest(DateTimeUtils.MillisProvider clock) {
        return new ExecutionStateSampler((DateTimeUtils.MillisProvider)Preconditions.checkNotNull((Object)clock));
    }

    public static void setSamplingPeriod(long samplingPeriodMillis) {
        periodMs = samplingPeriodMillis;
    }

    public void reset() {
        this.lastSampleTimeMillis = 0L;
    }

    public void start() {
        this.start(Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("state-sampler-%d").build()));
    }

    @VisibleForTesting
    synchronized void start(ExecutorService executor) {
        if (this.executionSamplerFuture != null) {
            return;
        }
        this.executionSamplerFuture = executor.submit(() -> {
            this.lastSampleTimeMillis = this.clock.getMillis();
            long targetTimeMillis = this.lastSampleTimeMillis + periodMs;
            while (!Thread.interrupted()) {
                long currentTimeMillis = this.clock.getMillis();
                long difference = targetTimeMillis - currentTimeMillis;
                if (difference > 0L) {
                    try {
                        Thread.sleep(difference);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                this.doSampling(currentTimeMillis - this.lastSampleTimeMillis);
                this.lastSampleTimeMillis = currentTimeMillis;
                targetTimeMillis = this.lastSampleTimeMillis + periodMs;
            }
            return null;
        });
    }

    public synchronized void stop() {
        if (this.executionSamplerFuture == null) {
            return;
        }
        this.executionSamplerFuture.cancel(true);
        try {
            this.executionSamplerFuture.get(5L * periodMs, TimeUnit.MILLISECONDS);
        }
        catch (CancellationException cancellationException) {
        }
        catch (InterruptedException | TimeoutException e) {
            throw new RuntimeException("Failed to stop state sampling after waiting 5 sampling periods.", e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Exception in state sampler", e);
        }
        finally {
            this.executionSamplerFuture = null;
        }
    }

    synchronized void addTracker(ExecutionStateTracker tracker) {
        this.activeTrackers.add(tracker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTracker(ExecutionStateTracker tracker) {
        ExecutionStateSampler executionStateSampler = this;
        synchronized (executionStateSampler) {
            this.activeTrackers.remove(tracker);
        }
        long millisSinceLastSample = this.clock.getMillis() - this.lastSampleTimeMillis;
        if (millisSinceLastSample > 0L) {
            tracker.takeSample(millisSinceLastSample);
        }
    }

    @VisibleForTesting
    public synchronized void doSampling(long millisSinceLastSample) {
        for (ExecutionStateTracker tracker : this.activeTrackers) {
            tracker.takeSample(millisSinceLastSample);
        }
    }
}

