/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.enunciate.modules.jersey;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.ws.rs.core.MediaType;

public class JerseyAdaptedHttpServletRequest
extends HttpServletRequestWrapper {
    public static final String PROPERTY_SERVLET_PATH = "org.codehaus.enunciate.modules.jersey.config.ServletPath";
    public static final String PROPERTY_RESOURCE_PROVIDER_FACTORY = "org.codehaus.enunciate.modules.jersey.config.ResourceProviderFactory";
    public static final String FEATURE_PATH_BASED_CONNEG = "org.codehaus.enunciate.modules.jersey.config.PathBasedConneg";
    private final MediaType mediaType;

    public JerseyAdaptedHttpServletRequest(HttpServletRequest request, MediaType mediaType) {
        super(request);
        this.mediaType = mediaType;
    }

    public String getHeader(String headerName) {
        String header = super.getHeader(headerName);
        if (this.mediaType != null && "Accept".equalsIgnoreCase(headerName)) {
            header = this.mediaType.toString();
        }
        return header;
    }

    public Enumeration getHeaders(String headerName) {
        Enumeration<String> headers = super.getHeaders(headerName);
        if (this.mediaType != null && "Accept".equalsIgnoreCase(headerName)) {
            headers = Collections.enumeration(Arrays.asList(this.mediaType.toString()));
        }
        return headers;
    }

    public Enumeration getHeaderNames() {
        Enumeration headerNames = super.getHeaderNames();
        ArrayList<String> copy = new ArrayList<String>();
        if (this.mediaType != null) {
            copy.add("Accept");
        }
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (this.mediaType != null && "Accept".equalsIgnoreCase(headerName)) continue;
            copy.add(headerName);
        }
        return Collections.enumeration(copy);
    }
}

