/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws.sqs;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.io.aws.options.AwsModule;
import org.apache.beam.sdk.io.aws.options.AwsOptions;

class SqsConfiguration
implements Serializable {
    private String awsRegion;
    private String awsCredentialsProviderString;
    private String awsClientConfigurationString;

    public SqsConfiguration(AwsOptions awsOptions) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            this.awsCredentialsProviderString = om.writeValueAsString((Object)awsOptions.getAwsCredentialsProvider());
        }
        catch (JsonProcessingException e) {
            this.awsCredentialsProviderString = null;
        }
        try {
            this.awsClientConfigurationString = om.writeValueAsString((Object)awsOptions.getClientConfiguration());
        }
        catch (JsonProcessingException e) {
            this.awsClientConfigurationString = null;
        }
        this.awsRegion = awsOptions.getAwsRegion();
    }

    public AWSCredentialsProvider getAwsCredentialsProvider() {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (AWSCredentialsProvider)om.readValue(this.awsCredentialsProviderString, AWSCredentialsProvider.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public ClientConfiguration getClientConfiguration() {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (ClientConfiguration)om.readValue(this.awsClientConfigurationString, ClientConfiguration.class);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getAwsRegion() {
        return this.awsRegion;
    }
}

