/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.Token;
import org.apache.hadoop.yarn.api.records.impl.pb.ContainerIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.NodeIdPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.PriorityPBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.ProtoUtils;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.api.records.impl.pb.TokenPBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ContainerPBImpl
extends Container {
    YarnProtos.ContainerProto proto = YarnProtos.ContainerProto.getDefaultInstance();
    YarnProtos.ContainerProto.Builder builder = null;
    boolean viaProto = false;
    private ContainerId containerId = null;
    private NodeId nodeId = null;
    private Resource resource = null;
    private Priority priority = null;
    private Token containerToken = null;

    public ContainerPBImpl() {
        this.builder = YarnProtos.ContainerProto.newBuilder();
    }

    public ContainerPBImpl(YarnProtos.ContainerProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnProtos.ContainerProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(((Object)((Object)this)).getClass())) {
            return this.getProto().equals((Object)((ContainerPBImpl)((Object)((Object)((Object)this)).getClass().cast(other))).getProto());
        }
        return false;
    }

    private void mergeLocalToBuilder() {
        if (this.containerId != null && !((ContainerIdPBImpl)this.containerId).getProto().equals((Object)this.builder.getId())) {
            this.builder.setId(this.convertToProtoFormat(this.containerId));
        }
        if (this.nodeId != null && !((NodeIdPBImpl)this.nodeId).getProto().equals((Object)this.builder.getNodeId())) {
            this.builder.setNodeId(this.convertToProtoFormat(this.nodeId));
        }
        if (this.resource != null) {
            this.builder.setResource(this.convertToProtoFormat(this.resource));
        }
        if (this.priority != null && !((PriorityPBImpl)this.priority).getProto().equals((Object)this.builder.getPriority())) {
            this.builder.setPriority(this.convertToProtoFormat(this.priority));
        }
        if (this.containerToken != null && !((TokenPBImpl)this.containerToken).getProto().equals((Object)this.builder.getContainerToken())) {
            this.builder.setContainerToken(this.convertToProtoFormat(this.containerToken));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ContainerProto.newBuilder((YarnProtos.ContainerProto)this.proto);
        }
        this.viaProto = false;
    }

    public ContainerId getId() {
        YarnProtos.ContainerProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.containerId != null) {
            return this.containerId;
        }
        if (!p.hasId()) {
            return null;
        }
        this.containerId = this.convertFromProtoFormat(p.getId());
        return this.containerId;
    }

    public void setNodeId(NodeId nodeId) {
        this.maybeInitBuilder();
        if (nodeId == null) {
            this.builder.clearNodeId();
        }
        this.nodeId = nodeId;
    }

    public NodeId getNodeId() {
        YarnProtos.ContainerProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.nodeId != null) {
            return this.nodeId;
        }
        if (!p.hasNodeId()) {
            return null;
        }
        this.nodeId = this.convertFromProtoFormat(p.getNodeId());
        return this.nodeId;
    }

    public void setId(ContainerId id) {
        this.maybeInitBuilder();
        if (id == null) {
            this.builder.clearId();
        }
        this.containerId = id;
    }

    public String getNodeHttpAddress() {
        YarnProtos.ContainerProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasNodeHttpAddress()) {
            return null;
        }
        return p.getNodeHttpAddress();
    }

    public void setNodeHttpAddress(String nodeHttpAddress) {
        this.maybeInitBuilder();
        if (nodeHttpAddress == null) {
            this.builder.clearNodeHttpAddress();
            return;
        }
        this.builder.setNodeHttpAddress(nodeHttpAddress);
    }

    public Resource getResource() {
        YarnProtos.ContainerProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.resource != null) {
            return this.resource;
        }
        if (!p.hasResource()) {
            return null;
        }
        this.resource = this.convertFromProtoFormat(p.getResource());
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.maybeInitBuilder();
        if (resource == null) {
            this.builder.clearResource();
        }
        this.resource = resource;
    }

    public Priority getPriority() {
        YarnProtos.ContainerProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.priority != null) {
            return this.priority;
        }
        if (!p.hasPriority()) {
            return null;
        }
        this.priority = this.convertFromProtoFormat(p.getPriority());
        return this.priority;
    }

    public void setPriority(Priority priority) {
        this.maybeInitBuilder();
        if (priority == null) {
            this.builder.clearPriority();
        }
        this.priority = priority;
    }

    public Token getContainerToken() {
        YarnProtos.ContainerProto p;
        Object object = p = this.viaProto ? this.proto : this.builder;
        if (this.containerToken != null) {
            return this.containerToken;
        }
        if (!p.hasContainerToken()) {
            return null;
        }
        this.containerToken = this.convertFromProtoFormat(p.getContainerToken());
        return this.containerToken;
    }

    public void setContainerToken(Token containerToken) {
        this.maybeInitBuilder();
        if (containerToken == null) {
            this.builder.clearContainerToken();
        }
        this.containerToken = containerToken;
    }

    public ExecutionType getExecutionType() {
        YarnProtos.ContainerProto p = this.viaProto ? this.proto : this.builder;
        return this.convertFromProtoFormat(p.getExecutionType());
    }

    public void setExecutionType(ExecutionType executionType) {
        this.maybeInitBuilder();
        this.builder.setExecutionType(this.convertToProtoFormat(executionType));
    }

    public long getAllocationRequestId() {
        YarnProtos.ContainerProto p = this.viaProto ? this.proto : this.builder;
        return p.getAllocationRequestId();
    }

    public void setAllocationRequestId(long allocationRequestID) {
        this.maybeInitBuilder();
        this.builder.setAllocationRequestId(allocationRequestID);
    }

    public int getVersion() {
        YarnProtos.ContainerProto p = this.viaProto ? this.proto : this.builder;
        return p.getVersion();
    }

    public void setVersion(int version) {
        this.maybeInitBuilder();
        this.builder.setVersion(version);
    }

    private ContainerIdPBImpl convertFromProtoFormat(YarnProtos.ContainerIdProto p) {
        return new ContainerIdPBImpl(p);
    }

    private NodeIdPBImpl convertFromProtoFormat(YarnProtos.NodeIdProto p) {
        return new NodeIdPBImpl(p);
    }

    private YarnProtos.ContainerIdProto convertToProtoFormat(ContainerId t) {
        return ((ContainerIdPBImpl)t).getProto();
    }

    private YarnProtos.NodeIdProto convertToProtoFormat(NodeId t) {
        return ((NodeIdPBImpl)t).getProto();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ProtoUtils.convertToProtoFormat(t);
    }

    private PriorityPBImpl convertFromProtoFormat(YarnProtos.PriorityProto p) {
        return new PriorityPBImpl(p);
    }

    private YarnProtos.PriorityProto convertToProtoFormat(Priority p) {
        return ((PriorityPBImpl)p).getProto();
    }

    private TokenPBImpl convertFromProtoFormat(SecurityProtos.TokenProto p) {
        return new TokenPBImpl(p);
    }

    private SecurityProtos.TokenProto convertToProtoFormat(Token t) {
        return ((TokenPBImpl)t).getProto();
    }

    private ExecutionType convertFromProtoFormat(YarnProtos.ExecutionTypeProto e) {
        return ProtoUtils.convertFromProtoFormat(e);
    }

    private YarnProtos.ExecutionTypeProto convertToProtoFormat(ExecutionType e) {
        return ProtoUtils.convertToProtoFormat(e);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Container: [");
        sb.append("ContainerId: ").append(this.getId()).append(", ");
        sb.append("AllocationRequestId: ").append(this.getAllocationRequestId()).append(", ");
        sb.append("Version: ").append(this.getVersion()).append(", ");
        sb.append("NodeId: ").append(this.getNodeId()).append(", ");
        sb.append("NodeHttpAddress: ").append(this.getNodeHttpAddress()).append(", ");
        sb.append("Resource: ").append(this.getResource()).append(", ");
        sb.append("Priority: ").append(this.getPriority()).append(", ");
        sb.append("Token: ").append(this.getContainerToken()).append(", ");
        sb.append("ExecutionType: ").append(this.getExecutionType()).append(", ");
        sb.append("]");
        return sb.toString();
    }

    public int compareTo(Container other) {
        if (this.getId().compareTo(other.getId()) == 0) {
            if (this.getNodeId().compareTo(other.getNodeId()) == 0) {
                return this.getResource().compareTo(other.getResource());
            }
            return this.getNodeId().compareTo(other.getNodeId());
        }
        return this.getId().compareTo(other.getId());
    }
}

