/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.webservices;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.webservices.WebServiceField;
import org.apache.hop.pipeline.transforms.webservices.WebServiceMeta;
import org.apache.hop.pipeline.transforms.webservices.wsdl.ComplexType;
import org.apache.hop.pipeline.transforms.webservices.wsdl.Wsdl;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpParameter;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpParameterContainer;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOpParameterList;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOperation;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlOperationContainer;
import org.apache.hop.pipeline.transforms.webservices.wsdl.WsdlParamContainer;
import org.apache.hop.pipeline.transforms.webservices.wsdl.XsdType;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.PasswordTextVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class WebServiceDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = WebServiceMeta.class;
    private WebServiceMeta meta;
    private CTabFolder wTabFolder;
    private TextVar wURL;
    private CCombo wOperation;
    private Text wOperationRequest;
    private Label wlBatchSize;
    private Text wBatchSize;
    private Button wPassInputData;
    private Button wCompatible;
    private TextVar wRepeatingElement;
    private Button wReplyAsString;
    private TextVar wHttpLogin;
    private TextVar wHttpPassword;
    private TextVar wProxyHost;
    private TextVar wProxyPort;
    private TableView fieldInTableView;
    private TableView fieldOutTableView;
    private CTabItem tabItemFieldIn;
    private CTabItem tabItemFieldOut;
    private Wsdl wsdl;
    private WsdlOperation wsdlOperation;
    private WsdlParamContainer inWsdlParamContainer;
    private WsdlParamContainer outWsdlParamContainer;
    private final ModifyListener lsMod = e -> this.meta.setChanged();
    private final List<ColumnInfo> fieldColumns = new ArrayList<ColumnInfo>();
    private IRowMeta prevFields;

    private void selectWSDLOperation(String anOperationName) throws HopException {
        this.loadOperation(anOperationName);
        if (this.inWsdlParamContainer != null) {
            this.wBatchSize.setVisible(true);
            this.wlBatchSize.setVisible(true);
            if (!this.inWsdlParamContainer.isArray()) {
                this.wBatchSize.setText("1");
            }
            this.addTabFieldIn();
            this.setComboValues();
        } else {
            this.wBatchSize.setText("1");
            this.removeTabField(this.tabItemFieldIn);
            this.tabItemFieldIn = null;
        }
        if (this.outWsdlParamContainer != null) {
            this.addTabFieldOut();
        } else {
            this.removeTabField(this.tabItemFieldOut);
            this.tabItemFieldOut = null;
        }
    }

    private void loadWebService(String anURI) throws HopException {
        anURI = this.variables.resolve(anURI);
        try {
            if (this.wProxyHost.getText() != null && !"".equals(this.wProxyHost.getText())) {
                Properties systemProperties = System.getProperties();
                systemProperties.setProperty("http.proxyHost", this.variables.resolve(this.wProxyHost.getText()));
                systemProperties.setProperty("http.proxyPort", this.variables.resolve(this.wProxyPort.getText()));
            }
            this.wsdl = new Wsdl(new URI(anURI), null, null, this.wHttpLogin.getText(), this.wHttpPassword.getText());
        }
        catch (Exception e) {
            this.wsdl = null;
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0009.UnreachableURI", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebServiceDialog.ErrorDialog.Title", (String[])new String[0]) + anURI, e);
            this.log.logError(BaseMessages.getString(PKG, (String)"WebServiceDialog.ErrorDialog.Title", (String[])new String[0]) + anURI, new Object[]{e.getMessage()});
            return;
        }
        String text = this.wOperation.getText();
        this.wOperation.removeAll();
        if (this.wsdl != null) {
            List<WsdlOperation> listeOperations = this.wsdl.getOperations();
            Collections.sort(listeOperations, (op1, op2) -> op1.getOperationQName().getLocalPart().compareTo(op2.getOperationQName().getLocalPart()));
            for (WsdlOperation op : listeOperations) {
                this.wOperation.add(op.getOperationQName().getLocalPart());
                if (!op.getOperationQName().getLocalPart().equals(text)) continue;
                this.wOperation.setText(text);
            }
        }
    }

    private void loadOperation(String anOperationName) throws HopException {
        this.wsdlOperation = null;
        this.inWsdlParamContainer = null;
        this.outWsdlParamContainer = null;
        if (this.wsdl != null) {
            Iterator<WsdlOperation> vItOperation = this.wsdl.getOperations().iterator();
            while (vItOperation.hasNext() && this.wsdlOperation == null) {
                WsdlOperation vCurrentOperation = vItOperation.next();
                if (!vCurrentOperation.getOperationQName().getLocalPart().equals(anOperationName)) continue;
                this.wsdlOperation = vCurrentOperation;
            }
        }
        if (this.wsdlOperation != null) {
            String request = "";
            WsdlOpParameterList parameters = this.wsdlOperation.getParameters();
            if (parameters != null && parameters.getOperation() != null && parameters.getOperation().getInput() != null && parameters.getOperation().getInput().getName() != null) {
                request = this.wsdlOperation.getParameters().getOperation().getInput().getName().toString();
            }
            this.wOperationRequest.setText(request);
            for (int cpt = 0; cpt < this.wsdlOperation.getParameters().size(); ++cpt) {
                WsdlOpParameter param = (WsdlOpParameter)this.wsdlOperation.getParameters().get(cpt);
                if (param.isArray()) {
                    if (param.getItemXmlType() == null) continue;
                    ComplexType type = param.getItemComplexType();
                    if (type != null) {
                        for (String attributeName : type.listObjectNames()) {
                            QName attributeType = type.getElementType(attributeName);
                            if ("http://www.w3.org/2001/XMLSchema".equals(attributeType.getNamespaceURI())) continue;
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0007.UnsupporteOperation.ComplexType", (String[])new String[0]));
                        }
                    }
                    if (WsdlOpParameter.ParameterMode.IN.equals(param.getMode()) || WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) {
                        if (this.inWsdlParamContainer != null) {
                            throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0006.UnsupportedOperation.MultipleArrays", (String[])new String[0]));
                        }
                        this.inWsdlParamContainer = new WsdlOpParameterContainer(param);
                        continue;
                    }
                    if (!WsdlOpParameter.ParameterMode.OUT.equals(param.getMode()) && !WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) && !WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) continue;
                    if (this.outWsdlParamContainer != null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0006.UnsupportedOperation.MultipleArrays", (String[])new String[0]));
                    }
                    this.outWsdlParamContainer = new WsdlOpParameterContainer(param);
                    continue;
                }
                if (WsdlOpParameter.ParameterMode.IN.equals(param.getMode()) || WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) {
                    if (this.inWsdlParamContainer != null && !(this.inWsdlParamContainer instanceof WsdlOperationContainer)) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0008.UnsupportedOperation.IncorrectParams", (String[])new String[0]));
                    }
                    this.inWsdlParamContainer = new WsdlOperationContainer(this.wsdlOperation, param.getMode());
                    continue;
                }
                if (WsdlOpParameter.ParameterMode.OUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.INOUT.equals(param.getMode()) || WsdlOpParameter.ParameterMode.UNDEFINED.equals(param.getMode())) {
                    if (this.outWsdlParamContainer != null && !(this.outWsdlParamContainer instanceof WsdlOperationContainer)) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0008.UnsupportedOperation.IncorrectParams", (String[])new String[0]));
                    }
                    this.outWsdlParamContainer = new WsdlOperationContainer(this.wsdlOperation, param.getMode());
                    continue;
                }
                System.out.println("Parameter : " + param.getName().getLocalPart() + ", mode=" + param.getMode().toString() + ", is not considered");
            }
            if (this.wsdlOperation.getReturnType() != null) {
                ComplexType type;
                this.outWsdlParamContainer = new WsdlOpParameterContainer((WsdlOpParameter)this.wsdlOperation.getReturnType());
                if (this.wsdlOperation.getReturnType().isArray() && this.wsdlOperation.getReturnType().getItemXmlType() != null && (type = this.wsdlOperation.getReturnType().getItemComplexType()) != null) {
                    for (String attributeName : type.listObjectNames()) {
                        QName attributeType = type.getElementType(attributeName);
                        if ("http://www.w3.org/2001/XMLSchema".equals(attributeType.getNamespaceURI())) continue;
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"WebServiceDialog.ERROR0007.UnsupportedOperation.ComplexType", (String[])new String[0]));
                    }
                }
            }
        }
    }

    private void initTreeTabWebService(String anURI) throws HopException {
        String text = this.wOperation.getText();
        this.loadWebService(anURI);
        this.selectWSDLOperation(text);
        if (this.wsdlOperation != null) {
            this.wOperation.setText(text);
        }
    }

    private void addTabFieldIn() {
        TableView oldTableView = this.fieldInTableView;
        int margin = this.props.getMargin();
        Composite vCompositeTabField = new Composite((Composite)this.wTabFolder, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        vCompositeTabField.setLayout((Layout)formLayout);
        this.props.setLook((Control)vCompositeTabField);
        if (this.tabItemFieldIn == null) {
            this.tabItemFieldIn = new CTabItem(this.wTabFolder, 0);
        }
        ColumnInfo fieldColumn = new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.NameColumn.Column", (String[])new String[0]), 2, new String[0], false);
        this.fieldColumns.add(fieldColumn);
        ColumnInfo[] colinf = new ColumnInfo[]{fieldColumn, new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.WsNameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.TypeColumn.Column", (String[])new String[0]), 1, false)};
        this.fieldInTableView = new TableView(this.variables, vCompositeTabField, 65538, colinf, 1, this.lsMod, this.props);
        this.fieldInTableView.setReadonly(false);
        this.fieldInTableView.clearAll();
        String containerName = this.inWsdlParamContainer == null ? this.meta.getInFieldContainerName() : this.inWsdlParamContainer.getContainerName();
        this.tabItemFieldIn.setText(containerName == null ? "in" : containerName);
        Button vButton = new Button(vCompositeTabField, 0);
        vButton.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        vButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IRowMeta r;
                if (WebServiceDialog.this.inWsdlParamContainer == null) {
                    try {
                        WebServiceDialog.this.loadWebService(WebServiceDialog.this.wURL.getText());
                        WebServiceDialog.this.loadOperation(WebServiceDialog.this.wOperation.getText());
                    }
                    catch (HopException e) {
                        e.printStackTrace();
                    }
                }
                if ((r = WebServiceDialog.this.getInWebServiceFields()) != null) {
                    BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)WebServiceDialog.this.fieldInTableView, (int)2, (int[])new int[]{2}, (int[])new int[0], (int)-1, (int)-1, null);
                }
                if (WebServiceDialog.this.inWsdlParamContainer != null) {
                    TableItem[] items;
                    for (TableItem item : items = WebServiceDialog.this.fieldInTableView.table.getItems()) {
                        String type = WebServiceDialog.this.inWsdlParamContainer.getParamType(item.getText(2));
                        if (type != null) {
                            item.setText(3, type);
                            continue;
                        }
                        item.dispose();
                    }
                }
            }
        });
        Button[] buttons = new Button[]{vButton};
        BaseTransformDialog.positionBottomButtons((Composite)vCompositeTabField, (Button[])buttons, (int)this.props.getMargin(), null);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(0, 0);
        fdTable.top = new FormAttachment(0, margin);
        fdTable.right = new FormAttachment(100, 0);
        fdTable.bottom = new FormAttachment((Control)vButton, 0);
        this.fieldInTableView.setLayoutData((Object)fdTable);
        FormData fdInComp = new FormData();
        fdInComp.left = new FormAttachment(0, 0);
        fdInComp.top = new FormAttachment(0, 0);
        fdInComp.right = new FormAttachment(100, 0);
        fdInComp.bottom = new FormAttachment(100, 0);
        vCompositeTabField.setLayoutData((Object)fdInComp);
        vCompositeTabField.layout();
        this.tabItemFieldIn.setControl((Control)vCompositeTabField);
        if (this.inWsdlParamContainer != null) {
            IRowMeta r = this.getInWebServiceFields();
            for (int i = 0; i < r.size(); ++i) {
                TableItem[] oldItems;
                String previousField;
                String wsName = r.getValueMeta(i).getName();
                TableItem vTableItem = new TableItem(this.fieldInTableView.table, 0);
                vTableItem.setText(2, Const.NVL((String)wsName, (String)""));
                vTableItem.setText(3, Const.NVL((String)this.inWsdlParamContainer.getParamType(wsName), (String)""));
                if (oldTableView == null || (previousField = this.getField(oldItems = oldTableView.table.getItems(), wsName)) == null) continue;
                vTableItem.setText(1, previousField);
            }
        }
        if (oldTableView != null) {
            oldTableView.dispose();
        }
        this.fieldInTableView.removeEmptyRows();
        this.fieldInTableView.setRowNums();
        this.fieldInTableView.optWidth(true);
    }

    private String getField(TableItem[] items, String wsName) {
        if (wsName == null) {
            return null;
        }
        String ret = null;
        for (int i = 0; i < items.length && ret == null; ++i) {
            if (!items[i].getText(2).equals(wsName)) continue;
            ret = items[i].getText(1);
        }
        return ret;
    }

    private void addTabFieldOut() {
        TableView oldTableView = this.fieldOutTableView;
        int margin = this.props.getMargin();
        Composite vCompositeTabFieldOut = new Composite((Composite)this.wTabFolder, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        vCompositeTabFieldOut.setLayout((Layout)formLayout);
        this.props.setLook((Control)vCompositeTabFieldOut);
        if (this.tabItemFieldOut == null) {
            this.tabItemFieldOut = new CTabItem(this.wTabFolder, 0);
        }
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.WsNameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"WebServiceDialog.TypeColumn.Column", (String[])new String[0]), 1, false)};
        this.fieldOutTableView = new TableView(this.variables, vCompositeTabFieldOut, 65538, colinf, 1, this.lsMod, this.props);
        String outContainerName = this.outWsdlParamContainer == null ? this.meta.getOutFieldContainerName() : this.outWsdlParamContainer.getContainerName();
        this.tabItemFieldOut.setText(outContainerName == null ? "out" : outContainerName);
        this.fieldOutTableView.setReadonly(false);
        Button vButton = new Button(vCompositeTabFieldOut, 0);
        vButton.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        vButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IRowMeta r;
                if (WebServiceDialog.this.outWsdlParamContainer == null) {
                    try {
                        WebServiceDialog.this.loadWebService(WebServiceDialog.this.wURL.getText());
                        WebServiceDialog.this.loadOperation(WebServiceDialog.this.wOperation.getText());
                    }
                    catch (HopException e) {
                        e.printStackTrace();
                    }
                }
                if ((r = WebServiceDialog.this.getOutWebServiceFields()) != null) {
                    BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)WebServiceDialog.this.fieldOutTableView, (int)2, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
                }
                if (WebServiceDialog.this.outWsdlParamContainer != null) {
                    TableItem[] items;
                    for (TableItem item : items = WebServiceDialog.this.fieldOutTableView.table.getItems()) {
                        item.setText(3, WebServiceDialog.this.outWsdlParamContainer.getParamType(item.getText(2)));
                    }
                }
            }
        });
        Button[] buttons = new Button[]{vButton};
        BaseTransformDialog.positionBottomButtons((Composite)vCompositeTabFieldOut, (Button[])buttons, (int)this.props.getMargin(), null);
        FormData fdTable = new FormData();
        fdTable.left = new FormAttachment(0, 0);
        fdTable.top = new FormAttachment(0, margin);
        fdTable.right = new FormAttachment(100, 0);
        fdTable.bottom = new FormAttachment((Control)vButton, 0);
        this.fieldOutTableView.setLayoutData((Object)fdTable);
        FormData fdInComp = new FormData();
        fdInComp.left = new FormAttachment(0, 0);
        fdInComp.top = new FormAttachment(0, 0);
        fdInComp.right = new FormAttachment(100, 0);
        fdInComp.bottom = new FormAttachment(100, 0);
        vCompositeTabFieldOut.setLayoutData((Object)fdInComp);
        vCompositeTabFieldOut.layout();
        this.tabItemFieldOut.setControl((Control)vCompositeTabFieldOut);
        if (this.fieldOutTableView.table.getItemCount() == 0 && this.outWsdlParamContainer != null) {
            IRowMeta r = this.getOutWebServiceFields();
            for (int i = 0; i < r.size(); ++i) {
                String wsName = r.getValueMeta(i).getName();
                String wsType = r.getValueMeta(i).getTypeDesc();
                TableItem vTableItem = new TableItem(this.fieldOutTableView.table, 0);
                vTableItem.setText(2, wsName);
                vTableItem.setText(3, wsType);
                if (oldTableView != null) {
                    String previousField = this.getField(oldTableView.table.getItems(), wsName);
                    if (previousField != null && !"".equals(previousField)) {
                        vTableItem.setText(1, previousField);
                        continue;
                    }
                    vTableItem.setText(1, wsName);
                    continue;
                }
                vTableItem.setText(1, wsName);
            }
        }
        this.fieldOutTableView.removeEmptyRows();
        this.fieldOutTableView.setRowNums();
        this.fieldOutTableView.optWidth(true);
    }

    private IRowMeta getInWebServiceFields() {
        RowMeta r = null;
        if (this.inWsdlParamContainer != null) {
            String[] params;
            r = new RowMeta();
            for (String param : params = this.inWsdlParamContainer.getParamNames()) {
                ValueMetaBase value = new ValueMetaBase(param, XsdType.xsdTypeToHopType(this.inWsdlParamContainer.getParamType(param)));
                r.addValueMeta((IValueMeta)value);
            }
        }
        return r;
    }

    private IRowMeta getOutWebServiceFields() {
        RowMeta r = null;
        if (this.outWsdlParamContainer != null) {
            String[] outParams;
            r = new RowMeta();
            for (String outParam : outParams = this.outWsdlParamContainer.getParamNames()) {
                ValueMetaBase value = new ValueMetaBase(outParam, XsdType.xsdTypeToHopType(this.outWsdlParamContainer.getParamType(outParam)));
                r.addValueMeta((IValueMeta)value);
            }
        }
        return r;
    }

    private void removeTabField(CTabItem tab) {
        if (tab != null) {
            tab.dispose();
            tab = null;
        }
    }

    private void getData() {
        TableItem vTableItem;
        this.wTransformName.setText(this.transformName);
        this.wURL.setText(this.meta.getUrl() == null ? "" : this.meta.getUrl());
        this.wProxyHost.setText(this.meta.getProxyHost() == null ? "" : this.meta.getProxyHost());
        this.wProxyPort.setText(this.meta.getProxyPort() == null ? "" : this.meta.getProxyPort());
        this.wHttpLogin.setText(this.meta.getHttpLogin() == null ? "" : this.meta.getHttpLogin());
        this.wHttpPassword.setText(this.meta.getHttpPassword() == null ? "" : this.meta.getHttpPassword());
        this.wBatchSize.setText(Integer.toString(this.meta.getCallTransform()));
        this.wPassInputData.setSelection(this.meta.isPassingInputData());
        this.wCompatible.setSelection(this.meta.isCompatible());
        this.wRepeatingElement.setText(Const.NVL((String)this.meta.getRepeatingElementName(), (String)""));
        this.wReplyAsString.setSelection(this.meta.isReturningReplyAsString());
        if (this.wURL.getText() != null && !"".equals(this.wURL.getText())) {
            this.wOperation.setText(this.meta.getOperationName() == null ? "" : this.meta.getOperationName());
        }
        this.wOperationRequest.setText(Const.NVL((String)this.meta.getOperationRequestName(), (String)""));
        if (this.meta.getInFieldContainerName() != null || this.meta.getInFieldArgumentName() != null || !this.meta.getFieldsIn().isEmpty()) {
            this.addTabFieldIn();
            for (WebServiceField field : this.meta.getFieldsIn()) {
                vTableItem = new TableItem(this.fieldInTableView.table, 0);
                if (field.getName() != null) {
                    vTableItem.setText(1, field.getName());
                }
                vTableItem.setText(2, field.getWsName());
                vTableItem.setText(3, field.getXsdType());
            }
            this.fieldInTableView.removeEmptyRows();
            this.fieldInTableView.setRowNums();
            this.fieldInTableView.optWidth(true);
        }
        if (!this.meta.getFieldsOut().isEmpty()) {
            this.addTabFieldOut();
            for (WebServiceField field : this.meta.getFieldsOut()) {
                vTableItem = new TableItem(this.fieldOutTableView.table, 0);
                if (field.getName() != null) {
                    vTableItem.setText(1, field.getName());
                }
                vTableItem.setText(2, field.getWsName());
                vTableItem.setText(3, field.getXsdType());
            }
            this.fieldOutTableView.removeEmptyRows();
            this.fieldOutTableView.setRowNums();
            this.fieldOutTableView.optWidth(true);
        }
    }

    private void getInfo(WebServiceMeta webServiceMeta) {
        WebServiceField field;
        TableItem vTableItem;
        int i;
        int nbRow;
        webServiceMeta.setUrl(this.wURL.getText());
        webServiceMeta.setProxyHost(this.wProxyHost.getText());
        webServiceMeta.setProxyPort(this.wProxyPort.getText());
        webServiceMeta.setHttpLogin(this.wHttpLogin.getText());
        webServiceMeta.setHttpPassword(this.wHttpPassword.getText());
        webServiceMeta.setCallTransform(Const.toInt((String)this.wBatchSize.getText(), (int)1000));
        webServiceMeta.setPassingInputData(this.wPassInputData.getSelection());
        webServiceMeta.setCompatible(this.wCompatible.getSelection());
        webServiceMeta.setRepeatingElementName(this.wRepeatingElement.getText());
        webServiceMeta.setReturningReplyAsString(this.wReplyAsString.getSelection());
        webServiceMeta.setOperationRequestName(this.wOperationRequest.getText());
        webServiceMeta.setOperationName(this.wOperation.getText());
        if (this.wsdlOperation != null) {
            webServiceMeta.setOperationName(this.wsdlOperation.getOperationQName().getLocalPart());
            webServiceMeta.setOperationNamespace(this.wsdlOperation.getOperationQName().getNamespaceURI());
        } else if (this.wsdl != null) {
            webServiceMeta.setOperationName(null);
            webServiceMeta.setOperationNamespace(null);
        }
        if (this.inWsdlParamContainer != null) {
            webServiceMeta.setInFieldContainerName(this.inWsdlParamContainer.getContainerName());
            webServiceMeta.setInFieldArgumentName(this.inWsdlParamContainer.getItemName());
        } else if (this.wsdl != null) {
            webServiceMeta.setInFieldContainerName(null);
            webServiceMeta.setInFieldArgumentName(null);
        }
        if (this.outWsdlParamContainer != null) {
            webServiceMeta.setOutFieldContainerName(this.outWsdlParamContainer.getContainerName());
            webServiceMeta.setOutFieldArgumentName(this.outWsdlParamContainer.getItemName());
        } else if (this.wsdl != null) {
            webServiceMeta.setOutFieldContainerName(null);
            webServiceMeta.setOutFieldArgumentName(null);
        }
        webServiceMeta.getFieldsIn().clear();
        if (this.tabItemFieldIn != null) {
            nbRow = this.fieldInTableView.nrNonEmpty();
            for (i = 0; i < nbRow; ++i) {
                vTableItem = this.fieldInTableView.getNonEmpty(i);
                field = new WebServiceField();
                field.setName(vTableItem.getText(1));
                field.setWsName(vTableItem.getText(2));
                field.setXsdType(Const.NVL((String)vTableItem.getText(3), (String)"String"));
                webServiceMeta.addFieldIn(field);
            }
        }
        webServiceMeta.getFieldsOut().clear();
        if (this.tabItemFieldOut != null) {
            nbRow = this.fieldOutTableView.nrNonEmpty();
            for (i = 0; i < nbRow; ++i) {
                vTableItem = this.fieldOutTableView.getNonEmpty(i);
                if ("".equals(vTableItem.getText(1))) continue;
                field = new WebServiceField();
                field.setName(vTableItem.getText(1));
                field.setWsName(vTableItem.getText(2));
                field.setXsdType(vTableItem.getText(3));
                webServiceMeta.addFieldOut(field);
            }
        }
    }

    public WebServiceDialog(Shell aShell, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(aShell, variables, (ITransformMeta)in, pipelineMeta, sname);
        this.meta = (WebServiceMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        Button wAddInput = new Button((Composite)this.shell, 8);
        wAddInput.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Label.AddInputButton", (String[])new String[0]));
        wAddInput.addListener(13, e -> {
            this.addTabFieldIn();
            this.wTabFolder.setSelection(this.tabItemFieldIn);
        });
        Button wAddOutput = new Button((Composite)this.shell, 8);
        wAddOutput.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Label.AddOutputButton", (String[])new String[0]));
        wAddOutput.addListener(13, e -> {
            this.addTabFieldOut();
            this.wTabFolder.setSelection(this.tabItemFieldOut);
        });
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, wAddInput, wAddOutput, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        CTabItem tabItemWebService = new CTabItem(this.wTabFolder, 0);
        tabItemWebService.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.MainTab.TabTitle", (String[])new String[0]));
        Composite compositeTabWebService = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)compositeTabWebService);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        compositeTabWebService.setLayout((Layout)fileLayout);
        Label wlURL = new Label(compositeTabWebService, 131072);
        wlURL.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.URL.Label", (String[])new String[0]));
        this.props.setLook((Control)wlURL);
        FormData fdlURL = new FormData();
        fdlURL.left = new FormAttachment(0, 0);
        fdlURL.top = new FormAttachment(0, margin);
        fdlURL.right = new FormAttachment(middle, -margin);
        wlURL.setLayoutData((Object)fdlURL);
        Button wbURL = new Button(compositeTabWebService, 0x1000008);
        this.props.setLook((Control)wbURL);
        wbURL.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.URL.Load", (String[])new String[0]));
        FormData fdbURL = new FormData();
        fdbURL.right = new FormAttachment(100, 0);
        fdbURL.top = new FormAttachment(0, 0);
        wbURL.setLayoutData((Object)fdbURL);
        wbURL.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!Utils.isEmpty((CharSequence)WebServiceDialog.this.wURL.getText())) {
                    try {
                        WebServiceDialog.this.initTreeTabWebService(WebServiceDialog.this.wURL.getText());
                    }
                    catch (Throwable throwable) {
                        new ErrorDialog(WebServiceDialog.this.shell, BaseMessages.getString(PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Message", (String[])new String[0]), throwable);
                    }
                }
            }
        });
        Button wbFile = new Button(compositeTabWebService, 0x1000008);
        this.props.setLook((Control)wbFile);
        wbFile.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.File.Load", (String[])new String[0]));
        FormData fdbFile = new FormData();
        fdbFile.right = new FormAttachment((Control)wbURL, 0);
        fdbFile.top = new FormAttachment(0, 0);
        wbFile.setLayoutData((Object)fdbFile);
        wbFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(WebServiceDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.wsdl;*.WSDL", "*.*"});
                dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"WebServiceDialog.FileType.WsdlFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String filename = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    try {
                        WebServiceDialog.this.initTreeTabWebService(new File(filename).toURI().toASCIIString());
                    }
                    catch (Throwable throwable) {
                        new ErrorDialog(WebServiceDialog.this.shell, BaseMessages.getString(PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"WebServiceDialog.Exception.UnableToLoadWebService.Message", (String[])new String[0]), throwable);
                    }
                }
            }
        });
        this.wURL = new TextVar(this.variables, compositeTabWebService, 18436);
        this.wURL.addModifyListener(this.lsMod);
        this.props.setLook((Control)this.wURL);
        FormData fdURL = new FormData();
        fdURL.left = new FormAttachment(middle, 0);
        fdURL.top = new FormAttachment(0, margin);
        fdURL.right = new FormAttachment((Control)wbFile, -margin);
        this.wURL.setLayoutData((Object)fdURL);
        Label wlOperation = new Label(compositeTabWebService, 131072);
        wlOperation.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOperation);
        FormData fdlOperation = new FormData();
        fdlOperation.left = new FormAttachment(0, 0);
        fdlOperation.top = new FormAttachment((Control)this.wURL, margin);
        fdlOperation.right = new FormAttachment(middle, -margin);
        wlOperation.setLayoutData((Object)fdlOperation);
        this.wOperation = new CCombo(compositeTabWebService, 18436);
        this.wOperation.addModifyListener(this.lsMod);
        this.wOperation.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Operation.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOperation);
        FormData fdOperation = new FormData();
        fdOperation.top = new FormAttachment((Control)this.wURL, margin);
        fdOperation.left = new FormAttachment(middle, 0);
        fdOperation.right = new FormAttachment(100, 0);
        this.wOperation.setLayoutData((Object)fdOperation);
        this.wOperation.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    WebServiceDialog.this.selectWSDLOperation(WebServiceDialog.this.wOperation.getText());
                }
                catch (HopException e) {
                    e.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Label wlOperationRequest = new Label(compositeTabWebService, 131072);
        wlOperationRequest.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.OperationRequest.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOperationRequest);
        FormData fdlOperationRequest = new FormData();
        fdlOperationRequest.left = new FormAttachment(0, 0);
        fdlOperationRequest.top = new FormAttachment((Control)this.wOperation, margin);
        fdlOperationRequest.right = new FormAttachment(middle, -margin);
        wlOperationRequest.setLayoutData((Object)fdlOperationRequest);
        this.wOperationRequest = new Text(compositeTabWebService, 18436);
        this.wOperationRequest.addModifyListener(this.lsMod);
        this.wOperationRequest.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.OperationRequest.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOperationRequest);
        FormData fdOperationRequest = new FormData();
        fdOperationRequest.top = new FormAttachment((Control)this.wOperation, margin);
        fdOperationRequest.left = new FormAttachment(middle, 0);
        fdOperationRequest.right = new FormAttachment(100, 0);
        this.wOperationRequest.setLayoutData((Object)fdOperationRequest);
        this.wlBatchSize = new Label(compositeTabWebService, 131072);
        this.wlBatchSize.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Transform.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBatchSize);
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment((Control)this.wOperationRequest, margin);
        fdlBatchSize.right = new FormAttachment(middle, -margin);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new Text(compositeTabWebService, 18436);
        this.wBatchSize.addModifyListener(this.lsMod);
        this.wBatchSize.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Transform.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wBatchSize);
        FormData fdBatchSize = new FormData();
        fdBatchSize.top = new FormAttachment((Control)this.wOperationRequest, margin);
        fdBatchSize.left = new FormAttachment(middle, 0);
        fdBatchSize.right = new FormAttachment(100, 0);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        Label wlPassInputData = new Label(compositeTabWebService, 131072);
        wlPassInputData.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.PassInputData.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPassInputData);
        FormData fdlPassInputData = new FormData();
        fdlPassInputData.left = new FormAttachment(0, 0);
        fdlPassInputData.top = new FormAttachment((Control)this.wBatchSize, margin);
        fdlPassInputData.right = new FormAttachment(middle, -margin);
        wlPassInputData.setLayoutData((Object)fdlPassInputData);
        this.wPassInputData = new Button(compositeTabWebService, 32);
        this.wPassInputData.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.PassInputData.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPassInputData);
        FormData fdPassInputData = new FormData();
        fdPassInputData.top = new FormAttachment((Control)wlPassInputData, 0, 0x1000000);
        fdPassInputData.left = new FormAttachment(middle, 0);
        fdPassInputData.right = new FormAttachment(100, 0);
        this.wPassInputData.setLayoutData((Object)fdPassInputData);
        Label wlCompatible = new Label(compositeTabWebService, 131072);
        wlCompatible.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Compatible.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCompatible);
        FormData fdlCompatible = new FormData();
        fdlCompatible.left = new FormAttachment(0, 0);
        fdlCompatible.top = new FormAttachment((Control)wlPassInputData, 2 * margin);
        fdlCompatible.right = new FormAttachment(middle, -margin);
        wlCompatible.setLayoutData((Object)fdlCompatible);
        this.wCompatible = new Button(compositeTabWebService, 32);
        this.wCompatible.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.Compatible.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompatible);
        FormData fdCompatible = new FormData();
        fdCompatible.top = new FormAttachment((Control)wlCompatible, 0, 0x1000000);
        fdCompatible.left = new FormAttachment(middle, 0);
        fdCompatible.right = new FormAttachment(100, 0);
        this.wCompatible.setLayoutData((Object)fdCompatible);
        Label wlRepeatingElement = new Label(compositeTabWebService, 131072);
        wlRepeatingElement.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.RepeatingElement.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRepeatingElement);
        FormData fdlRepeatingElement = new FormData();
        fdlRepeatingElement.top = new FormAttachment((Control)wlCompatible, 2 * margin);
        fdlRepeatingElement.left = new FormAttachment(0, 0);
        fdlRepeatingElement.right = new FormAttachment(middle, -margin);
        wlRepeatingElement.setLayoutData((Object)fdlRepeatingElement);
        this.wRepeatingElement = new TextVar(this.variables, compositeTabWebService, 18436);
        this.wRepeatingElement.addModifyListener(this.lsMod);
        this.wRepeatingElement.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.RepeatingElement.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRepeatingElement);
        FormData fdRepeatingElement = new FormData();
        fdRepeatingElement.top = new FormAttachment((Control)wlRepeatingElement, 0, 0x1000000);
        fdRepeatingElement.left = new FormAttachment(middle, 0);
        fdRepeatingElement.right = new FormAttachment(100, 0);
        this.wRepeatingElement.setLayoutData((Object)fdRepeatingElement);
        Label wlReplyAsString = new Label(compositeTabWebService, 131072);
        wlReplyAsString.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ReplyAsString.Label", (String[])new String[0]));
        this.props.setLook((Control)wlReplyAsString);
        FormData fdlBodyAsString = new FormData();
        fdlBodyAsString.left = new FormAttachment(0, 0);
        fdlBodyAsString.top = new FormAttachment((Control)this.wRepeatingElement, margin);
        fdlBodyAsString.right = new FormAttachment(middle, -margin);
        wlReplyAsString.setLayoutData((Object)fdlBodyAsString);
        this.wReplyAsString = new Button(compositeTabWebService, 32);
        this.wReplyAsString.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ReplyAsString.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReplyAsString);
        FormData fdBodyAsString = new FormData();
        fdBodyAsString.top = new FormAttachment((Control)wlReplyAsString, 0, 0x1000000);
        fdBodyAsString.left = new FormAttachment(middle, 0);
        fdBodyAsString.right = new FormAttachment(100, 0);
        this.wReplyAsString.setLayoutData((Object)fdBodyAsString);
        Group gHttpAuth = new Group(compositeTabWebService, 16);
        gHttpAuth.setText(BaseMessages.getString(PKG, (String)"WebServicesDialog.HttpAuthGroup.Label", (String[])new String[0]));
        FormLayout httpAuthLayout = new FormLayout();
        httpAuthLayout.marginWidth = 3;
        httpAuthLayout.marginHeight = 3;
        gHttpAuth.setLayout((Layout)httpAuthLayout);
        this.props.setLook((Control)gHttpAuth);
        Label wlHttpLogin = new Label((Composite)gHttpAuth, 131072);
        wlHttpLogin.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpLogin.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHttpLogin);
        FormData fdlHttpLogin = new FormData();
        fdlHttpLogin.top = new FormAttachment(0, margin);
        fdlHttpLogin.left = new FormAttachment(0, 0);
        fdlHttpLogin.right = new FormAttachment(middle, -margin);
        wlHttpLogin.setLayoutData((Object)fdlHttpLogin);
        this.wHttpLogin = new TextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpLogin.addModifyListener(this.lsMod);
        this.wHttpLogin.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpLogin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHttpLogin);
        FormData fdHttpLogin = new FormData();
        fdHttpLogin.top = new FormAttachment(0, margin);
        fdHttpLogin.left = new FormAttachment(middle, 0);
        fdHttpLogin.right = new FormAttachment(100, 0);
        this.wHttpLogin.setLayoutData((Object)fdHttpLogin);
        Label wlHttpPassword = new Label((Composite)gHttpAuth, 131072);
        wlHttpPassword.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpPassword.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHttpPassword);
        FormData fdlHttpPassword = new FormData();
        fdlHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdlHttpPassword.left = new FormAttachment(0, 0);
        fdlHttpPassword.right = new FormAttachment(middle, -margin);
        wlHttpPassword.setLayoutData((Object)fdlHttpPassword);
        this.wHttpPassword = new PasswordTextVar(this.variables, (Composite)gHttpAuth, 18436);
        this.wHttpPassword.addModifyListener(this.lsMod);
        this.wHttpPassword.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.HttpPassword.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wHttpPassword);
        FormData fdHttpPassword = new FormData();
        fdHttpPassword.top = new FormAttachment((Control)this.wHttpLogin, margin);
        fdHttpPassword.left = new FormAttachment(middle, 0);
        fdHttpPassword.right = new FormAttachment(100, 0);
        this.wHttpPassword.setLayoutData((Object)fdHttpPassword);
        FormData fdHttpAuth = new FormData();
        fdHttpAuth.left = new FormAttachment(0, 0);
        fdHttpAuth.right = new FormAttachment(100, 0);
        fdHttpAuth.top = new FormAttachment((Control)this.wReplyAsString, margin);
        gHttpAuth.setLayoutData((Object)fdHttpAuth);
        Group gProxy = new Group(compositeTabWebService, 16);
        gProxy.setText(BaseMessages.getString(PKG, (String)"WebServicesDialog.ProxyGroup.Label", (String[])new String[0]));
        FormLayout proxyLayout = new FormLayout();
        proxyLayout.marginWidth = 3;
        proxyLayout.marginHeight = 3;
        gProxy.setLayout((Layout)proxyLayout);
        this.props.setLook((Control)gProxy);
        Label wlProxyHost = new Label((Composite)gProxy, 131072);
        wlProxyHost.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyHost.Label", (String[])new String[0]));
        this.props.setLook((Control)wlProxyHost);
        FormData fdlProxyHost = new FormData();
        fdlProxyHost.top = new FormAttachment(0, margin);
        fdlProxyHost.left = new FormAttachment(0, 0);
        fdlProxyHost.right = new FormAttachment(middle, -margin);
        wlProxyHost.setLayoutData((Object)fdlProxyHost);
        this.wProxyHost = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyHost.addModifyListener(this.lsMod);
        this.wProxyHost.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyHost.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyHost);
        FormData fdProxyHost = new FormData();
        fdProxyHost.top = new FormAttachment(0, margin);
        fdProxyHost.left = new FormAttachment(middle, 0);
        fdProxyHost.right = new FormAttachment(100, 0);
        this.wProxyHost.setLayoutData((Object)fdProxyHost);
        Label wlProxyPort = new Label((Composite)gProxy, 131072);
        wlProxyPort.setText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyPort.Label", (String[])new String[0]));
        this.props.setLook((Control)wlProxyPort);
        FormData fdlProxyPort = new FormData();
        fdlProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdlProxyPort.left = new FormAttachment(0, 0);
        fdlProxyPort.right = new FormAttachment(middle, -margin);
        wlProxyPort.setLayoutData((Object)fdlProxyPort);
        this.wProxyPort = new TextVar(this.variables, (Composite)gProxy, 18436);
        this.wProxyPort.addModifyListener(this.lsMod);
        this.wProxyPort.setToolTipText(BaseMessages.getString(PKG, (String)"WebServiceDialog.ProxyPort.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wProxyPort);
        FormData fdProxyPort = new FormData();
        fdProxyPort.top = new FormAttachment((Control)this.wProxyHost, margin);
        fdProxyPort.left = new FormAttachment(middle, 0);
        fdProxyPort.right = new FormAttachment(100, 0);
        this.wProxyPort.setLayoutData((Object)fdProxyPort);
        FormData fdProxy = new FormData();
        fdProxy.left = new FormAttachment(0, 0);
        fdProxy.right = new FormAttachment(100, 0);
        fdProxy.top = new FormAttachment((Control)gHttpAuth, margin);
        gProxy.setLayoutData((Object)fdProxy);
        FormData fdFileComp = new FormData();
        fdFileComp.left = new FormAttachment(0, 0);
        fdFileComp.top = new FormAttachment(0, 0);
        fdFileComp.right = new FormAttachment(100, 0);
        fdFileComp.bottom = new FormAttachment(100, 0);
        compositeTabWebService.setLayoutData((Object)fdFileComp);
        compositeTabWebService.layout();
        tabItemWebService.setControl((Control)compositeTabWebService);
        this.wURL.addListener(13, e -> this.getData());
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WebServiceDialog.this.ok();
            }
        };
        this.wHttpPassword.addSelectionListener(selAdapter);
        this.wHttpLogin.addSelectionListener(selAdapter);
        this.wBatchSize.addSelectionListener((SelectionListener)selAdapter);
        this.wProxyHost.addSelectionListener(selAdapter);
        this.wProxyPort.addSelectionListener(selAdapter);
        this.wTransformName.addSelectionListener((SelectionListener)selAdapter);
        this.wTabFolder.setSelection(tabItemWebService);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.setComboValues();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.meta);
        this.dispose();
    }

    private void cancel() {
        this.transformName = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    private void setComboValues() {
        Runnable fieldLoader = () -> {
            try {
                this.prevFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            }
            catch (HopException e) {
                this.prevFields = new RowMeta();
                String msg = BaseMessages.getString(PKG, (String)"SelectValuesDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                this.logError(msg);
            }
            Object[] prevTransformFieldNames = this.prevFields.getFieldNames();
            Arrays.sort(prevTransformFieldNames);
            for (ColumnInfo colInfo : this.fieldColumns) {
                colInfo.setComboValues((String[])prevTransformFieldNames);
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

