/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.NoSuchElementException;
import org.apache.beam.model.pipeline.v1.MetricsApi;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;

public class ShortIdMap {
    private int counter = 0;
    private BiMap<String, MetricsApi.MonitoringInfo> monitoringInfoMap = HashBiMap.create();

    public synchronized String getOrCreateShortId(MetricsApi.MonitoringInfo info) {
        Preconditions.checkNotNull((Object)info);
        Preconditions.checkArgument((boolean)info.getPayload().isEmpty());
        Preconditions.checkArgument((!info.hasStartTime() ? 1 : 0) != 0);
        String shortId = (String)this.monitoringInfoMap.inverse().get((Object)info);
        if (shortId == null) {
            shortId = "metric" + this.counter++;
            this.monitoringInfoMap.put((Object)shortId, (Object)info);
        }
        return shortId;
    }

    public synchronized MetricsApi.MonitoringInfo get(String shortId) {
        MetricsApi.MonitoringInfo monitoringInfo = (MetricsApi.MonitoringInfo)this.monitoringInfoMap.get((Object)shortId);
        if (monitoringInfo == null) {
            throw new NoSuchElementException(shortId);
        }
        return monitoringInfo;
    }
}

