/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs;

import com.microsoft.azure.eventhubs.ProxyConfiguration;
import com.microsoft.azure.eventhubs.RetryPolicy;
import com.microsoft.azure.eventhubs.TransportType;
import java.time.Duration;

public class EventHubClientOptions {
    public static final Duration SILENT_OFF = Duration.ofSeconds(0L);
    public static final Duration SILENT_MINIMUM = Duration.ofSeconds(30L);
    private Duration operationTimeout = null;
    private TransportType transportType = null;
    private RetryPolicy retryPolicy = null;
    private ProxyConfiguration proxyConfiguration = null;
    private Duration maximumSilentTime = SILENT_OFF;

    public EventHubClientOptions setOperationTimeout(Duration operationTimeout) {
        this.operationTimeout = operationTimeout;
        return this;
    }

    public Duration getOperationTimeout() {
        return this.operationTimeout;
    }

    public EventHubClientOptions setTransportType(TransportType transportType) {
        this.transportType = transportType;
        return this;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public EventHubClientOptions setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        return this;
    }

    public RetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    public EventHubClientOptions setProxyConfiguration(ProxyConfiguration proxyConfiguration) {
        this.proxyConfiguration = proxyConfiguration;
        return this;
    }

    public ProxyConfiguration getProxyConfiguration() {
        return this.proxyConfiguration;
    }

    public EventHubClientOptions setMaximumSilentTime(Duration maximumSilentTime) {
        if (maximumSilentTime.compareTo(SILENT_MINIMUM) < 0) {
            throw new IllegalArgumentException("Maximum silent time must be at least " + SILENT_MINIMUM.toMillis() + " milliseconds");
        }
        this.maximumSilentTime = maximumSilentTime;
        return this;
    }

    public Duration getMaximumSilentTime() {
        return this.maximumSilentTime;
    }
}

