/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.core.InternalApi;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.SpannerExceptionFactory;
import com.google.cloud.spanner.connection.AbstractStatementParser;
import com.google.common.base.Preconditions;

@InternalApi
public class PostgreSQLStatementParser
extends AbstractStatementParser {
    PostgreSQLStatementParser() {
        super(Dialect.POSTGRESQL);
    }

    @Override
    protected boolean supportsExplain() {
        return false;
    }

    @Override
    @InternalApi
    String removeCommentsAndTrimInternal(String sql) {
        Preconditions.checkNotNull((Object)sql);
        String currentTag = null;
        boolean isInQuoted = false;
        boolean isInSingleLineComment = false;
        int multiLineCommentLevel = 0;
        char startQuote = '\u0000';
        boolean lastCharWasEscapeChar = false;
        StringBuilder res = new StringBuilder(sql.length());
        for (int index = 0; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (isInQuoted) {
                if ((c == '\n' || c == '\r') && startQuote != '$') {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
                }
                if (c == startQuote) {
                    if (c == '$') {
                        String tag = this.parseDollarQuotedString(sql, index + 1);
                        if (tag != null && tag.equals(currentTag)) {
                            index += tag.length() + 1;
                            res.append(c);
                            res.append(tag);
                            isInQuoted = false;
                            startQuote = '\u0000';
                        }
                    } else if (lastCharWasEscapeChar) {
                        lastCharWasEscapeChar = false;
                    } else if (sql.length() > index + 1 && sql.charAt(index + 1) == startQuote) {
                        res.append(c);
                        ++index;
                    } else {
                        isInQuoted = false;
                        startQuote = '\u0000';
                    }
                } else {
                    lastCharWasEscapeChar = c == '\\';
                }
                res.append(c);
                continue;
            }
            if (isInSingleLineComment) {
                if (c != '\n') continue;
                isInSingleLineComment = false;
                res.append(c);
                continue;
            }
            if (multiLineCommentLevel > 0) {
                if (sql.length() > index + 1 && c == '*' && sql.charAt(index + 1) == '/') {
                    --multiLineCommentLevel;
                    ++index;
                    continue;
                }
                if (sql.length() <= index + 1 || c != '/' || sql.charAt(index + 1) != '*') continue;
                ++multiLineCommentLevel;
                ++index;
                continue;
            }
            if (sql.length() > index + 1 && c == '-' && sql.charAt(index + 1) == '-') {
                isInSingleLineComment = true;
                continue;
            }
            if (sql.length() > index + 1 && c == '/' && sql.charAt(index + 1) == '*') {
                ++multiLineCommentLevel;
                ++index;
                continue;
            }
            if (c == '\'' || c == '\"') {
                isInQuoted = true;
                startQuote = c;
            } else if (c == '$' && (currentTag = this.parseDollarQuotedString(sql, index + 1)) != null) {
                isInQuoted = true;
                startQuote = '$';
                index += currentTag.length() + 1;
                res.append(c);
                res.append(currentTag);
            }
            res.append(c);
        }
        if (isInQuoted) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
        }
        if (multiLineCommentLevel > 0) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unterminated block comment: " + sql);
        }
        if (res.length() > 0 && res.charAt(res.length() - 1) == ';') {
            res.deleteCharAt(res.length() - 1);
        }
        return res.toString().trim();
    }

    String parseDollarQuotedString(String sql, int index) {
        StringBuilder tag = new StringBuilder();
        while (index < sql.length()) {
            char c = sql.charAt(index);
            if (c == '$') {
                return tag.toString();
            }
            if (!Character.isJavaIdentifierPart(c)) break;
            tag.append(c);
            ++index;
        }
        return null;
    }

    @Override
    String removeStatementHint(String sql) {
        return sql;
    }

    @Override
    @InternalApi
    AbstractStatementParser.ParametersInfo convertPositionalParametersToNamedParametersInternal(char paramChar, String sql) {
        Preconditions.checkNotNull((Object)sql);
        String namedParamPrefix = "$";
        String currentTag = null;
        boolean isInQuoted = false;
        char startQuote = '\u0000';
        boolean lastCharWasEscapeChar = false;
        StringBuilder named = new StringBuilder(sql.length() + PostgreSQLStatementParser.countOccurrencesOf(paramChar, sql));
        int paramIndex = 1;
        for (int index = 0; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            if (isInQuoted) {
                if ((c == '\n' || c == '\r') && startQuote != '$') {
                    throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
                }
                if (c == startQuote) {
                    if (c == '$') {
                        String tag = this.parseDollarQuotedString(sql, index + 1);
                        if (tag != null && tag.equals(currentTag)) {
                            index += tag.length() + 1;
                            named.append(c);
                            named.append(tag);
                            isInQuoted = false;
                            startQuote = '\u0000';
                        }
                    } else if (lastCharWasEscapeChar) {
                        lastCharWasEscapeChar = false;
                    } else if (sql.length() > index + 1 && sql.charAt(index + 1) == startQuote) {
                        named.append(c);
                        ++index;
                    } else {
                        isInQuoted = false;
                        startQuote = '\u0000';
                    }
                } else {
                    lastCharWasEscapeChar = c == '\\';
                }
                named.append(c);
                continue;
            }
            if (c == paramChar) {
                named.append("$" + paramIndex);
                ++paramIndex;
                continue;
            }
            if (c == '\'' || c == '\"') {
                isInQuoted = true;
                startQuote = c;
            } else if (c == '$' && (currentTag = this.parseDollarQuotedString(sql, index + 1)) != null) {
                isInQuoted = true;
                startQuote = '$';
                index += currentTag.length() + 1;
                named.append(c);
                named.append(currentTag);
            }
            named.append(c);
        }
        if (isInQuoted) {
            throw SpannerExceptionFactory.newSpannerException(ErrorCode.INVALID_ARGUMENT, "SQL statement contains an unclosed literal: " + sql);
        }
        return new AbstractStatementParser.ParametersInfo(paramIndex - 1, named.toString());
    }
}

