/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spanner.connection;

import com.google.api.gax.longrunning.OperationFuture;
import com.google.cloud.spanner.DatabaseAdminClient;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.spanner.admin.database.v1.UpdateDatabaseDdlMetadata;
import java.util.Collections;
import java.util.List;

class DdlClient {
    private final DatabaseAdminClient dbAdminClient;
    private final String instanceId;
    private final String databaseName;

    static Builder newBuilder() {
        return new Builder();
    }

    private DdlClient(Builder builder) {
        this.dbAdminClient = builder.dbAdminClient;
        this.instanceId = builder.instanceId;
        this.databaseName = builder.databaseName;
    }

    OperationFuture<Void, UpdateDatabaseDdlMetadata> executeDdl(String ddl) {
        return this.executeDdl(Collections.singletonList(ddl));
    }

    OperationFuture<Void, UpdateDatabaseDdlMetadata> executeDdl(List<String> statements) {
        return this.dbAdminClient.updateDatabaseDdl(this.instanceId, this.databaseName, statements, null);
    }

    static class Builder {
        private DatabaseAdminClient dbAdminClient;
        private String instanceId;
        private String databaseName;

        private Builder() {
        }

        Builder setDatabaseAdminClient(DatabaseAdminClient client) {
            Preconditions.checkNotNull((Object)client);
            this.dbAdminClient = client;
            return this;
        }

        Builder setInstanceId(String instanceId) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"Empty instanceId is not allowed");
            this.instanceId = instanceId;
            return this;
        }

        Builder setDatabaseName(String name) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Empty database name is not allowed");
            this.databaseName = name;
            return this;
        }

        DdlClient build() {
            Preconditions.checkState((this.dbAdminClient != null ? 1 : 0) != 0, (Object)"No DatabaseAdminClient specified");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)this.instanceId) ? 1 : 0) != 0, (Object)"No InstanceId specified");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.databaseName) ? 1 : 0) != 0, (Object)"No database name specified");
            return new DdlClient(this);
        }
    }
}

