/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrodecode;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.avro.transforms.avrodecode.AvroDecode;
import org.apache.hop.avro.transforms.avrodecode.AvroDecodeMeta;
import org.apache.hop.avro.transforms.avrodecode.TargetField;
import org.apache.hop.avro.transforms.avroinput.AvroFileInputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMetaBuilder;
import org.apache.hop.core.row.value.ValueMetaAvroRecord;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.RowProducer;
import org.apache.hop.pipeline.engine.IEngineComponent;
import org.apache.hop.pipeline.engines.local.LocalPipelineEngine;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.IRowListener;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.RowAdapter;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.injector.InjectorField;
import org.apache.hop.pipeline.transforms.injector.InjectorMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AvroDecodeDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = AvroDecodeMeta.class;
    private AvroDecodeMeta input;
    private Combo wSourceField;
    private TableView wFields;
    private RowProducer rowProducer;

    public AvroDecodeDialog(Shell parent, IVariables variables, Object baseTransformMeta, PipelineMeta pipelineMeta, String transformName) {
        super(parent, variables, (BaseTransformMeta)baseTransformMeta, pipelineMeta, transformName);
        this.input = (AvroDecodeMeta)((Object)baseTransformMeta);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getFields());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlSourceField = new Label((Composite)this.shell, 131072);
        wlSourceField.setText(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.SourceField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSourceField);
        FormData fdlSourceField = new FormData();
        fdlSourceField.left = new FormAttachment(0, 0);
        fdlSourceField.right = new FormAttachment(middle, -margin);
        fdlSourceField.top = new FormAttachment((Control)lastControl, margin * 2);
        wlSourceField.setLayoutData((Object)fdlSourceField);
        this.wSourceField = new Combo((Composite)this.shell, 18436);
        this.wSourceField.setText(this.transformName);
        this.props.setLook((Control)this.wSourceField);
        FormData fdSourceField = new FormData();
        fdSourceField.left = new FormAttachment(middle, 0);
        fdSourceField.top = new FormAttachment((Control)wlSourceField, 0, 0x1000000);
        fdSourceField.right = new FormAttachment(100, 0);
        this.wSourceField.setLayoutData((Object)fdSourceField);
        lastControl = this.wSourceField;
        Label wlFields = new Label((Composite)this.shell, 16384);
        wlFields.setText(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)lastControl, margin);
        wlFields.setLayoutData((Object)fdlFields);
        ColumnInfo[] fieldsColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Column.SourceField", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Column.SourceType", (String[])new String[0]), 2, new String[]{"String", "Int", "Long", "Float", "Double", "Boolean", "Bytes", "Null", "Record", "Enum", "Array", "Map", "Union", "Fixed"}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Column.TargetField", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Column.TargetType", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Column.TargetFormat", (String[])new String[0]), 2, Const.getConversionFormats(), false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Column.TargetLength", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AvroDecodeDialog.Fields.Column.TargetPrecision", (String[])new String[0]), 1, false, false)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 0, fieldsColumns, this.input.getTargetFields().size(), false, null, this.props);
        this.props.setLook((Control)this.wFields);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        try {
            this.wSourceField.setItems(this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta).getFieldNames());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.wSourceField.setText(Const.NVL((String)this.input.getSourceFieldName(), (String)""));
        int rowNr = 0;
        for (TargetField targetField : this.input.getTargetFields()) {
            TableItem item = this.wFields.table.getItem(rowNr++);
            int col = 1;
            item.setText(col++, Const.NVL((String)targetField.getSourceField(), (String)""));
            item.setText(col++, Const.NVL((String)targetField.getSourceAvroType(), (String)""));
            item.setText(col++, Const.NVL((String)targetField.getTargetFieldName(), (String)""));
            item.setText(col++, Const.NVL((String)targetField.getTargetType(), (String)""));
            item.setText(col++, Const.NVL((String)targetField.getTargetFormat(), (String)""));
            item.setText(col++, Const.NVL((String)targetField.getTargetLength(), (String)""));
            item.setText(col++, Const.NVL((String)targetField.getTargetPrecision(), (String)""));
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setSourceFieldName(this.wSourceField.getText());
        this.input.getTargetFields().clear();
        for (TableItem item : this.wFields.getNonEmptyItems()) {
            int col = 1;
            String sourceField = item.getText(col++);
            String sourceType = item.getText(col++);
            String targetField = item.getText(col++);
            String targetType = item.getText(col++);
            String targetFormat = item.getText(col++);
            String targetLength = item.getText(col++);
            String targetPrecision = item.getText(col);
            this.input.getTargetFields().add(new TargetField(sourceField, sourceType, targetField, targetType, targetFormat, targetLength, targetPrecision));
        }
        this.transformName = this.wTransformName.getText();
        this.transformMeta.setChanged();
        this.dispose();
    }

    private void getFields() {
        try {
            String filename;
            Schema schema;
            IRowMeta fields;
            IValueMeta valueMeta;
            final HashMap<String, Schema.Field> fieldsMap = new HashMap<String, Schema.Field>();
            String fieldName = this.wSourceField.getText();
            if (StringUtils.isNotEmpty((String)fieldName) && (valueMeta = (fields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName)).searchValueMeta(fieldName)) != null && valueMeta.getType() == 20 && (schema = ((ValueMetaAvroRecord)valueMeta).getSchema()) != null) {
                for (Schema.Field field : schema.getFields()) {
                    fieldsMap.put(field.name(), field);
                }
            }
            if (fieldsMap.isEmpty() && (filename = BaseDialog.presentFileDialog((Shell)this.shell, (String[])new String[]{"*.avro", "*.*"}, (String[])new String[]{"Avro files", "All files"}, (boolean)true)) != null) {
                PipelineMeta pipelineMeta = new PipelineMeta();
                pipelineMeta.setName("Get Avro file details");
                InjectorMeta injector = new InjectorMeta();
                injector.getInjectorFields().add(new InjectorField("filename", "String", "500", "-1"));
                TransformMeta injectorMeta = new TransformMeta("Filename", (ITransformMeta)injector);
                injectorMeta.setLocation(50, 50);
                pipelineMeta.addTransform(injectorMeta);
                AvroFileInputMeta fileInput = new AvroFileInputMeta();
                fileInput.setDataFilenameField("filename");
                fileInput.setOutputFieldName("avro");
                fileInput.setRowsLimit("1");
                TransformMeta fileInputMeta = new TransformMeta("Avro", (ITransformMeta)fileInput);
                fileInputMeta.setLocation(250, 50);
                pipelineMeta.addTransform(fileInputMeta);
                pipelineMeta.addPipelineHop(new PipelineHopMeta(injectorMeta, fileInputMeta));
                LocalPipelineEngine pipeline = new LocalPipelineEngine(pipelineMeta, this.variables, loggingObject);
                pipeline.setMetadataProvider(this.metadataProvider);
                pipeline.prepareExecution();
                pipeline.setPreview(true);
                RowProducer rowProducer = pipeline.addRowProducer("Filename", 0);
                IEngineComponent avroComponent = pipeline.findComponent("Avro", 0);
                avroComponent.addRowListener((IRowListener)new RowAdapter(){
                    private boolean first = true;

                    public void rowWrittenEvent(IRowMeta rowMeta, Object[] row) throws HopTransformException {
                        if (this.first) {
                            this.first = false;
                            int index = rowMeta.indexOfValue("avro");
                            ValueMetaAvroRecord avroMeta = (ValueMetaAvroRecord)rowMeta.getValueMeta(index);
                            Object avroValue = row[index];
                            try {
                                GenericRecord genericRecord = avroMeta.getGenericRecord(avroValue);
                                Schema schema = genericRecord.getSchema();
                                List fields = schema.getFields();
                                for (Schema.Field field : fields) {
                                    fieldsMap.put(field.name(), field);
                                }
                            }
                            catch (Exception e) {
                                throw new HopTransformException((Throwable)e);
                            }
                        }
                    }
                });
                pipeline.startThreads();
                rowProducer.putRow(new RowMetaBuilder().addString("filename").build(), new Object[]{this.variables.resolve(filename)});
                rowProducer.finished();
                pipeline.waitUntilFinished();
            }
            if (fieldsMap.isEmpty()) {
                return;
            }
            ArrayList names = new ArrayList(fieldsMap.keySet());
            names.sort(Comparator.comparing(String::toLowerCase));
            for (String name : names) {
                Schema.Field field = (Schema.Field)fieldsMap.get(name);
                String typeDesc = StringUtil.initCap((String)field.schema().getType().name().toLowerCase());
                int hopType = AvroDecode.getStandardHopType(field);
                String hopTypeDesc = ValueMetaFactory.getValueMetaName((int)hopType);
                TableItem item = new TableItem(this.wFields.table, 0);
                item.setText(1, Const.NVL((String)field.name(), (String)""));
                item.setText(2, typeDesc);
                item.setText(3, Const.NVL((String)field.name(), (String)""));
                item.setText(4, hopTypeDesc);
            }
            this.wFields.optimizeTableView();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting fields", e);
        }
    }
}

