/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.pipeline.transform.common;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.file.EncodingType;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transforms.common.ICsvInputAwareMeta;
import org.apache.hop.ui.pipeline.transform.common.ICsvInputAwareImportProgressDialog;
import org.apache.hop.ui.pipeline.transform.common.TextFileLineUtil;

public interface ICsvInputAwareTransformDialog {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String[] getFieldNames(ICsvInputAwareMeta meta) {
        String[] fieldNames = new String[]{};
        InputStream inputStream = this.getInputStream(meta);
        InputStreamReader reader = this.getReader(meta, inputStream);
        try {
            fieldNames = this.getFieldNamesImpl(reader, meta);
        }
        catch (HopException e) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFields.Message"), (Exception)((Object)e));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return fieldNames;
    }

    default public String[] getFieldNamesImpl(InputStreamReader reader, ICsvInputAwareMeta meta) throws HopException {
        CharSequence[] fieldNames = new String[]{};
        if (reader == null || meta == null) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFields.Message"));
            return fieldNames;
        }
        String delimiter = this.getVariables().resolve(meta.getDelimiter());
        String enclosure = this.getVariables().resolve(meta.getEnclosure());
        EncodingType encodingType = EncodingType.guessEncodingType((String)reader.getEncoding());
        String line = TextFileLineUtil.getLine((ILogChannel)this.getLogChannel(), reader, encodingType, meta.getFileFormatTypeNr(), new StringBuilder(1000));
        if (!StringUtils.isBlank((String)line)) {
            fieldNames = TextFileLineUtil.guessStringsFromLine((ILogChannel)this.getLogChannel(), line, delimiter, enclosure, meta.getEscapeCharacter());
        }
        if (Utils.isEmpty((CharSequence[])fieldNames)) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFields.Message"));
            return fieldNames;
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            fieldNames[i] = Const.trim((String)fieldNames[i]);
            if (!meta.hasHeader()) {
                DecimalFormat df = new DecimalFormat("000");
                fieldNames[i] = "Field_" + df.format(i);
            } else if (!Utils.isEmpty((CharSequence)meta.getEnclosure()) && ((String)fieldNames[i]).startsWith(meta.getEnclosure()) && ((String)fieldNames[i]).endsWith(meta.getEnclosure()) && ((String)fieldNames[i]).length() > 1) {
                fieldNames[i] = ((String)fieldNames[i]).substring(1, ((String)fieldNames[i]).length() - 1);
            }
            fieldNames[i] = Const.trim((String)fieldNames[i]);
            fieldNames[i] = this.massageFieldName((String)fieldNames[i]);
        }
        return fieldNames;
    }

    default public String massageFieldName(String fieldName) {
        return fieldName;
    }

    public InputStream getInputStream(ICsvInputAwareMeta var1);

    default public InputStreamReader getReader(ICsvInputAwareMeta meta, InputStream inputStream) {
        InputStreamReader reader = null;
        try {
            String realEncoding = this.getVariables().resolve(meta.getEncoding());
            if (Utils.isEmpty((CharSequence)realEncoding)) {
                reader = new InputStreamReader(inputStream);
            } else if (realEncoding.toUpperCase().startsWith("UTF")) {
                BOMInputStream bomInputStream = new BOMInputStream(inputStream);
                reader = new InputStreamReader((InputStream)bomInputStream, realEncoding);
            } else {
                reader = new InputStreamReader(inputStream, realEncoding);
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString((String)"Dialog.ErrorGettingFileDesc.DialogMessage"), e);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public String loadFieldsImpl(ICsvInputAwareMeta meta, int samples) {
        InputStream inputStream = this.getInputStream(meta);
        try {
            String message;
            InputStreamReader reader = this.getReader(meta, inputStream);
            ICsvInputAwareImportProgressDialog pd = this.getCsvImportProgressDialog(meta, samples, reader);
            String string = message = pd.open(false);
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public ICsvInputAwareImportProgressDialog getCsvImportProgressDialog(ICsvInputAwareMeta var1, int var2, InputStreamReader var3);

    default public void logError(String message, Exception exception) {
        this.getLogChannel().logError(message, (Throwable)exception);
    }

    default public void logError(String message) {
        this.getLogChannel().logError(message);
    }

    public LogChannel getLogChannel();

    public PipelineMeta getPipelineMeta();

    public IVariables getVariables();
}

