/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.hopgui.delegates;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.history.AuditList;
import org.apache.hop.history.AuditManager;
import org.apache.hop.history.AuditState;
import org.apache.hop.history.AuditStateMap;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IHopMetadataSerializer;
import org.apache.hop.metadata.serializer.multi.MultiMetadataProvider;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.gui.HopNamespace;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataManager;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.IHopPerspective;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;

public class HopGuiAuditDelegate {
    public static final String STATE_PROPERTY_ACTIVE = "active";
    public static final String METADATA_FILENAME_PREFIX = "METADATA:";
    private HopGui hopGui;

    public HopGuiAuditDelegate(HopGui hopGui) {
        this.hopGui = hopGui;
    }

    public void openLastFiles() {
        if (!this.hopGui.getProps().openLastFile()) {
            return;
        }
        List<IHopPerspective> perspectives = this.hopGui.getPerspectiveManager().getPerspectives();
        for (IHopPerspective perspective : perspectives) {
            AuditStateMap auditStateMap;
            AuditList auditList;
            List<TabItemHandler> tabItems = perspective.getItems();
            IHopFileTypeHandler activeFileTypeHandler = null;
            if (tabItems == null) continue;
            try {
                auditList = AuditManager.getActive().retrieveList(HopNamespace.getNamespace(), perspective.getId());
            }
            catch (Exception e) {
                this.hopGui.getLog().logError("Error reading audit list of perspective " + perspective.getId(), (Throwable)e);
                auditList = new AuditList();
            }
            try {
                auditStateMap = AuditManager.getActive().loadAuditStateMap(HopNamespace.getNamespace(), perspective.getId());
            }
            catch (HopException e) {
                this.hopGui.getLog().logError("Error loading audit state map of perspective " + perspective.getId(), (Throwable)e);
                auditStateMap = new AuditStateMap();
            }
            for (String filename : auditList.getNames()) {
                try {
                    AuditState auditState;
                    if (!StringUtils.isNotEmpty((String)filename)) continue;
                    if (filename.startsWith(METADATA_FILENAME_PREFIX)) {
                        int colonIndex = filename.indexOf(":", METADATA_FILENAME_PREFIX.length() + 1);
                        if (colonIndex <= 0) continue;
                        String className = filename.substring(METADATA_FILENAME_PREFIX.length(), colonIndex);
                        String name = filename.substring(colonIndex + 1);
                        this.openMetadataObject(className, name);
                        continue;
                    }
                    IHopFileTypeHandler fileTypeHandler = this.hopGui.fileDelegate.fileOpen(filename);
                    if (fileTypeHandler == null || (auditState = auditStateMap.get(filename)) == null || fileTypeHandler == null) continue;
                    fileTypeHandler.applyStateProperties(auditState.getStateMap());
                    Boolean bActive = (Boolean)auditState.getStateMap().get(STATE_PROPERTY_ACTIVE);
                    if (bActive == null || !bActive.booleanValue()) continue;
                    activeFileTypeHandler = fileTypeHandler;
                }
                catch (Exception e) {
                    new ErrorDialog(this.hopGui.getShell(), "Error", "Error opening file '" + filename + "'", e);
                }
            }
            if (activeFileTypeHandler == null) continue;
            perspective.setActiveFileTypeHandler(activeFileTypeHandler);
        }
    }

    private void openMetadataObject(String className, String name) throws HopException {
        try {
            MultiMetadataProvider metadataProvider = this.hopGui.getMetadataProvider();
            MetadataPerspective perspective = MetadataPerspective.getInstance();
            List metadataClasses = metadataProvider.getMetadataClasses();
            for (Class metadataClass : metadataClasses) {
                IHopMetadataSerializer serializer;
                if (!metadataClass.getName().equals(className) || !(serializer = metadataProvider.getSerializer(metadataClass)).exists(name)) continue;
                IHopMetadata metadata = serializer.load(name);
                MetadataManager<IHopMetadata> metadataManager = new MetadataManager<IHopMetadata>(HopGui.getInstance().getVariables(), (IHopMetadataProvider)metadataProvider, metadataClass);
                MetadataEditor<IHopMetadata> editor = metadataManager.createEditor(metadata);
                perspective.addEditor(editor);
            }
        }
        catch (Exception e) {
            throw new HopException("Error opening metadata object '" + name + "' of class " + className, (Throwable)e);
        }
    }

    public void writeLastOpenFiles() {
        if (!this.hopGui.getProps().openLastFile()) {
            return;
        }
        List<IHopPerspective> perspectives = this.hopGui.getPerspectiveManager().getPerspectives();
        for (IHopPerspective perspective : perspectives) {
            IHopFileTypeHandler activeFileTypeHandler = perspective.getActiveFileTypeHandler();
            List<TabItemHandler> tabItems = perspective.getItems();
            if (tabItems == null) continue;
            AuditStateMap auditStateMap = new AuditStateMap();
            ArrayList<Object> files = new ArrayList<Object>();
            for (TabItemHandler tabItem : tabItems) {
                IHopFileTypeHandler typeHandler = tabItem.getTypeHandler();
                String filename = typeHandler.getFilename();
                String name = typeHandler.getName();
                if (StringUtils.isNotEmpty((String)filename)) {
                    files.add(filename);
                    Map<String, Object> stateProperties = typeHandler.getStateProperties();
                    boolean active = activeFileTypeHandler != null && activeFileTypeHandler.getFilename() != null && activeFileTypeHandler.getFilename().equals(filename);
                    stateProperties.put(STATE_PROPERTY_ACTIVE, active);
                    auditStateMap.add(new AuditState(filename, stateProperties));
                    continue;
                }
                if (!(typeHandler instanceof MetadataEditor) || !StringUtils.isNotEmpty((String)name)) continue;
                MetadataEditor metadataEditor = (MetadataEditor)typeHandler;
                Object metadata = metadataEditor.getMetadata();
                Class<?> metadataClass = metadata.getClass();
                files.add(METADATA_FILENAME_PREFIX + metadataClass.getName() + ":" + name);
            }
            AuditList auditList = new AuditList(files);
            try {
                AuditManager.getActive().storeList(HopNamespace.getNamespace(), perspective.getId(), auditList);
                AuditManager.getActive().saveAuditStateMap(HopNamespace.getNamespace(), perspective.getId(), auditStateMap);
            }
            catch (Exception e) {
                this.hopGui.getLog().logError("Error writing audit list of perspective " + perspective.getId(), (Throwable)e);
            }
        }
    }
}

