/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.metadata.api.IHopMetadata;
import org.apache.hop.ui.core.metadata.MetadataEditor;
import org.apache.hop.ui.core.metadata.MetadataFileType;
import org.apache.hop.ui.hopgui.context.IGuiContextHandler;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.file.IHopFileTypeHandler;
import org.apache.hop.ui.hopgui.perspective.TabItemHandler;
import org.apache.hop.ui.hopgui.perspective.metadata.MetadataPerspective;
import org.eclipse.swt.custom.CTabItem;

public class MetadataFileTypeHandler<T extends IHopMetadata>
implements IHopFileTypeHandler {
    private static final IHopFileType fileType = new MetadataFileType();
    private T metadata;

    public MetadataFileTypeHandler(T metadata) {
        this.metadata = metadata;
    }

    @Override
    public Object getSubject() {
        return null;
    }

    @Override
    public String getName() {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.getName();
    }

    @Override
    public void setName(String name) {
        if (this.metadata == null) {
            return;
        }
        this.metadata.setName(name);
    }

    @Override
    public IHopFileType getFileType() {
        return fileType;
    }

    @Override
    public String getFilename() {
        return null;
    }

    @Override
    public void setFilename(String filename) {
    }

    @Override
    public void save() throws HopException {
    }

    @Override
    public void saveAs(String filename) throws HopException {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void resume() {
    }

    @Override
    public void preview() {
    }

    @Override
    public void debug() {
    }

    @Override
    public void redraw() {
    }

    @Override
    public void updateGui() {
    }

    @Override
    public void selectAll() {
    }

    @Override
    public void unselectAll() {
    }

    @Override
    public void copySelectedToClipboard() {
    }

    @Override
    public void cutSelectedToClipboard() {
    }

    @Override
    public void deleteSelected() {
    }

    @Override
    public void pasteFromClipboard() {
    }

    private TabItemHandler findTabItemHandler() {
        if (this.metadata == null) {
            return null;
        }
        MetadataPerspective perspective = MetadataPerspective.getInstance();
        for (TabItemHandler tabItemHandler : perspective.getItems()) {
            CTabItem tabItem = tabItemHandler.getTabItem();
            MetadataEditor editor = (MetadataEditor)tabItem.getData();
            Object other = editor.getMetadata();
            if (!other.equals(this.metadata)) continue;
            return tabItemHandler;
        }
        return null;
    }

    @Override
    public boolean isCloseable() {
        TabItemHandler tabItemHandler = this.findTabItemHandler();
        if (tabItemHandler == null) {
            return true;
        }
        IHopFileTypeHandler typeHandler = tabItemHandler.getTypeHandler();
        return typeHandler.isCloseable();
    }

    @Override
    public void close() {
        TabItemHandler tabItemHandler = this.findTabItemHandler();
        if (tabItemHandler == null) {
            return;
        }
        CTabItem tabItem = tabItemHandler.getTabItem();
        tabItem.dispose();
        MetadataPerspective.getInstance().remove(tabItemHandler.getTypeHandler());
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public void redo() {
    }

    @Override
    public Map<String, Object> getStateProperties() {
        return Collections.emptyMap();
    }

    @Override
    public void applyStateProperties(Map<String, Object> stateProperties) {
    }

    @Override
    public List<IGuiContextHandler> getContextHandlers() {
        ArrayList<IGuiContextHandler> handlers = new ArrayList<IGuiContextHandler>();
        return handlers;
    }

    @Override
    public IVariables getVariables() {
        return new Variables();
    }
}

